// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#include "google/cloud/asset/asset_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace asset {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AssetServiceConnectionIdempotencyPolicy::
    ~AssetServiceConnectionIdempotencyPolicy() = default;

namespace {
class DefaultAssetServiceConnectionIdempotencyPolicy
    : public AssetServiceConnectionIdempotencyPolicy {
 public:
  ~DefaultAssetServiceConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<AssetServiceConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultAssetServiceConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ExportAssets(
      google::cloud::asset::v1::ExportAssetsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListAssets(google::cloud::asset::v1::ListAssetsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency BatchGetAssetsHistory(
      google::cloud::asset::v1::BatchGetAssetsHistoryRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateFeed(
      google::cloud::asset::v1::CreateFeedRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetFeed(
      google::cloud::asset::v1::GetFeedRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListFeeds(
      google::cloud::asset::v1::ListFeedsRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateFeed(
      google::cloud::asset::v1::UpdateFeedRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteFeed(
      google::cloud::asset::v1::DeleteFeedRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency SearchAllResources(
      google::cloud::asset::v1::SearchAllResourcesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency SearchAllIamPolicies(
      google::cloud::asset::v1::SearchAllIamPoliciesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency AnalyzeIamPolicy(
      google::cloud::asset::v1::AnalyzeIamPolicyRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency AnalyzeIamPolicyLongrunning(
      google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency AnalyzeMove(
      google::cloud::asset::v1::AnalyzeMoveRequest const&) override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<AssetServiceConnectionIdempotencyPolicy>
MakeDefaultAssetServiceConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultAssetServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset
}  // namespace cloud
}  // namespace google
