// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/asset/v1/asset_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_ASSET_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_ASSET_CLIENT_H

#include "google/cloud/asset/asset_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace asset {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Asset service definition.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AssetServiceClient {
 public:
  explicit AssetServiceClient(
      std::shared_ptr<AssetServiceConnection> connection, Options options = {});
  ~AssetServiceClient();

  //@{
  // @name Copy and move support
  AssetServiceClient(AssetServiceClient const&) = default;
  AssetServiceClient& operator=(AssetServiceClient const&) = default;
  AssetServiceClient(AssetServiceClient&&) = default;
  AssetServiceClient& operator=(AssetServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(AssetServiceClient const& a,
                         AssetServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AssetServiceClient const& a,
                         AssetServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Exports assets with time and resource types to a given Cloud Storage
  /// location/BigQuery table. For Cloud Storage location destinations, the
  /// output format is newline-delimited JSON. Each line represents a
  /// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
  /// format; for BigQuery table destinations, the output table stores the
  /// fields in asset proto as columns. This API implements the
  /// [google.longrunning.Operation][google.longrunning.Operation] API , which
  /// allows you to keep track of the export. We recommend intervals of at least
  /// 2 seconds with exponential retry to poll the export operation result. For
  /// regular-size resource parent, the export operation usually finishes within
  /// 5 minutes.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::ExportAssetsRequest,google/cloud/asset/v1/asset_service.proto#L201}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::ExportAssetsResponse,google/cloud/asset/v1/asset_service.proto#L268}
  ///
  /// [google.cloud.asset.v1.ExportAssetsRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L201}
  /// [google.cloud.asset.v1.ExportAssetsResponse]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L268}
  ///
  future<StatusOr<google::cloud::asset::v1::ExportAssetsResponse>> ExportAssets(
      google::cloud::asset::v1::ExportAssetsRequest const& request,
      Options options = {});

  ///
  /// Lists assets with time and resource types and returns paged results in
  /// response.
  ///
  /// @param parent  Required. Name of the organization or project the assets
  /// belong to. Format:
  ///  "organizations/[organization-number]" (such as "organizations/123"),
  ///  "projects/[project-id]" (such as "projects/my-project-id"), or
  ///  "projects/[project-number]" (such as "projects/12345").
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Asset,google/cloud/asset/v1/assets.proto#L97}
  ///
  /// [google.cloud.asset.v1.ListAssetsRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L284}
  /// [google.cloud.asset.v1.Asset]:
  /// @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L97}
  ///
  StreamRange<google::cloud::asset::v1::Asset> ListAssets(
      std::string const& parent, Options options = {});

  ///
  /// Lists assets with time and resource types and returns paged results in
  /// response.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::ListAssetsRequest,google/cloud/asset/v1/asset_service.proto#L284}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Asset,google/cloud/asset/v1/assets.proto#L97}
  ///
  /// [google.cloud.asset.v1.ListAssetsRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L284}
  /// [google.cloud.asset.v1.Asset]:
  /// @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L97}
  ///
  StreamRange<google::cloud::asset::v1::Asset> ListAssets(
      google::cloud::asset::v1::ListAssetsRequest request,
      Options options = {});

  ///
  /// Batch gets the update history of assets that overlap a time window.
  /// For IAM_POLICY content, this API outputs history when the asset and its
  /// attached IAM POLICY both exist. This can create gaps in the output
  /// history. Otherwise, this API outputs history with asset in both non-delete
  /// or deleted status. If a specified asset does not exist, this API returns
  /// an INVALID_ARGUMENT error.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::BatchGetAssetsHistoryRequest,google/cloud/asset/v1/asset_service.proto#L369}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::BatchGetAssetsHistoryResponse,google/cloud/asset/v1/asset_service.proto#L421}
  ///
  /// [google.cloud.asset.v1.BatchGetAssetsHistoryRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L369}
  /// [google.cloud.asset.v1.BatchGetAssetsHistoryResponse]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L421}
  ///
  StatusOr<google::cloud::asset::v1::BatchGetAssetsHistoryResponse>
  BatchGetAssetsHistory(
      google::cloud::asset::v1::BatchGetAssetsHistoryRequest const& request,
      Options options = {});

  ///
  /// Creates a feed in a parent project/folder/organization to listen to its
  /// asset updates.
  ///
  /// @param parent  Required. The name of the project/folder/organization where
  /// this feed
  ///  should be created in. It can only be an organization number (such as
  ///  "organizations/123"), a folder number (such as "folders/123"), a project
  ///  ID (such as "projects/my-project-id")", or a project number (such as
  ///  "projects/12345").
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Feed,google/cloud/asset/v1/asset_service.proto#L677}
  ///
  /// [google.cloud.asset.v1.CreateFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L427}
  /// [google.cloud.asset.v1.Feed]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L677}
  ///
  StatusOr<google::cloud::asset::v1::Feed> CreateFeed(std::string const& parent,
                                                      Options options = {});

  ///
  /// Creates a feed in a parent project/folder/organization to listen to its
  /// asset updates.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::CreateFeedRequest,google/cloud/asset/v1/asset_service.proto#L427}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Feed,google/cloud/asset/v1/asset_service.proto#L677}
  ///
  /// [google.cloud.asset.v1.CreateFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L427}
  /// [google.cloud.asset.v1.Feed]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L677}
  ///
  StatusOr<google::cloud::asset::v1::Feed> CreateFeed(
      google::cloud::asset::v1::CreateFeedRequest const& request,
      Options options = {});

  ///
  /// Gets details about an asset feed.
  ///
  /// @param name  Required. The name of the Feed and it must be in the format
  /// of:
  ///  projects/project_number/feeds/feed_id
  ///  folders/folder_number/feeds/feed_id
  ///  organizations/organization_number/feeds/feed_id
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Feed,google/cloud/asset/v1/asset_service.proto#L677}
  ///
  /// [google.cloud.asset.v1.GetFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L448}
  /// [google.cloud.asset.v1.Feed]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L677}
  ///
  StatusOr<google::cloud::asset::v1::Feed> GetFeed(std::string const& name,
                                                   Options options = {});

  ///
  /// Gets details about an asset feed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::GetFeedRequest,google/cloud/asset/v1/asset_service.proto#L448}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Feed,google/cloud/asset/v1/asset_service.proto#L677}
  ///
  /// [google.cloud.asset.v1.GetFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L448}
  /// [google.cloud.asset.v1.Feed]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L677}
  ///
  StatusOr<google::cloud::asset::v1::Feed> GetFeed(
      google::cloud::asset::v1::GetFeedRequest const& request,
      Options options = {});

  ///
  /// Lists all asset feeds in a parent project/folder/organization.
  ///
  /// @param parent  Required. The parent project/folder/organization whose
  /// feeds are to be
  ///  listed. It can only be using project/folder/organization number (such as
  ///  "folders/12345")", or a project ID (such as "projects/my-project-id").
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::ListFeedsResponse,google/cloud/asset/v1/asset_service.proto#L469}
  ///
  /// [google.cloud.asset.v1.ListFeedsRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L462}
  /// [google.cloud.asset.v1.ListFeedsResponse]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L469}
  ///
  StatusOr<google::cloud::asset::v1::ListFeedsResponse> ListFeeds(
      std::string const& parent, Options options = {});

  ///
  /// Lists all asset feeds in a parent project/folder/organization.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::ListFeedsRequest,google/cloud/asset/v1/asset_service.proto#L462}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::ListFeedsResponse,google/cloud/asset/v1/asset_service.proto#L469}
  ///
  /// [google.cloud.asset.v1.ListFeedsRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L462}
  /// [google.cloud.asset.v1.ListFeedsResponse]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L469}
  ///
  StatusOr<google::cloud::asset::v1::ListFeedsResponse> ListFeeds(
      google::cloud::asset::v1::ListFeedsRequest const& request,
      Options options = {});

  ///
  /// Updates an asset feed configuration.
  ///
  /// @param feed  Required. The new values of feed details. It must match an
  /// existing feed and the
  ///  field `name` must be in the format of:
  ///  projects/project_number/feeds/feed_id or
  ///  folders/folder_number/feeds/feed_id or
  ///  organizations/organization_number/feeds/feed_id.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Feed,google/cloud/asset/v1/asset_service.proto#L677}
  ///
  /// [google.cloud.asset.v1.UpdateFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L475}
  /// [google.cloud.asset.v1.Feed]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L677}
  ///
  StatusOr<google::cloud::asset::v1::Feed> UpdateFeed(
      google::cloud::asset::v1::Feed const& feed, Options options = {});

  ///
  /// Updates an asset feed configuration.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::UpdateFeedRequest,google/cloud/asset/v1/asset_service.proto#L475}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::Feed,google/cloud/asset/v1/asset_service.proto#L677}
  ///
  /// [google.cloud.asset.v1.UpdateFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L475}
  /// [google.cloud.asset.v1.Feed]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L677}
  ///
  StatusOr<google::cloud::asset::v1::Feed> UpdateFeed(
      google::cloud::asset::v1::UpdateFeedRequest const& request,
      Options options = {});

  ///
  /// Deletes an asset feed.
  ///
  /// @param name  Required. The name of the feed and it must be in the format
  /// of:
  ///  projects/project_number/feeds/feed_id
  ///  folders/folder_number/feeds/feed_id
  ///  organizations/organization_number/feeds/feed_id
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.asset.v1.DeleteFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L489}
  ///
  Status DeleteFeed(std::string const& name, Options options = {});

  ///
  /// Deletes an asset feed.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::DeleteFeedRequest,google/cloud/asset/v1/asset_service.proto#L489}
  /// @param options  Optional. Operation options.
  ///
  /// [google.cloud.asset.v1.DeleteFeedRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L489}
  ///
  Status DeleteFeed(google::cloud::asset::v1::DeleteFeedRequest const& request,
                    Options options = {});

  ///
  /// Searches all Cloud resources within the specified scope, such as a
  /// project, folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllResources` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param scope  Required. A scope can be a project, a folder, or an
  /// organization. The search is
  ///  limited to the resources within the `scope`. The caller must be granted
  ///  the
  ///  [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
  ///  permission on the desired scope.
  ///  The allowed values are:
  ///  * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
  ///  * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
  ///  * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
  ///  * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  /// @param query  Optional. The query statement. See [how to construct a
  ///  query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
  ///  for more information. If not specified or empty, it will search all the
  ///  resources within the specified `scope`.
  ///  Examples:
  ///  * `name:Important` to find Cloud resources whose name contains
  ///    "Important" as a word.
  ///  * `name=Important` to find the Cloud resource whose name is exactly
  ///    "Important".
  ///  * `displayName:Impor*` to find Cloud resources whose display name
  ///    contains "Impor" as a prefix of any word in the field.
  ///  * `location:us-west*` to find Cloud resources whose location contains
  ///  both
  ///    "us" and "west" as prefixes.
  ///  * `labels:prod` to find Cloud resources whose labels contain "prod" as
  ///    a key or value.
  ///  * `labels.env:prod` to find Cloud resources that have a label "env"
  ///    and its value is "prod".
  ///  * `labels.env:*` to find Cloud resources that have a label "env".
  ///  * `kmsKey:key` to find Cloud resources encrypted with a customer-managed
  ///    encryption key whose name contains the word "key".
  ///  * `state:ACTIVE` to find Cloud resources whose state contains "ACTIVE" as
  ///  a
  ///    word.
  ///  * `NOT state:ACTIVE` to find Cloud resources whose state doesn't contain
  ///    "ACTIVE" as a word.
  ///  * `createTime<1609459200` to find Cloud resources that were created
  ///  before
  ///    "2021-01-01 00:00:00 UTC". 1609459200 is the epoch timestamp of
  ///    "2021-01-01 00:00:00 UTC" in seconds.
  ///  * `updateTime>1609459200` to find Cloud resources that were updated after
  ///    "2021-01-01 00:00:00 UTC". 1609459200 is the epoch timestamp of
  ///    "2021-01-01 00:00:00 UTC" in seconds.
  ///  * `Important` to find Cloud resources that contain "Important" as a word
  ///    in any of the searchable fields.
  ///  * `Impor*` to find Cloud resources that contain "Impor" as a prefix of
  ///  any
  ///    word in any of the searchable fields.
  ///  * `Important location:(us-west1 OR global)` to find Cloud
  ///    resources that contain "Important" as a word in any of the searchable
  ///    fields and are also located in the "us-west1" region or the "global"
  ///    location.
  /// @param asset_types  Optional. A list of asset types that this request
  /// searches for. If empty, it will
  ///  search all the [searchable asset
  ///  types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
  ///  Regular expressions are also supported. For example:
  ///  * "compute.googleapis.com.*" snapshots resources whose asset type starts
  ///  with "compute.googleapis.com".
  ///  * ".*Instance" snapshots resources whose asset type ends with "Instance".
  ///  * ".*Instance.*" snapshots resources whose asset type contains
  ///  "Instance". See [RE2](https://github.com/google/re2/wiki/Syntax) for all
  ///  supported regular expression syntax. If the regular expression does not
  ///  match any supported asset type, an INVALID_ARGUMENT error will be
  ///  returned.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::ResourceSearchResult,google/cloud/asset/v1/assets.proto#L290}
  ///
  /// [google.cloud.asset.v1.SearchAllResourcesRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L757}
  /// [google.cloud.asset.v1.ResourceSearchResult]:
  /// @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L290}
  ///
  StreamRange<google::cloud::asset::v1::ResourceSearchResult>
  SearchAllResources(std::string const& scope, std::string const& query,
                     std::vector<std::string> const& asset_types,
                     Options options = {});

  ///
  /// Searches all Cloud resources within the specified scope, such as a
  /// project, folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllResources` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::SearchAllResourcesRequest,google/cloud/asset/v1/asset_service.proto#L757}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::ResourceSearchResult,google/cloud/asset/v1/assets.proto#L290}
  ///
  /// [google.cloud.asset.v1.SearchAllResourcesRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L757}
  /// [google.cloud.asset.v1.ResourceSearchResult]:
  /// @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L290}
  ///
  StreamRange<google::cloud::asset::v1::ResourceSearchResult>
  SearchAllResources(
      google::cloud::asset::v1::SearchAllResourcesRequest request,
      Options options = {});

  ///
  /// Searches all IAM policies within the specified scope, such as a project,
  /// folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param scope  Required. A scope can be a project, a folder, or an
  /// organization. The search is
  ///  limited to the IAM policies within the `scope`. The caller must be
  ///  granted the
  ///  [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
  ///  permission on the desired scope.
  ///  The allowed values are:
  ///  * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
  ///  * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
  ///  * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
  ///  * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
  /// @param query  Optional. The query statement. See [how to construct a
  ///  query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
  ///  for more information. If not specified or empty, it will search all the
  ///  IAM policies within the specified `scope`. Note that the query string is
  ///  compared against each Cloud IAM policy binding, including its members,
  ///  roles, and Cloud IAM conditions. The returned Cloud IAM policies will
  ///  only contain the bindings that match your query. To learn more about the
  ///  IAM policy structure, see [IAM policy
  ///  doc](https://cloud.google.com/iam/docs/policies#structure).
  ///  Examples:
  ///  * `policy:amy@gmail.com` to find IAM policy bindings that specify user
  ///    "amy@gmail.com".
  ///  * `policy:roles/compute.admin` to find IAM policy bindings that specify
  ///    the Compute Admin role.
  ///  * `policy:comp*` to find IAM policy bindings that contain "comp" as a
  ///    prefix of any word in the binding.
  ///  * `policy.role.permissions:storage.buckets.update` to find IAM policy
  ///    bindings that specify a role containing "storage.buckets.update"
  ///    permission. Note that if callers don't have `iam.roles.get` access to a
  ///    role's included permissions, policy bindings that specify this role
  ///    will be dropped from the search results.
  ///  * `policy.role.permissions:upd*` to find IAM policy bindings that specify
  ///  a
  ///    role containing "upd" as a prefix of any word in the role permission.
  ///    Note that if callers don't have `iam.roles.get` access to a role's
  ///    included permissions, policy bindings that specify this role will be
  ///    dropped from the search results.
  ///  * `resource:organizations/123456` to find IAM policy bindings
  ///    that are set on "organizations/123456".
  ///  * `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to
  ///    find IAM policy bindings that are set on the project named "myproject".
  ///  * `Important` to find IAM policy bindings that contain "Important" as a
  ///    word in any of the searchable fields (except for the included
  ///    permissions).
  ///  * `resource:(instance1 OR instance2) policy:amy` to find
  ///    IAM policy bindings that are set on resources "instance1" or
  ///    "instance2" and also specify user "amy".
  ///  * `roles:roles/compute.admin` to find IAM policy bindings that specify
  ///  the
  ///    Compute Admin role.
  ///  * `memberTypes:user` to find IAM policy bindings that contain the "user"
  ///    member type.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::IamPolicySearchResult,google/cloud/asset/v1/assets.proto#L586}
  ///
  /// [google.cloud.asset.v1.SearchAllIamPoliciesRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L909}
  /// [google.cloud.asset.v1.IamPolicySearchResult]:
  /// @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L586}
  ///
  StreamRange<google::cloud::asset::v1::IamPolicySearchResult>
  SearchAllIamPolicies(std::string const& scope, std::string const& query,
                       Options options = {});

  ///
  /// Searches all IAM policies within the specified scope, such as a project,
  /// folder, or organization. The caller must be granted the
  /// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
  /// otherwise the request will be rejected.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::SearchAllIamPoliciesRequest,google/cloud/asset/v1/asset_service.proto#L909}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::IamPolicySearchResult,google/cloud/asset/v1/assets.proto#L586}
  ///
  /// [google.cloud.asset.v1.SearchAllIamPoliciesRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L909}
  /// [google.cloud.asset.v1.IamPolicySearchResult]:
  /// @googleapis_reference_link{google/cloud/asset/v1/assets.proto#L586}
  ///
  StreamRange<google::cloud::asset::v1::IamPolicySearchResult>
  SearchAllIamPolicies(
      google::cloud::asset::v1::SearchAllIamPoliciesRequest request,
      Options options = {});

  ///
  /// Analyzes IAM policies to answer which identities have what accesses on
  /// which resources.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::AnalyzeIamPolicyRequest,google/cloud/asset/v1/asset_service.proto#L1191}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::AnalyzeIamPolicyResponse,google/cloud/asset/v1/asset_service.proto#L1209}
  ///
  /// [google.cloud.asset.v1.AnalyzeIamPolicyRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1191}
  /// [google.cloud.asset.v1.AnalyzeIamPolicyResponse]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1209}
  ///
  StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyResponse> AnalyzeIamPolicy(
      google::cloud::asset::v1::AnalyzeIamPolicyRequest const& request,
      Options options = {});

  ///
  /// Analyzes IAM policies asynchronously to answer which identities have what
  /// accesses on which resources, and writes the analysis results to a Google
  /// Cloud Storage or a BigQuery destination. For Cloud Storage destination,
  /// the output format is the JSON format that represents a
  /// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
  /// This method implements the
  /// [google.longrunning.Operation][google.longrunning.Operation], which allows
  /// you to track the operation status. We recommend intervals of at least 2
  /// seconds with exponential backoff retry to poll the operation result. The
  /// metadata contains the metadata for the long-running operation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest,google/cloud/asset/v1/asset_service.proto#L1318}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse,google/cloud/asset/v1/asset_service.proto#L1327}
  ///
  /// [google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1318}
  /// [google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1327}
  ///
  future<
      StatusOr<google::cloud::asset::v1::AnalyzeIamPolicyLongrunningResponse>>
  AnalyzeIamPolicyLongrunning(
      google::cloud::asset::v1::AnalyzeIamPolicyLongrunningRequest const&
          request,
      Options options = {});

  ///
  /// Analyze moving a resource to a specified destination without kicking off
  /// the actual move. The analysis is best effort depending on the user's
  /// permissions of viewing different hierarchical policies and configurations.
  /// The policies and configuration are subject to change before the actual
  /// resource migration takes place.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::asset::v1::AnalyzeMoveRequest,google/cloud/asset/v1/asset_service.proto#L1332}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::asset::v1::AnalyzeMoveResponse,google/cloud/asset/v1/asset_service.proto#L1367}
  ///
  /// [google.cloud.asset.v1.AnalyzeMoveRequest]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1332}
  /// [google.cloud.asset.v1.AnalyzeMoveResponse]:
  /// @googleapis_reference_link{google/cloud/asset/v1/asset_service.proto#L1367}
  ///
  StatusOr<google::cloud::asset::v1::AnalyzeMoveResponse> AnalyzeMove(
      google::cloud::asset::v1::AnalyzeMoveRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<AssetServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace asset
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ASSET_ASSET_CLIENT_H
