// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#include "google/cloud/artifactregistry/internal/artifact_registry_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/devtools/artifactregistry/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace artifactregistry_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ArtifactRegistryMetadata::ArtifactRegistryMetadata(
    std::shared_ptr<ArtifactRegistryStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::devtools::artifactregistry::v1::ListDockerImagesResponse>
ArtifactRegistryMetadata::ListDockerImages(
    grpc::ClientContext& context,
    google::devtools::artifactregistry::v1::ListDockerImagesRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListDockerImages(context, request);
}

StatusOr<google::devtools::artifactregistry::v1::ListRepositoriesResponse>
ArtifactRegistryMetadata::ListRepositories(
    grpc::ClientContext& context,
    google::devtools::artifactregistry::v1::ListRepositoriesRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListRepositories(context, request);
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryMetadata::GetRepository(
    grpc::ClientContext& context,
    google::devtools::artifactregistry::v1::GetRepositoryRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetRepository(context, request);
}

void ArtifactRegistryMetadata::SetMetadata(grpc::ClientContext& context,
                                           std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void ArtifactRegistryMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_internal
}  // namespace cloud
}  // namespace google
