// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_ARTIFACT_REGISTRY_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_ARTIFACT_REGISTRY_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/devtools/artifactregistry/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace artifactregistry {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ArtifactRegistryConnectionIdempotencyPolicy {
 public:
  virtual ~ArtifactRegistryConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<ArtifactRegistryConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency ListDockerImages(
      google::devtools::artifactregistry::v1::ListDockerImagesRequest
          request) = 0;

  virtual google::cloud::Idempotency ListRepositories(
      google::devtools::artifactregistry::v1::ListRepositoriesRequest
          request) = 0;

  virtual google::cloud::Idempotency GetRepository(
      google::devtools::artifactregistry::v1::GetRepositoryRequest const&
          request) = 0;
};

std::unique_ptr<ArtifactRegistryConnectionIdempotencyPolicy>
MakeDefaultArtifactRegistryConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_ARTIFACT_REGISTRY_CONNECTION_IDEMPOTENCY_POLICY_H
