// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#include "google/cloud/artifactregistry/artifact_registry_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace artifactregistry {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ArtifactRegistryConnectionIdempotencyPolicy::
    ~ArtifactRegistryConnectionIdempotencyPolicy() = default;

namespace {
class DefaultArtifactRegistryConnectionIdempotencyPolicy
    : public ArtifactRegistryConnectionIdempotencyPolicy {
 public:
  ~DefaultArtifactRegistryConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ArtifactRegistryConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultArtifactRegistryConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListDockerImages(
      google::devtools::artifactregistry::v1::ListDockerImagesRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ListRepositories(
      google::devtools::artifactregistry::v1::ListRepositoriesRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetRepository(
      google::devtools::artifactregistry::v1::GetRepositoryRequest const&)
      override {
    return Idempotency::kIdempotent;
  }
};
}  // namespace

std::unique_ptr<ArtifactRegistryConnectionIdempotencyPolicy>
MakeDefaultArtifactRegistryConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultArtifactRegistryConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry
}  // namespace cloud
}  // namespace google
