// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#include "google/cloud/artifactregistry/artifact_registry_connection.h"
#include "google/cloud/artifactregistry/artifact_registry_options.h"
#include "google/cloud/artifactregistry/internal/artifact_registry_connection_impl.h"
#include "google/cloud/artifactregistry/internal/artifact_registry_option_defaults.h"
#include "google/cloud/artifactregistry/internal/artifact_registry_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace artifactregistry {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ArtifactRegistryConnection::~ArtifactRegistryConnection() = default;

StreamRange<google::devtools::artifactregistry::v1::DockerImage>
ArtifactRegistryConnection::ListDockerImages(
    google::devtools::artifactregistry::v1::ListDockerImagesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::DockerImage>>(
      std::move(request),
      [](google::devtools::artifactregistry::v1::
             ListDockerImagesRequest const&) {
        return StatusOr<
            google::devtools::artifactregistry::v1::ListDockerImagesResponse>{};
      },
      [](google::devtools::artifactregistry::v1::
             ListDockerImagesResponse const&) {
        return std::vector<
            google::devtools::artifactregistry::v1::DockerImage>();
      });
}

StreamRange<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryConnection::ListRepositories(
    google::devtools::artifactregistry::v1::ListRepositoriesRequest request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::devtools::artifactregistry::v1::Repository>>(
      std::move(request),
      [](google::devtools::artifactregistry::v1::
             ListRepositoriesRequest const&) {
        return StatusOr<
            google::devtools::artifactregistry::v1::ListRepositoriesResponse>{};
      },
      [](google::devtools::artifactregistry::v1::
             ListRepositoriesResponse const&) {
        return std::vector<
            google::devtools::artifactregistry::v1::Repository>();
      });
}

StatusOr<google::devtools::artifactregistry::v1::Repository>
ArtifactRegistryConnection::GetRepository(
    google::devtools::artifactregistry::v1::GetRepositoryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ArtifactRegistryConnection> MakeArtifactRegistryConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 ArtifactRegistryPolicyOptionList>(options,
                                                                   __func__);
  options = artifactregistry_internal::ArtifactRegistryDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = artifactregistry_internal::CreateDefaultArtifactRegistryStub(
      background->cq(), options);
  return std::make_shared<
      artifactregistry_internal::ArtifactRegistryConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace artifactregistry_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<artifactregistry::ArtifactRegistryConnection>
MakeArtifactRegistryConnection(std::shared_ptr<ArtifactRegistryStub> stub,
                               Options options) {
  options = ArtifactRegistryDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      artifactregistry_internal::ArtifactRegistryConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_internal
}  // namespace cloud
}  // namespace google
