// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_ARTIFACT_REGISTRY_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_ARTIFACT_REGISTRY_CLIENT_H

#include "google/cloud/artifactregistry/artifact_registry_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace artifactregistry {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Artifact Registry API service.
///
/// Artifact Registry is an artifact management system for storing artifacts
/// from different package management systems.
///
/// The resources managed by this API are:
///
/// * Repositories, which group packages and their data.
/// * Packages, which group versions and their tags.
/// * Versions, which are specific forms of a package.
/// * Tags, which represent alternative names for versions.
/// * Files, which contain content and are optionally associated with a Package
///   or Version.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ArtifactRegistryClient {
 public:
  explicit ArtifactRegistryClient(
      std::shared_ptr<ArtifactRegistryConnection> connection,
      Options options = {});
  ~ArtifactRegistryClient();

  //@{
  // @name Copy and move support
  ArtifactRegistryClient(ArtifactRegistryClient const&) = default;
  ArtifactRegistryClient& operator=(ArtifactRegistryClient const&) = default;
  ArtifactRegistryClient(ArtifactRegistryClient&&) = default;
  ArtifactRegistryClient& operator=(ArtifactRegistryClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ArtifactRegistryClient const& a,
                         ArtifactRegistryClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ArtifactRegistryClient const& a,
                         ArtifactRegistryClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists docker images.
  ///
  /// @param parent  Required. The name of the parent resource whose docker
  /// images will be listed.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::artifactregistry::v1::DockerImage,google/devtools/artifactregistry/v1/artifact.proto#L38}
  ///
  /// [google.devtools.artifactregistry.v1.ListDockerImagesRequest]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L87}
  /// [google.devtools.artifactregistry.v1.DockerImage]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L38}
  ///
  StreamRange<google::devtools::artifactregistry::v1::DockerImage>
  ListDockerImages(std::string const& parent, Options options = {});

  ///
  /// Lists docker images.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::artifactregistry::v1::ListDockerImagesRequest,google/devtools/artifactregistry/v1/artifact.proto#L87}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::artifactregistry::v1::DockerImage,google/devtools/artifactregistry/v1/artifact.proto#L38}
  ///
  /// [google.devtools.artifactregistry.v1.ListDockerImagesRequest]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L87}
  /// [google.devtools.artifactregistry.v1.DockerImage]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L38}
  ///
  StreamRange<google::devtools::artifactregistry::v1::DockerImage>
  ListDockerImages(
      google::devtools::artifactregistry::v1::ListDockerImagesRequest request,
      Options options = {});

  ///
  /// Lists repositories.
  ///
  /// @param parent  Required. The name of the parent resource whose
  /// repositories will be listed.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::artifactregistry::v1::Repository,google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  /// [google.devtools.artifactregistry.v1.ListRepositoriesRequest]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L94}
  /// [google.devtools.artifactregistry.v1.Repository]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  StreamRange<google::devtools::artifactregistry::v1::Repository>
  ListRepositories(std::string const& parent, Options options = {});

  ///
  /// Lists repositories.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::artifactregistry::v1::ListRepositoriesRequest,google/devtools/artifactregistry/v1/repository.proto#L94}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::artifactregistry::v1::Repository,google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  /// [google.devtools.artifactregistry.v1.ListRepositoriesRequest]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L94}
  /// [google.devtools.artifactregistry.v1.Repository]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  StreamRange<google::devtools::artifactregistry::v1::Repository>
  ListRepositories(
      google::devtools::artifactregistry::v1::ListRepositoriesRequest request,
      Options options = {});

  ///
  /// Gets a repository.
  ///
  /// @param name  Required. The name of the repository to retrieve.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::artifactregistry::v1::Repository,google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  /// [google.devtools.artifactregistry.v1.GetRepositoryRequest]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L121}
  /// [google.devtools.artifactregistry.v1.Repository]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  StatusOr<google::devtools::artifactregistry::v1::Repository> GetRepository(
      std::string const& name, Options options = {});

  ///
  /// Gets a repository.
  ///
  /// @param request
  /// @googleapis_link{google::devtools::artifactregistry::v1::GetRepositoryRequest,google/devtools/artifactregistry/v1/repository.proto#L121}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::devtools::artifactregistry::v1::Repository,google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  /// [google.devtools.artifactregistry.v1.GetRepositoryRequest]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L121}
  /// [google.devtools.artifactregistry.v1.Repository]:
  /// @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L33}
  ///
  StatusOr<google::devtools::artifactregistry::v1::Repository> GetRepository(
      google::devtools::artifactregistry::v1::GetRepositoryRequest const&
          request,
      Options options = {});

 private:
  std::shared_ptr<ArtifactRegistryConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_ARTIFACT_REGISTRY_CLIENT_H
