// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/services_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace appengine {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ServicesConnectionIdempotencyPolicy::~ServicesConnectionIdempotencyPolicy() =
    default;

namespace {
class DefaultServicesConnectionIdempotencyPolicy
    : public ServicesConnectionIdempotencyPolicy {
 public:
  ~DefaultServicesConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<ServicesConnectionIdempotencyPolicy> clone() const override {
    return absl::make_unique<DefaultServicesConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListServices(
      google::appengine::v1::ListServicesRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetService(
      google::appengine::v1::GetServiceRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateService(
      google::appengine::v1::UpdateServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteService(
      google::appengine::v1::DeleteServiceRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<ServicesConnectionIdempotencyPolicy>
MakeDefaultServicesConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultServicesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine
}  // namespace cloud
}  // namespace google
