// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_SERVICES_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_SERVICES_CLIENT_H

#include "google/cloud/appengine/services_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace appengine {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages services of an application.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ServicesClient {
 public:
  explicit ServicesClient(std::shared_ptr<ServicesConnection> connection,
                          Options options = {});
  ~ServicesClient();

  //@{
  // @name Copy and move support
  ServicesClient(ServicesClient const&) = default;
  ServicesClient& operator=(ServicesClient const&) = default;
  ServicesClient(ServicesClient&&) = default;
  ServicesClient& operator=(ServicesClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ServicesClient const& a, ServicesClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ServicesClient const& a, ServicesClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists all the services in the application.
  ///
  /// @param request
  /// @googleapis_link{google::appengine::v1::ListServicesRequest,google/appengine/v1/appengine.proto#L189}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::appengine::v1::Service,google/appengine/v1/service.proto#L37}
  ///
  /// [google.appengine.v1.ListServicesRequest]:
  /// @googleapis_reference_link{google/appengine/v1/appengine.proto#L189}
  /// [google.appengine.v1.Service]:
  /// @googleapis_reference_link{google/appengine/v1/service.proto#L37}
  ///
  StreamRange<google::appengine::v1::Service> ListServices(
      google::appengine::v1::ListServicesRequest request, Options options = {});

  ///
  /// Gets the current configuration of the specified service.
  ///
  /// @param request
  /// @googleapis_link{google::appengine::v1::GetServiceRequest,google/appengine/v1/appengine.proto#L210}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::appengine::v1::Service,google/appengine/v1/service.proto#L37}
  ///
  /// [google.appengine.v1.GetServiceRequest]:
  /// @googleapis_reference_link{google/appengine/v1/appengine.proto#L210}
  /// [google.appengine.v1.Service]:
  /// @googleapis_reference_link{google/appengine/v1/service.proto#L37}
  ///
  StatusOr<google::appengine::v1::Service> GetService(
      google::appengine::v1::GetServiceRequest const& request,
      Options options = {});

  ///
  /// Updates the configuration of the specified service.
  ///
  /// @param request
  /// @googleapis_link{google::appengine::v1::UpdateServiceRequest,google/appengine/v1/appengine.proto#L216}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::appengine::v1::Service,google/appengine/v1/service.proto#L37}
  ///
  /// [google.appengine.v1.UpdateServiceRequest]:
  /// @googleapis_reference_link{google/appengine/v1/appengine.proto#L216}
  /// [google.appengine.v1.Service]:
  /// @googleapis_reference_link{google/appengine/v1/service.proto#L37}
  ///
  future<StatusOr<google::appengine::v1::Service>> UpdateService(
      google::appengine::v1::UpdateServiceRequest const& request,
      Options options = {});

  ///
  /// Deletes the specified service and all enclosed versions.
  ///
  /// @param request
  /// @googleapis_link{google::appengine::v1::DeleteServiceRequest,google/appengine/v1/appengine.proto#L243}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::appengine::v1::OperationMetadataV1,google/appengine/v1/operation.proto#L32}
  ///
  /// [google.appengine.v1.DeleteServiceRequest]:
  /// @googleapis_reference_link{google/appengine/v1/appengine.proto#L243}
  /// [google.appengine.v1.OperationMetadataV1]:
  /// @googleapis_reference_link{google/appengine/v1/operation.proto#L32}
  ///
  future<StatusOr<google::appengine::v1::OperationMetadataV1>> DeleteService(
      google::appengine::v1::DeleteServiceRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<ServicesConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_SERVICES_CLIENT_H
