// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_INTERNAL_AUTHORIZED_DOMAINS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_INTERNAL_AUTHORIZED_DOMAINS_CONNECTION_IMPL_H

#include "google/cloud/appengine/authorized_domains_connection.h"
#include "google/cloud/appengine/authorized_domains_connection_idempotency_policy.h"
#include "google/cloud/appengine/authorized_domains_options.h"
#include "google/cloud/appengine/internal/authorized_domains_retry_traits.h"
#include "google/cloud/appengine/internal/authorized_domains_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace appengine_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AuthorizedDomainsConnectionImpl
    : public appengine::AuthorizedDomainsConnection {
 public:
  ~AuthorizedDomainsConnectionImpl() override = default;

  AuthorizedDomainsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<appengine_internal::AuthorizedDomainsStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::appengine::v1::AuthorizedDomain> ListAuthorizedDomains(
      google::appengine::v1::ListAuthorizedDomainsRequest request) override;

 private:
  std::unique_ptr<appengine::AuthorizedDomainsRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<appengine::AuthorizedDomainsRetryPolicyOption>()) {
      return options.get<appengine::AuthorizedDomainsRetryPolicyOption>()
          ->clone();
    }
    return options_.get<appengine::AuthorizedDomainsRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<appengine::AuthorizedDomainsBackoffPolicyOption>()) {
      return options.get<appengine::AuthorizedDomainsBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<appengine::AuthorizedDomainsBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<appengine::AuthorizedDomainsConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            appengine::AuthorizedDomainsConnectionIdempotencyPolicyOption>()) {
      return options
          .get<appengine::AuthorizedDomainsConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<appengine::AuthorizedDomainsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<appengine_internal::AuthorizedDomainsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_INTERNAL_AUTHORIZED_DOMAINS_CONNECTION_IMPL_H
