// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/internal/authorized_certificates_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/appengine/v1/appengine.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace appengine_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AuthorizedCertificatesMetadata::AuthorizedCertificatesMetadata(
    std::shared_ptr<AuthorizedCertificatesStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::appengine::v1::ListAuthorizedCertificatesResponse>
AuthorizedCertificatesMetadata::ListAuthorizedCertificates(
    grpc::ClientContext& context,
    google::appengine::v1::ListAuthorizedCertificatesRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListAuthorizedCertificates(context, request);
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesMetadata::GetAuthorizedCertificate(
    grpc::ClientContext& context,
    google::appengine::v1::GetAuthorizedCertificateRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetAuthorizedCertificate(context, request);
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesMetadata::CreateAuthorizedCertificate(
    grpc::ClientContext& context,
    google::appengine::v1::CreateAuthorizedCertificateRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->CreateAuthorizedCertificate(context, request);
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesMetadata::UpdateAuthorizedCertificate(
    grpc::ClientContext& context,
    google::appengine::v1::UpdateAuthorizedCertificateRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->UpdateAuthorizedCertificate(context, request);
}

Status AuthorizedCertificatesMetadata::DeleteAuthorizedCertificate(
    grpc::ClientContext& context,
    google::appengine::v1::DeleteAuthorizedCertificateRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteAuthorizedCertificate(context, request);
}

void AuthorizedCertificatesMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void AuthorizedCertificatesMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_internal
}  // namespace cloud
}  // namespace google
