// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/firewall_client.h"
#include "google/cloud/appengine/internal/firewall_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace appengine {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FirewallClient::FirewallClient(std::shared_ptr<FirewallConnection> connection,
                               Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          appengine_internal::FirewallDefaultOptions(connection_->options()))) {
}
FirewallClient::~FirewallClient() = default;

StreamRange<google::appengine::v1::FirewallRule>
FirewallClient::ListIngressRules(
    google::appengine::v1::ListIngressRulesRequest request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListIngressRules(std::move(request));
}

StatusOr<google::appengine::v1::BatchUpdateIngressRulesResponse>
FirewallClient::BatchUpdateIngressRules(
    google::appengine::v1::BatchUpdateIngressRulesRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->BatchUpdateIngressRules(request);
}

StatusOr<google::appengine::v1::FirewallRule> FirewallClient::CreateIngressRule(
    google::appengine::v1::CreateIngressRuleRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateIngressRule(request);
}

StatusOr<google::appengine::v1::FirewallRule> FirewallClient::GetIngressRule(
    google::appengine::v1::GetIngressRuleRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetIngressRule(request);
}

StatusOr<google::appengine::v1::FirewallRule> FirewallClient::UpdateIngressRule(
    google::appengine::v1::UpdateIngressRuleRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateIngressRule(request);
}

Status FirewallClient::DeleteIngressRule(
    google::appengine::v1::DeleteIngressRuleRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteIngressRule(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine
}  // namespace cloud
}  // namespace google
