// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/domain_mappings_client.h"
#include "google/cloud/appengine/internal/domain_mappings_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace appengine {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DomainMappingsClient::DomainMappingsClient(
    std::shared_ptr<DomainMappingsConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options), appengine_internal::DomainMappingsDefaultOptions(
                                  connection_->options()))) {}
DomainMappingsClient::~DomainMappingsClient() = default;

StreamRange<google::appengine::v1::DomainMapping>
DomainMappingsClient::ListDomainMappings(
    google::appengine::v1::ListDomainMappingsRequest request, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListDomainMappings(std::move(request));
}

StatusOr<google::appengine::v1::DomainMapping>
DomainMappingsClient::GetDomainMapping(
    google::appengine::v1::GetDomainMappingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetDomainMapping(request);
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsClient::CreateDomainMapping(
    google::appengine::v1::CreateDomainMappingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateDomainMapping(request);
}

future<StatusOr<google::appengine::v1::DomainMapping>>
DomainMappingsClient::UpdateDomainMapping(
    google::appengine::v1::UpdateDomainMappingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateDomainMapping(request);
}

future<StatusOr<google::appengine::v1::OperationMetadataV1>>
DomainMappingsClient::DeleteDomainMapping(
    google::appengine::v1::DeleteDomainMappingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteDomainMapping(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine
}  // namespace cloud
}  // namespace google
