// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#include "google/cloud/appengine/authorized_certificates_client.h"
#include "google/cloud/appengine/internal/authorized_certificates_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace appengine {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AuthorizedCertificatesClient::AuthorizedCertificatesClient(
    std::shared_ptr<AuthorizedCertificatesConnection> connection,
    Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          appengine_internal::AuthorizedCertificatesDefaultOptions(
              connection_->options()))) {}
AuthorizedCertificatesClient::~AuthorizedCertificatesClient() = default;

StreamRange<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesClient::ListAuthorizedCertificates(
    google::appengine::v1::ListAuthorizedCertificatesRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListAuthorizedCertificates(std::move(request));
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesClient::GetAuthorizedCertificate(
    google::appengine::v1::GetAuthorizedCertificateRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetAuthorizedCertificate(request);
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesClient::CreateAuthorizedCertificate(
    google::appengine::v1::CreateAuthorizedCertificateRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateAuthorizedCertificate(request);
}

StatusOr<google::appengine::v1::AuthorizedCertificate>
AuthorizedCertificatesClient::UpdateAuthorizedCertificate(
    google::appengine::v1::UpdateAuthorizedCertificateRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateAuthorizedCertificate(request);
}

Status AuthorizedCertificatesClient::DeleteAuthorizedCertificate(
    google::appengine::v1::DeleteAuthorizedCertificateRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteAuthorizedCertificate(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine
}  // namespace cloud
}  // namespace google
