// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apigateway/v1/apigateway_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_API_GATEWAY_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_API_GATEWAY_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/cloud/apigateway/v1/apigateway_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace apigateway {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ApiGatewayServiceConnectionIdempotencyPolicy {
 public:
  virtual ~ApiGatewayServiceConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<ApiGatewayServiceConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency ListGateways(
      google::cloud::apigateway::v1::ListGatewaysRequest request) = 0;

  virtual google::cloud::Idempotency GetGateway(
      google::cloud::apigateway::v1::GetGatewayRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateGateway(
      google::cloud::apigateway::v1::CreateGatewayRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateGateway(
      google::cloud::apigateway::v1::UpdateGatewayRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteGateway(
      google::cloud::apigateway::v1::DeleteGatewayRequest const& request) = 0;

  virtual google::cloud::Idempotency ListApis(
      google::cloud::apigateway::v1::ListApisRequest request) = 0;

  virtual google::cloud::Idempotency GetApi(
      google::cloud::apigateway::v1::GetApiRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateApi(
      google::cloud::apigateway::v1::CreateApiRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateApi(
      google::cloud::apigateway::v1::UpdateApiRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteApi(
      google::cloud::apigateway::v1::DeleteApiRequest const& request) = 0;

  virtual google::cloud::Idempotency ListApiConfigs(
      google::cloud::apigateway::v1::ListApiConfigsRequest request) = 0;

  virtual google::cloud::Idempotency GetApiConfig(
      google::cloud::apigateway::v1::GetApiConfigRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateApiConfig(
      google::cloud::apigateway::v1::CreateApiConfigRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateApiConfig(
      google::cloud::apigateway::v1::UpdateApiConfigRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteApiConfig(
      google::cloud::apigateway::v1::DeleteApiConfigRequest const& request) = 0;
};

std::unique_ptr<ApiGatewayServiceConnectionIdempotencyPolicy>
MakeDefaultApiGatewayServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apigateway
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_API_GATEWAY_CONNECTION_IDEMPOTENCY_POLICY_H
