// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apigateway/v1/apigateway_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_API_GATEWAY_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_API_GATEWAY_CLIENT_H

#include "google/cloud/apigateway/api_gateway_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace apigateway {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The API Gateway Service is the interface for managing API Gateways.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ApiGatewayServiceClient {
 public:
  explicit ApiGatewayServiceClient(
      std::shared_ptr<ApiGatewayServiceConnection> connection,
      Options options = {});
  ~ApiGatewayServiceClient();

  //@{
  // @name Copy and move support
  ApiGatewayServiceClient(ApiGatewayServiceClient const&) = default;
  ApiGatewayServiceClient& operator=(ApiGatewayServiceClient const&) = default;
  ApiGatewayServiceClient(ApiGatewayServiceClient&&) = default;
  ApiGatewayServiceClient& operator=(ApiGatewayServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ApiGatewayServiceClient const& a,
                         ApiGatewayServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ApiGatewayServiceClient const& a,
                         ApiGatewayServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Lists Gateways in a given project and location.
  ///
  /// @param parent  Required. Parent resource of the Gateway, of the form:
  ///  `projects/*/locations/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.ListGatewaysRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L306}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  StreamRange<google::cloud::apigateway::v1::Gateway> ListGateways(
      std::string const& parent, Options options = {});

  ///
  /// Lists Gateways in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::ListGatewaysRequest,google/cloud/apigateway/v1/apigateway.proto#L306}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.ListGatewaysRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L306}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  StreamRange<google::cloud::apigateway::v1::Gateway> ListGateways(
      google::cloud::apigateway::v1::ListGatewaysRequest request,
      Options options = {});

  ///
  /// Gets details of a single Gateway.
  ///
  /// @param name  Required. Resource name of the form:
  ///  `projects/*/locations/*/gateways/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.GetGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L342}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  StatusOr<google::cloud::apigateway::v1::Gateway> GetGateway(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single Gateway.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::GetGatewayRequest,google/cloud/apigateway/v1/apigateway.proto#L342}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.GetGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L342}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  StatusOr<google::cloud::apigateway::v1::Gateway> GetGateway(
      google::cloud::apigateway::v1::GetGatewayRequest const& request,
      Options options = {});

  ///
  /// Creates a new Gateway in a given project and location.
  ///
  /// @param parent  Required. Parent resource of the Gateway, of the form:
  ///  `projects/*/locations/*`
  /// @param gateway  Required. Gateway resource.
  /// @param gateway_id  Required. Identifier to assign to the Gateway. Must be
  /// unique within scope of
  ///  the parent resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.CreateGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L354}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Gateway>> CreateGateway(
      std::string const& parent,
      google::cloud::apigateway::v1::Gateway const& gateway,
      std::string const& gateway_id, Options options = {});

  ///
  /// Creates a new Gateway in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::CreateGatewayRequest,google/cloud/apigateway/v1/apigateway.proto#L354}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.CreateGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L354}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Gateway>> CreateGateway(
      google::cloud::apigateway::v1::CreateGatewayRequest const& request,
      Options options = {});

  ///
  /// Updates the parameters of a single Gateway.
  ///
  /// @param gateway  Required. Gateway resource.
  /// @param update_mask  Field mask is used to specify the fields to be
  /// overwritten in the
  ///  Gateway resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If
  ///  the user does not provide a mask then all fields will be overwritten.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.UpdateGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L373}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Gateway>> UpdateGateway(
      google::cloud::apigateway::v1::Gateway const& gateway,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the parameters of a single Gateway.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::UpdateGatewayRequest,google/cloud/apigateway/v1/apigateway.proto#L373}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Gateway,google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  /// [google.cloud.apigateway.v1.UpdateGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L373}
  /// [google.cloud.apigateway.v1.Gateway]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L243}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Gateway>> UpdateGateway(
      google::cloud::apigateway::v1::UpdateGatewayRequest const& request,
      Options options = {});

  ///
  /// Deletes a single Gateway.
  ///
  /// @param name  Required. Resource name of the form:
  ///  `projects/*/locations/*/gateways/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::OperationMetadata,google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  /// [google.cloud.apigateway.v1.DeleteGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L386}
  /// [google.cloud.apigateway.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>>
  DeleteGateway(std::string const& name, Options options = {});

  ///
  /// Deletes a single Gateway.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::DeleteGatewayRequest,google/cloud/apigateway/v1/apigateway.proto#L386}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::OperationMetadata,google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  /// [google.cloud.apigateway.v1.DeleteGatewayRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L386}
  /// [google.cloud.apigateway.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>>
  DeleteGateway(
      google::cloud::apigateway::v1::DeleteGatewayRequest const& request,
      Options options = {});

  ///
  /// Lists Apis in a given project and location.
  ///
  /// @param parent  Required. Parent resource of the API, of the form:
  ///  `projects/*/locations/global`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.ListApisRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L398}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  StreamRange<google::cloud::apigateway::v1::Api> ListApis(
      std::string const& parent, Options options = {});

  ///
  /// Lists Apis in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::ListApisRequest,google/cloud/apigateway/v1/apigateway.proto#L398}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.ListApisRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L398}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  StreamRange<google::cloud::apigateway::v1::Api> ListApis(
      google::cloud::apigateway::v1::ListApisRequest request,
      Options options = {});

  ///
  /// Gets details of a single Api.
  ///
  /// @param name  Required. Resource name of the form:
  ///  `projects/*/locations/global/apis/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.GetApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L434}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  StatusOr<google::cloud::apigateway::v1::Api> GetApi(std::string const& name,
                                                      Options options = {});

  ///
  /// Gets details of a single Api.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::GetApiRequest,google/cloud/apigateway/v1/apigateway.proto#L434}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.GetApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L434}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  StatusOr<google::cloud::apigateway::v1::Api> GetApi(
      google::cloud::apigateway::v1::GetApiRequest const& request,
      Options options = {});

  ///
  /// Creates a new Api in a given project and location.
  ///
  /// @param parent  Required. Parent resource of the API, of the form:
  ///  `projects/*/locations/global`
  /// @param api  Required. API resource.
  /// @param api_id  Required. Identifier to assign to the API. Must be unique
  /// within scope of
  ///  the parent resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.CreateApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L446}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Api>> CreateApi(
      std::string const& parent, google::cloud::apigateway::v1::Api const& api,
      std::string const& api_id, Options options = {});

  ///
  /// Creates a new Api in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::CreateApiRequest,google/cloud/apigateway/v1/apigateway.proto#L446}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.CreateApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L446}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Api>> CreateApi(
      google::cloud::apigateway::v1::CreateApiRequest const& request,
      Options options = {});

  ///
  /// Updates the parameters of a single Api.
  ///
  /// @param api  Required. API resource.
  /// @param update_mask  Field mask is used to specify the fields to be
  /// overwritten in the
  ///  Api resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If
  ///  the user does not provide a mask then all fields will be overwritten.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.UpdateApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L465}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Api>> UpdateApi(
      google::cloud::apigateway::v1::Api const& api,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the parameters of a single Api.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::UpdateApiRequest,google/cloud/apigateway/v1/apigateway.proto#L465}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::Api,google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  /// [google.cloud.apigateway.v1.UpdateApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L465}
  /// [google.cloud.apigateway.v1.Api]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L45}
  ///
  future<StatusOr<google::cloud::apigateway::v1::Api>> UpdateApi(
      google::cloud::apigateway::v1::UpdateApiRequest const& request,
      Options options = {});

  ///
  /// Deletes a single Api.
  ///
  /// @param name  Required. Resource name of the form:
  ///  `projects/*/locations/global/apis/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::OperationMetadata,google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  /// [google.cloud.apigateway.v1.DeleteApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L478}
  /// [google.cloud.apigateway.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>> DeleteApi(
      std::string const& name, Options options = {});

  ///
  /// Deletes a single Api.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::DeleteApiRequest,google/cloud/apigateway/v1/apigateway.proto#L478}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::OperationMetadata,google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  /// [google.cloud.apigateway.v1.DeleteApiRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L478}
  /// [google.cloud.apigateway.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>> DeleteApi(
      google::cloud::apigateway::v1::DeleteApiRequest const& request,
      Options options = {});

  ///
  /// Lists ApiConfigs in a given project and location.
  ///
  /// @param parent  Required. Parent resource of the API Config, of the form:
  ///  `projects/*/locations/global/apis/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.ListApiConfigsRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L490}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  StreamRange<google::cloud::apigateway::v1::ApiConfig> ListApiConfigs(
      std::string const& parent, Options options = {});

  ///
  /// Lists ApiConfigs in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::ListApiConfigsRequest,google/cloud/apigateway/v1/apigateway.proto#L490}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.ListApiConfigsRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L490}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  StreamRange<google::cloud::apigateway::v1::ApiConfig> ListApiConfigs(
      google::cloud::apigateway::v1::ListApiConfigsRequest request,
      Options options = {});

  ///
  /// Gets details of a single ApiConfig.
  ///
  /// @param name  Required. Resource name of the form:
  ///  `projects/*/locations/global/apis/*/configs/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.GetApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L526}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  StatusOr<google::cloud::apigateway::v1::ApiConfig> GetApiConfig(
      std::string const& name, Options options = {});

  ///
  /// Gets details of a single ApiConfig.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::GetApiConfigRequest,google/cloud/apigateway/v1/apigateway.proto#L526}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.GetApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L526}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  StatusOr<google::cloud::apigateway::v1::ApiConfig> GetApiConfig(
      google::cloud::apigateway::v1::GetApiConfigRequest const& request,
      Options options = {});

  ///
  /// Creates a new ApiConfig in a given project and location.
  ///
  /// @param parent  Required. Parent resource of the API Config, of the form:
  ///  `projects/*/locations/global/apis/*`
  /// @param api_config  Required. API resource.
  /// @param api_config_id  Required. Identifier to assign to the API Config.
  /// Must be unique within scope of
  ///  the parent resource.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.CreateApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L553}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  future<StatusOr<google::cloud::apigateway::v1::ApiConfig>> CreateApiConfig(
      std::string const& parent,
      google::cloud::apigateway::v1::ApiConfig const& api_config,
      std::string const& api_config_id, Options options = {});

  ///
  /// Creates a new ApiConfig in a given project and location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::CreateApiConfigRequest,google/cloud/apigateway/v1/apigateway.proto#L553}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.CreateApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L553}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  future<StatusOr<google::cloud::apigateway::v1::ApiConfig>> CreateApiConfig(
      google::cloud::apigateway::v1::CreateApiConfigRequest const& request,
      Options options = {});

  ///
  /// Updates the parameters of a single ApiConfig.
  ///
  /// @param api_config  Required. API Config resource.
  /// @param update_mask  Field mask is used to specify the fields to be
  /// overwritten in the
  ///  ApiConfig resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If
  ///  the user does not provide a mask then all fields will be overwritten.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.UpdateApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L572}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  future<StatusOr<google::cloud::apigateway::v1::ApiConfig>> UpdateApiConfig(
      google::cloud::apigateway::v1::ApiConfig const& api_config,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates the parameters of a single ApiConfig.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::UpdateApiConfigRequest,google/cloud/apigateway/v1/apigateway.proto#L572}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::ApiConfig,google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  /// [google.cloud.apigateway.v1.UpdateApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L572}
  /// [google.cloud.apigateway.v1.ApiConfig]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L108}
  ///
  future<StatusOr<google::cloud::apigateway::v1::ApiConfig>> UpdateApiConfig(
      google::cloud::apigateway::v1::UpdateApiConfigRequest const& request,
      Options options = {});

  ///
  /// Deletes a single ApiConfig.
  ///
  /// @param name  Required. Resource name of the form:
  ///  `projects/*/locations/global/apis/*/configs/*`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::OperationMetadata,google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  /// [google.cloud.apigateway.v1.DeleteApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L585}
  /// [google.cloud.apigateway.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>>
  DeleteApiConfig(std::string const& name, Options options = {});

  ///
  /// Deletes a single ApiConfig.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::apigateway::v1::DeleteApiConfigRequest,google/cloud/apigateway/v1/apigateway.proto#L585}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::cloud::apigateway::v1::OperationMetadata,google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  /// [google.cloud.apigateway.v1.DeleteApiConfigRequest]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L585}
  /// [google.cloud.apigateway.v1.OperationMetadata]:
  /// @googleapis_reference_link{google/cloud/apigateway/v1/apigateway.proto#L597}
  ///
  future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>>
  DeleteApiConfig(
      google::cloud::apigateway::v1::DeleteApiConfigRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<ApiGatewayServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apigateway
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIGATEWAY_API_GATEWAY_CLIENT_H
