// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

#include "google/cloud/accesscontextmanager/internal/access_context_manager_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/identity/accesscontextmanager/v1/access_context_manager.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace accesscontextmanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AccessContextManagerMetadata::AccessContextManagerMetadata(
    std::shared_ptr<AccessContextManagerStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::identity::accesscontextmanager::v1::ListAccessPoliciesResponse>
AccessContextManagerMetadata::ListAccessPolicies(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest const&
        request) {
  SetMetadata(context, {});
  return child_->ListAccessPolicies(context, request);
}

StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
AccessContextManagerMetadata::GetAccessPolicy(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::GetAccessPolicyRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetAccessPolicy(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncCreateAccessPolicy(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::AccessPolicy const& request) {
  SetMetadata(*context, {});
  return child_->AsyncCreateAccessPolicy(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncUpdateAccessPolicy(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::UpdateAccessPolicyRequest const&
        request) {
  SetMetadata(*context, "policy.name=" + request.policy().name());
  return child_->AsyncUpdateAccessPolicy(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncDeleteAccessPolicy(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::DeleteAccessPolicyRequest const&
        request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteAccessPolicy(cq, std::move(context), request);
}

StatusOr<google::identity::accesscontextmanager::v1::ListAccessLevelsResponse>
AccessContextManagerMetadata::ListAccessLevels(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::ListAccessLevelsRequest const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListAccessLevels(context, request);
}

StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
AccessContextManagerMetadata::GetAccessLevel(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::GetAccessLevelRequest const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetAccessLevel(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncCreateAccessLevel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::CreateAccessLevelRequest const&
        request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateAccessLevel(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncUpdateAccessLevel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::UpdateAccessLevelRequest const&
        request) {
  SetMetadata(*context, "access_level.name=" + request.access_level().name());
  return child_->AsyncUpdateAccessLevel(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncDeleteAccessLevel(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::DeleteAccessLevelRequest const&
        request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteAccessLevel(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncReplaceAccessLevels(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        ReplaceAccessLevelsRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncReplaceAccessLevels(cq, std::move(context), request);
}

StatusOr<
    google::identity::accesscontextmanager::v1::ListServicePerimetersResponse>
AccessContextManagerMetadata::ListServicePerimeters(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::
        ListServicePerimetersRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListServicePerimeters(context, request);
}

StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
AccessContextManagerMetadata::GetServicePerimeter(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::
        GetServicePerimeterRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetServicePerimeter(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncCreateServicePerimeter(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        CreateServicePerimeterRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateServicePerimeter(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncUpdateServicePerimeter(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        UpdateServicePerimeterRequest const& request) {
  SetMetadata(*context,
              "service_perimeter.name=" + request.service_perimeter().name());
  return child_->AsyncUpdateServicePerimeter(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncDeleteServicePerimeter(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        DeleteServicePerimeterRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteServicePerimeter(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncReplaceServicePerimeters(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        ReplaceServicePerimetersRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncReplaceServicePerimeters(cq, std::move(context), request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncCommitServicePerimeters(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        CommitServicePerimetersRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCommitServicePerimeters(cq, std::move(context), request);
}

StatusOr<google::identity::accesscontextmanager::v1::
             ListGcpUserAccessBindingsResponse>
AccessContextManagerMetadata::ListGcpUserAccessBindings(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::
        ListGcpUserAccessBindingsRequest const& request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListGcpUserAccessBindings(context, request);
}

StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
AccessContextManagerMetadata::GetGcpUserAccessBinding(
    grpc::ClientContext& context,
    google::identity::accesscontextmanager::v1::
        GetGcpUserAccessBindingRequest const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetGcpUserAccessBinding(context, request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncCreateGcpUserAccessBinding(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        CreateGcpUserAccessBindingRequest const& request) {
  SetMetadata(*context, "parent=" + request.parent());
  return child_->AsyncCreateGcpUserAccessBinding(cq, std::move(context),
                                                 request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncUpdateGcpUserAccessBinding(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        UpdateGcpUserAccessBindingRequest const& request) {
  SetMetadata(*context, "gcp_user_access_binding.name=" +
                            request.gcp_user_access_binding().name());
  return child_->AsyncUpdateGcpUserAccessBinding(cq, std::move(context),
                                                 request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncDeleteGcpUserAccessBinding(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::identity::accesscontextmanager::v1::
        DeleteGcpUserAccessBindingRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncDeleteGcpUserAccessBinding(cq, std::move(context),
                                                 request);
}

future<StatusOr<google::longrunning::Operation>>
AccessContextManagerMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncGetOperation(cq, std::move(context), request);
}

future<Status> AccessContextManagerMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<grpc::ClientContext> context,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, "name=" + request.name());
  return child_->AsyncCancelOperation(cq, std::move(context), request);
}

void AccessContextManagerMetadata::SetMetadata(
    grpc::ClientContext& context, std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void AccessContextManagerMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accesscontextmanager_internal
}  // namespace cloud
}  // namespace google
