// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

#include "google/cloud/accesscontextmanager/internal/access_context_manager_connection_impl.h"
#include "google/cloud/accesscontextmanager/internal/access_context_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace accesscontextmanager_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AccessContextManagerConnectionImpl::AccessContextManagerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<accesscontextmanager_internal::AccessContextManagerStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          accesscontextmanager_internal::AccessContextManagerDefaultOptions(
              AccessContextManagerConnection::options()))) {}

StreamRange<google::identity::accesscontextmanager::v1::AccessPolicy>
AccessContextManagerConnectionImpl::ListAccessPolicies(
    google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest
        request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<
      accesscontextmanager::AccessContextManagerRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListAccessPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::identity::accesscontextmanager::v1::AccessPolicy>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::identity::accesscontextmanager::v1::
                          ListAccessPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::identity::accesscontextmanager::v1::
                       ListAccessPoliciesRequest const& request) {
              return stub->ListAccessPolicies(context, request);
            },
            r, function_name);
      },
      [](google::identity::accesscontextmanager::v1::ListAccessPoliciesResponse
             r) {
        std::vector<google::identity::accesscontextmanager::v1::AccessPolicy>
            result(r.access_policies().size());
        auto& messages = *r.mutable_access_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
AccessContextManagerConnectionImpl::GetAccessPolicy(
    google::identity::accesscontextmanager::v1::GetAccessPolicyRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetAccessPolicy(request),
      [this](grpc::ClientContext& context,
             google::identity::accesscontextmanager::v1::
                 GetAccessPolicyRequest const& request) {
        return stub_->GetAccessPolicy(context, request);
      },
      request, __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
AccessContextManagerConnectionImpl::CreateAccessPolicy(
    google::identity::accesscontextmanager::v1::AccessPolicy const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::AccessPolicy>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::AccessPolicy const&
                 request) {
        return stub->AsyncCreateAccessPolicy(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::AccessPolicy>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateAccessPolicy(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
AccessContextManagerConnectionImpl::UpdateAccessPolicy(
    google::identity::accesscontextmanager::v1::UpdateAccessPolicyRequest const&
        request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::AccessPolicy>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 UpdateAccessPolicyRequest const& request) {
        return stub->AsyncUpdateAccessPolicy(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::AccessPolicy>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateAccessPolicy(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerConnectionImpl::DeleteAccessPolicy(
    google::identity::accesscontextmanager::v1::DeleteAccessPolicyRequest const&
        request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::
          AccessContextManagerOperationMetadata>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 DeleteAccessPolicyRequest const& request) {
        return stub->AsyncDeleteAccessPolicy(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::identity::accesscontextmanager::v1::
              AccessContextManagerOperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteAccessPolicy(request), polling_policy(),
      __func__);
}

StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
AccessContextManagerConnectionImpl::ListAccessLevels(
    google::identity::accesscontextmanager::v1::ListAccessLevelsRequest
        request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<
      accesscontextmanager::AccessContextManagerRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListAccessLevels(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::identity::accesscontextmanager::v1::
                          ListAccessLevelsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::identity::accesscontextmanager::v1::
                       ListAccessLevelsRequest const& request) {
              return stub->ListAccessLevels(context, request);
            },
            r, function_name);
      },
      [](google::identity::accesscontextmanager::v1::ListAccessLevelsResponse
             r) {
        std::vector<google::identity::accesscontextmanager::v1::AccessLevel>
            result(r.access_levels().size());
        auto& messages = *r.mutable_access_levels();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
AccessContextManagerConnectionImpl::GetAccessLevel(
    google::identity::accesscontextmanager::v1::GetAccessLevelRequest const&
        request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetAccessLevel(request),
      [this](grpc::ClientContext& context,
             google::identity::accesscontextmanager::v1::
                 GetAccessLevelRequest const& request) {
        return stub_->GetAccessLevel(context, request);
      },
      request, __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
AccessContextManagerConnectionImpl::CreateAccessLevel(
    google::identity::accesscontextmanager::v1::CreateAccessLevelRequest const&
        request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::AccessLevel>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 CreateAccessLevelRequest const& request) {
        return stub->AsyncCreateAccessLevel(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::AccessLevel>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateAccessLevel(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
AccessContextManagerConnectionImpl::UpdateAccessLevel(
    google::identity::accesscontextmanager::v1::UpdateAccessLevelRequest const&
        request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::AccessLevel>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 UpdateAccessLevelRequest const& request) {
        return stub->AsyncUpdateAccessLevel(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::AccessLevel>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateAccessLevel(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerConnectionImpl::DeleteAccessLevel(
    google::identity::accesscontextmanager::v1::DeleteAccessLevelRequest const&
        request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::
          AccessContextManagerOperationMetadata>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 DeleteAccessLevelRequest const& request) {
        return stub->AsyncDeleteAccessLevel(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::identity::accesscontextmanager::v1::
              AccessContextManagerOperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteAccessLevel(request), polling_policy(),
      __func__);
}

future<StatusOr<
    google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>>
AccessContextManagerConnectionImpl::ReplaceAccessLevels(
    google::identity::accesscontextmanager::v1::
        ReplaceAccessLevelsRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 ReplaceAccessLevelsRequest const& request) {
        return stub->AsyncReplaceAccessLevels(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::
              ReplaceAccessLevelsResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ReplaceAccessLevels(request), polling_policy(),
      __func__);
}

StreamRange<google::identity::accesscontextmanager::v1::ServicePerimeter>
AccessContextManagerConnectionImpl::ListServicePerimeters(
    google::identity::accesscontextmanager::v1::ListServicePerimetersRequest
        request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<
      accesscontextmanager::AccessContextManagerRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListServicePerimeters(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::identity::accesscontextmanager::v1::ServicePerimeter>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::identity::accesscontextmanager::v1::
                          ListServicePerimetersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::identity::accesscontextmanager::v1::
                       ListServicePerimetersRequest const& request) {
              return stub->ListServicePerimeters(context, request);
            },
            r, function_name);
      },
      [](google::identity::accesscontextmanager::v1::
             ListServicePerimetersResponse r) {
        std::vector<
            google::identity::accesscontextmanager::v1::ServicePerimeter>
            result(r.service_perimeters().size());
        auto& messages = *r.mutable_service_perimeters();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
AccessContextManagerConnectionImpl::GetServicePerimeter(
    google::identity::accesscontextmanager::v1::
        GetServicePerimeterRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetServicePerimeter(request),
      [this](grpc::ClientContext& context,
             google::identity::accesscontextmanager::v1::
                 GetServicePerimeterRequest const& request) {
        return stub_->GetServicePerimeter(context, request);
      },
      request, __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
AccessContextManagerConnectionImpl::CreateServicePerimeter(
    google::identity::accesscontextmanager::v1::
        CreateServicePerimeterRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::ServicePerimeter>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 CreateServicePerimeterRequest const& request) {
        return stub->AsyncCreateServicePerimeter(cq, std::move(context),
                                                 request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::ServicePerimeter>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateServicePerimeter(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
AccessContextManagerConnectionImpl::UpdateServicePerimeter(
    google::identity::accesscontextmanager::v1::
        UpdateServicePerimeterRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::ServicePerimeter>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 UpdateServicePerimeterRequest const& request) {
        return stub->AsyncUpdateServicePerimeter(cq, std::move(context),
                                                 request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::ServicePerimeter>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateServicePerimeter(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerConnectionImpl::DeleteServicePerimeter(
    google::identity::accesscontextmanager::v1::
        DeleteServicePerimeterRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::
          AccessContextManagerOperationMetadata>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 DeleteServicePerimeterRequest const& request) {
        return stub->AsyncDeleteServicePerimeter(cq, std::move(context),
                                                 request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::identity::accesscontextmanager::v1::
              AccessContextManagerOperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteServicePerimeter(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    ReplaceServicePerimetersResponse>>
AccessContextManagerConnectionImpl::ReplaceServicePerimeters(
    google::identity::accesscontextmanager::v1::
        ReplaceServicePerimetersRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::
          ReplaceServicePerimetersResponse>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 ReplaceServicePerimetersRequest const& request) {
        return stub->AsyncReplaceServicePerimeters(cq, std::move(context),
                                                   request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::
              ReplaceServicePerimetersResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->ReplaceServicePerimeters(request), polling_policy(),
      __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    CommitServicePerimetersResponse>>
AccessContextManagerConnectionImpl::CommitServicePerimeters(
    google::identity::accesscontextmanager::v1::
        CommitServicePerimetersRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::
          CommitServicePerimetersResponse>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 CommitServicePerimetersRequest const& request) {
        return stub->AsyncCommitServicePerimeters(cq, std::move(context),
                                                  request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::
              CommitServicePerimetersResponse>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CommitServicePerimeters(request), polling_policy(),
      __func__);
}

StreamRange<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
AccessContextManagerConnectionImpl::ListGcpUserAccessBindings(
    google::identity::accesscontextmanager::v1::ListGcpUserAccessBindingsRequest
        request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<
      accesscontextmanager::AccessContextManagerRetryPolicy const>(
      retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListGcpUserAccessBindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>(
      std::move(request),
      [stub, retry, backoff, idempotency,
       function_name](google::identity::accesscontextmanager::v1::
                          ListGcpUserAccessBindingsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::identity::accesscontextmanager::v1::
                       ListGcpUserAccessBindingsRequest const& request) {
              return stub->ListGcpUserAccessBindings(context, request);
            },
            r, function_name);
      },
      [](google::identity::accesscontextmanager::v1::
             ListGcpUserAccessBindingsResponse r) {
        std::vector<
            google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
            result(r.gcp_user_access_bindings().size());
        auto& messages = *r.mutable_gcp_user_access_bindings();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
AccessContextManagerConnectionImpl::GetGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        GetGcpUserAccessBindingRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GetGcpUserAccessBinding(request),
      [this](grpc::ClientContext& context,
             google::identity::accesscontextmanager::v1::
                 GetGcpUserAccessBindingRequest const& request) {
        return stub_->GetGcpUserAccessBinding(context, request);
      },
      request, __func__);
}

future<
    StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
AccessContextManagerConnectionImpl::CreateGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        CreateGcpUserAccessBindingRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 CreateGcpUserAccessBindingRequest const& request) {
        return stub->AsyncCreateGcpUserAccessBinding(cq, std::move(context),
                                                     request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::GcpUserAccessBinding>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->CreateGcpUserAccessBinding(request),
      polling_policy(), __func__);
}

future<
    StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
AccessContextManagerConnectionImpl::UpdateGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        UpdateGcpUserAccessBindingRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 UpdateGcpUserAccessBindingRequest const& request) {
        return stub->AsyncUpdateGcpUserAccessBinding(cq, std::move(context),
                                                     request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::identity::accesscontextmanager::v1::GcpUserAccessBinding>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->UpdateGcpUserAccessBinding(request),
      polling_policy(), __func__);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    GcpUserAccessBindingOperationMetadata>>
AccessContextManagerConnectionImpl::DeleteGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        DeleteGcpUserAccessBindingRequest const& request) {
  auto stub = stub_;
  return google::cloud::internal::AsyncLongRunningOperation<
      google::identity::accesscontextmanager::v1::
          GcpUserAccessBindingOperationMetadata>(
      background_->cq(), request,
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::identity::accesscontextmanager::v1::
                 DeleteGcpUserAccessBindingRequest const& request) {
        return stub->AsyncDeleteGcpUserAccessBinding(cq, std::move(context),
                                                     request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), request);
      },
      [stub](google::cloud::CompletionQueue& cq,
             std::unique_ptr<grpc::ClientContext> context,
             google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::identity::accesscontextmanager::v1::
              GcpUserAccessBindingOperationMetadata>,
      retry_policy(), backoff_policy(),
      idempotency_policy()->DeleteGcpUserAccessBinding(request),
      polling_policy(), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accesscontextmanager_internal
}  // namespace cloud
}  // namespace google
