// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

#include "google/cloud/accesscontextmanager/access_context_manager_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace accesscontextmanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AccessContextManagerConnectionIdempotencyPolicy::
    ~AccessContextManagerConnectionIdempotencyPolicy() = default;

namespace {
class DefaultAccessContextManagerConnectionIdempotencyPolicy
    : public AccessContextManagerConnectionIdempotencyPolicy {
 public:
  ~DefaultAccessContextManagerConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<AccessContextManagerConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<
        DefaultAccessContextManagerConnectionIdempotencyPolicy>(*this);
  }

  Idempotency ListAccessPolicies(
      google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetAccessPolicy(
      google::identity::accesscontextmanager::v1::GetAccessPolicyRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateAccessPolicy(
      google::identity::accesscontextmanager::v1::AccessPolicy const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateAccessPolicy(
      google::identity::accesscontextmanager::v1::
          UpdateAccessPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteAccessPolicy(
      google::identity::accesscontextmanager::v1::
          DeleteAccessPolicyRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListAccessLevels(
      google::identity::accesscontextmanager::v1::ListAccessLevelsRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetAccessLevel(
      google::identity::accesscontextmanager::v1::GetAccessLevelRequest const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateAccessLevel(google::identity::accesscontextmanager::v1::
                                    CreateAccessLevelRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateAccessLevel(google::identity::accesscontextmanager::v1::
                                    UpdateAccessLevelRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteAccessLevel(google::identity::accesscontextmanager::v1::
                                    DeleteAccessLevelRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ReplaceAccessLevels(
      google::identity::accesscontextmanager::v1::
          ReplaceAccessLevelsRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListServicePerimeters(
      google::identity::accesscontextmanager::v1::ListServicePerimetersRequest)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetServicePerimeter(
      google::identity::accesscontextmanager::v1::
          GetServicePerimeterRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateServicePerimeter(
      google::identity::accesscontextmanager::v1::
          CreateServicePerimeterRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateServicePerimeter(
      google::identity::accesscontextmanager::v1::
          UpdateServicePerimeterRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteServicePerimeter(
      google::identity::accesscontextmanager::v1::
          DeleteServicePerimeterRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ReplaceServicePerimeters(
      google::identity::accesscontextmanager::v1::
          ReplaceServicePerimetersRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency CommitServicePerimeters(
      google::identity::accesscontextmanager::v1::
          CommitServicePerimetersRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency ListGcpUserAccessBindings(
      google::identity::accesscontextmanager::v1::
          ListGcpUserAccessBindingsRequest) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          GetGcpUserAccessBindingRequest const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency CreateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          CreateGcpUserAccessBindingRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency UpdateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          UpdateGcpUserAccessBindingRequest const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          DeleteGcpUserAccessBindingRequest const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<AccessContextManagerConnectionIdempotencyPolicy>
MakeDefaultAccessContextManagerConnectionIdempotencyPolicy() {
  return absl::make_unique<
      DefaultAccessContextManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accesscontextmanager
}  // namespace cloud
}  // namespace google
