// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_ACCESS_CONTEXT_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_ACCESS_CONTEXT_MANAGER_CLIENT_H

#include "google/cloud/accesscontextmanager/access_context_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace accesscontextmanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// API for setting [Access Levels]
/// [google.identity.accesscontextmanager.v1.AccessLevel] and [Service
/// Perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
/// for Google Cloud Projects. Each organization has one [AccessPolicy]
/// [google.identity.accesscontextmanager.v1.AccessPolicy] containing the
/// [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
/// and [Service Perimeters]
/// [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
/// [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
/// applicable to all resources in the organization.
/// AccessPolicies
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AccessContextManagerClient {
 public:
  explicit AccessContextManagerClient(
      std::shared_ptr<AccessContextManagerConnection> connection,
      Options options = {});
  ~AccessContextManagerClient();

  //@{
  // @name Copy and move support
  AccessContextManagerClient(AccessContextManagerClient const&) = default;
  AccessContextManagerClient& operator=(AccessContextManagerClient const&) =
      default;
  AccessContextManagerClient(AccessContextManagerClient&&) = default;
  AccessContextManagerClient& operator=(AccessContextManagerClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(AccessContextManagerClient const& a,
                         AccessContextManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AccessContextManagerClient const& a,
                         AccessContextManagerClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// List all [AccessPolicies]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] under a
  /// container.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L431}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessPolicy,google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L431}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  StreamRange<google::identity::accesscontextmanager::v1::AccessPolicy>
  ListAccessPolicies(
      google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest
          request,
      Options options = {});

  ///
  /// Get an [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] by name.
  ///
  /// @param name  Required. Resource name for the access policy to get.
  ///  Format `accessPolicies/{policy_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessPolicy,google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.GetAccessPolicyRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L463}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
  GetAccessPolicy(std::string const& name, Options options = {});

  ///
  /// Get an [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] by name.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GetAccessPolicyRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L463}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessPolicy,google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.GetAccessPolicyRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L463}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
  GetAccessPolicy(
      google::identity::accesscontextmanager::v1::GetAccessPolicyRequest const&
          request,
      Options options = {});

  ///
  /// Create an `AccessPolicy`. Fails if this organization already has a
  /// `AccessPolicy`. The longrunning Operation will have a successful status
  /// once the `AccessPolicy` has propagated to long-lasting storage.
  /// Syntactic and basic semantic errors will be returned in `metadata` as a
  /// BadRequest proto.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessPolicy,google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessPolicy,google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  CreateAccessPolicy(
      google::identity::accesscontextmanager::v1::AccessPolicy const& request,
      Options options = {});

  ///
  /// Update an [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
  /// longrunning Operation from this RPC will have a successful status once the
  /// changes to the [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] have propagated
  /// to long-lasting storage. Syntactic and basic semantic errors will be
  /// returned in `metadata` as a BadRequest proto.
  ///
  /// @param policy  Required. The updated AccessPolicy.
  /// @param update_mask  Required. Mask to control which fields get updated.
  /// Must be non-empty.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessPolicy,google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L476}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  UpdateAccessPolicy(
      google::identity::accesscontextmanager::v1::AccessPolicy const& policy,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update an [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
  /// longrunning Operation from this RPC will have a successful status once the
  /// changes to the [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] have propagated
  /// to long-lasting storage. Syntactic and basic semantic errors will be
  /// returned in `metadata` as a BadRequest proto.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::UpdateAccessPolicyRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L476}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessPolicy,google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L476}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L37}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  UpdateAccessPolicy(google::identity::accesscontextmanager::v1::
                         UpdateAccessPolicyRequest const& request,
                     Options options = {});

  ///
  /// Delete an [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] by resource
  /// name. The longrunning Operation will have a successful status once the
  /// [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy]
  /// has been removed from long-lasting storage.
  ///
  /// @param name  Required. Resource name for the access policy to delete.
  ///  Format `accessPolicies/{policy_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessContextManagerOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L485}
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessPolicy(std::string const& name, Options options = {});

  ///
  /// Delete an [AccessPolicy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] by resource
  /// name. The longrunning Operation will have a successful status once the
  /// [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy]
  /// has been removed from long-lasting storage.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::DeleteAccessPolicyRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L485}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessContextManagerOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L485}
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessPolicy(google::identity::accesscontextmanager::v1::
                         DeleteAccessPolicyRequest const& request,
                     Options options = {});

  ///
  /// List all [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
  /// policy.
  ///
  /// @param parent  Required. Resource name for the access policy to list
  /// [Access Levels]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] from.
  ///  Format:
  ///  `accessPolicies/{policy_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.ListAccessLevelsRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L498}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
  ListAccessLevels(std::string const& parent, Options options = {});

  ///
  /// List all [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
  /// policy.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ListAccessLevelsRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L498}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.ListAccessLevelsRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L498}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
  ListAccessLevels(
      google::identity::accesscontextmanager::v1::ListAccessLevelsRequest
          request,
      Options options = {});

  ///
  /// Get an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] by resource
  /// name.
  ///
  /// @param name  Required. Resource name for the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel].
  ///  Format:
  ///  `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.GetAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L539}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
  GetAccessLevel(std::string const& name, Options options = {});

  ///
  /// Get an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] by resource
  /// name.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GetAccessLevelRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L539}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.GetAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L539}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
  GetAccessLevel(
      google::identity::accesscontextmanager::v1::GetAccessLevelRequest const&
          request,
      Options options = {});

  ///
  /// Create an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
  /// operation from this RPC will have a successful status once the [Access
  /// Level] [google.identity.accesscontextmanager.v1.AccessLevel] has
  /// propagated to long-lasting storage. [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param parent  Required. Resource name for the access policy which owns
  /// this [Access
  ///  Level] [google.identity.accesscontextmanager.v1.AccessLevel].
  ///  Format: `accessPolicies/{policy_id}`
  /// @param access_level  Required. The [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] to create.
  ///  Syntactic correctness of the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] is a
  ///  precondition for creation.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.CreateAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L564}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  CreateAccessLevel(
      std::string const& parent,
      google::identity::accesscontextmanager::v1::AccessLevel const&
          access_level,
      Options options = {});

  ///
  /// Create an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
  /// operation from this RPC will have a successful status once the [Access
  /// Level] [google.identity.accesscontextmanager.v1.AccessLevel] has
  /// propagated to long-lasting storage. [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::CreateAccessLevelRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L564}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.CreateAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L564}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  CreateAccessLevel(google::identity::accesscontextmanager::v1::
                        CreateAccessLevelRequest const& request,
                    Options options = {});

  ///
  /// Update an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
  /// operation from this RPC will have a successful status once the changes to
  /// the [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] have propagated
  /// to long-lasting storage. [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param access_level  Required. The updated [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel]. Syntactic
  ///  correctness of the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] is a
  ///  precondition for creation.
  /// @param update_mask  Required. Mask to control which fields get updated.
  /// Must be non-empty.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L585}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  UpdateAccessLevel(
      google::identity::accesscontextmanager::v1::AccessLevel const&
          access_level,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
  /// operation from this RPC will have a successful status once the changes to
  /// the [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] have propagated
  /// to long-lasting storage. [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::UpdateAccessLevelRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L585}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessLevel,google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L585}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L37}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  UpdateAccessLevel(google::identity::accesscontextmanager::v1::
                        UpdateAccessLevelRequest const& request,
                    Options options = {});

  ///
  /// Delete an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] by resource
  /// name. The longrunning operation from this RPC will have a successful
  /// status once the [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
  /// from long-lasting storage.
  ///
  /// @param name  Required. Resource name for the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel].
  ///  Format:
  ///  `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessContextManagerOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L598}
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessLevel(std::string const& name, Options options = {});

  ///
  /// Delete an [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] by resource
  /// name. The longrunning operation from this RPC will have a successful
  /// status once the [Access Level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
  /// from long-lasting storage.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::DeleteAccessLevelRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L598}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessContextManagerOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L598}
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessLevel(google::identity::accesscontextmanager::v1::
                        DeleteAccessLevelRequest const& request,
                    Options options = {});

  ///
  /// Replace all existing [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] in an [Access
  /// Policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
  /// the [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
  /// is done atomically. The longrunning operation from this RPC will have a
  /// successful status once all replacements have propagated to long-lasting
  /// storage. Replacements containing errors will result in an error response
  /// for the first error encountered.  Replacement will be cancelled on error,
  /// existing [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] will not be
  /// affected. Operation.response field will contain
  /// ReplaceAccessLevelsResponse. Removing [Access Levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] contained in
  /// existing [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] will result in
  /// error.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ReplaceAccessLevelsRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L614}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse,google/identity/accesscontextmanager/v1/access_context_manager.proto#L647}
  ///
  /// [google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L614}
  /// [google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L647}
  ///
  future<StatusOr<
      google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>>
  ReplaceAccessLevels(google::identity::accesscontextmanager::v1::
                          ReplaceAccessLevelsRequest const& request,
                      Options options = {});

  ///
  /// List all [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
  /// access policy.
  ///
  /// @param parent  Required. Resource name for the access policy to list
  /// [Service Perimeters]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
  ///  Format:
  ///  `accessPolicies/{policy_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.ListServicePerimetersRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L654}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  StreamRange<google::identity::accesscontextmanager::v1::ServicePerimeter>
  ListServicePerimeters(std::string const& parent, Options options = {});

  ///
  /// List all [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
  /// access policy.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ListServicePerimetersRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L654}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.ListServicePerimetersRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L654}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  StreamRange<google::identity::accesscontextmanager::v1::ServicePerimeter>
  ListServicePerimeters(
      google::identity::accesscontextmanager::v1::ListServicePerimetersRequest
          request,
      Options options = {});

  ///
  /// Get a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
  /// name.
  ///
  /// @param name  Required. Resource name for the [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter].
  ///  Format:
  ///  `accessPolicies/{policy_id}/servicePerimeters/{service_perimeters_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.GetServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L690}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
  GetServicePerimeter(std::string const& name, Options options = {});

  ///
  /// Get a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
  /// name.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GetServicePerimeterRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L690}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.GetServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L690}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
  GetServicePerimeter(google::identity::accesscontextmanager::v1::
                          GetServicePerimeterRequest const& request,
                      Options options = {});

  ///
  /// Create a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// longrunning operation from this RPC will have a successful status once the
  /// [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] has
  /// propagated to long-lasting storage. [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param parent  Required. Resource name for the access policy which owns
  /// this [Service
  ///  Perimeter] [google.identity.accesscontextmanager.v1.ServicePerimeter].
  ///  Format: `accessPolicies/{policy_id}`
  /// @param service_perimeter  Required. The [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter] to create.
  ///  Syntactic correctness of the [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter] is a
  ///  precondition for creation.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L705}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  CreateServicePerimeter(
      std::string const& parent,
      google::identity::accesscontextmanager::v1::ServicePerimeter const&
          service_perimeter,
      Options options = {});

  ///
  /// Create a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// longrunning operation from this RPC will have a successful status once the
  /// [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] has
  /// propagated to long-lasting storage. [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::CreateServicePerimeterRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L705}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L705}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  CreateServicePerimeter(google::identity::accesscontextmanager::v1::
                             CreateServicePerimeterRequest const& request,
                         Options options = {});

  ///
  /// Update a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// longrunning operation from this RPC will have a successful status once the
  /// changes to the [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] have
  /// propagated to long-lasting storage. [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param service_perimeter  Required. The updated `ServicePerimeter`.
  /// Syntactic correctness of the
  ///  `ServicePerimeter` is a precondition for creation.
  /// @param update_mask  Required. Mask to control which fields get updated.
  /// Must be non-empty.
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L726}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  UpdateServicePerimeter(
      google::identity::accesscontextmanager::v1::ServicePerimeter const&
          service_perimeter,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Update a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// longrunning operation from this RPC will have a successful status once the
  /// changes to the [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] have
  /// propagated to long-lasting storage. [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
  /// errors will result in an error response for the first error encountered.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::UpdateServicePerimeterRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L726}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ServicePerimeter,google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L726}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L42}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  UpdateServicePerimeter(google::identity::accesscontextmanager::v1::
                             UpdateServicePerimeterRequest const& request,
                         Options options = {});

  ///
  /// Delete a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
  /// name. The longrunning operation from this RPC will have a successful
  /// status once the [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] has been
  /// removed from long-lasting storage.
  ///
  /// @param name  Required. Resource name for the [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter].
  ///  Format:
  ///  `accessPolicies/{policy_id}/servicePerimeters/{service_perimeter_id}`
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessContextManagerOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L736}
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteServicePerimeter(std::string const& name, Options options = {});

  ///
  /// Delete a [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
  /// name. The longrunning operation from this RPC will have a successful
  /// status once the [Service Perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] has been
  /// removed from long-lasting storage.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::DeleteServicePerimeterRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L736}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::AccessContextManagerOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L736}
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L940}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteServicePerimeter(google::identity::accesscontextmanager::v1::
                             DeleteServicePerimeterRequest const& request,
                         Options options = {});

  ///
  /// Replace all existing [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
  /// [Access Policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
  /// with the [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] provided.
  /// This is done atomically. The longrunning operation from this
  /// RPC will have a successful status once all replacements have propagated to
  /// long-lasting storage. Replacements containing errors will result in an
  /// error response for the first error encountered. Replacement will be
  /// cancelled on error, existing [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] will not be
  /// affected. Operation.response field will contain
  /// ReplaceServicePerimetersResponse.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ReplaceServicePerimetersRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L752}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ReplaceServicePerimetersResponse,google/identity/accesscontextmanager/v1/access_context_manager.proto#L785}
  ///
  /// [google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L752}
  /// [google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L785}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      ReplaceServicePerimetersResponse>>
  ReplaceServicePerimeters(google::identity::accesscontextmanager::v1::
                               ReplaceServicePerimetersRequest const& request,
                           Options options = {});

  ///
  /// Commit the dry-run spec for all the [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
  /// [Access Policy][google.identity.accesscontextmanager.v1.AccessPolicy].
  /// A commit operation on a Service Perimeter involves copying its `spec`
  /// field to that Service Perimeter's `status` field. Only [Service
  /// Perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
  /// with `use_explicit_dry_run_spec` field set to true are affected by a
  /// commit operation. The longrunning operation from this RPC will have a
  /// successful status once the dry-run specs for all the [Service Perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
  /// committed. If a commit fails, it will cause the longrunning operation to
  /// return an error response and the entire commit operation will be
  /// cancelled. When successful, Operation.response field will contain
  /// CommitServicePerimetersResponse. The `dry_run` and the `spec` fields will
  /// be cleared after a successful commit operation.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::CommitServicePerimetersRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L794}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::CommitServicePerimetersResponse,google/identity/accesscontextmanager/v1/access_context_manager.proto#L821}
  ///
  /// [google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L794}
  /// [google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L821}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      CommitServicePerimetersResponse>>
  CommitServicePerimeters(google::identity::accesscontextmanager::v1::
                              CommitServicePerimetersRequest const& request,
                          Options options = {});

  ///
  /// Lists all [GcpUserAccessBindings]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
  /// Google Cloud organization.
  ///
  /// @param parent  Required. Example: "organizations/256"
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L831}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  StreamRange<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  ListGcpUserAccessBindings(std::string const& parent, Options options = {});

  ///
  /// Lists all [GcpUserAccessBindings]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
  /// Google Cloud organization.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::ListGcpUserAccessBindingsRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L831}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L831}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  StreamRange<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  ListGcpUserAccessBindings(google::identity::accesscontextmanager::v1::
                                ListGcpUserAccessBindingsRequest request,
                            Options options = {});

  ///
  /// Gets the [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
  /// the given name.
  ///
  /// @param name  Required. Example:
  /// "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L878}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  GetGcpUserAccessBinding(std::string const& name, Options options = {});

  ///
  /// Gets the [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
  /// the given name.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GetGcpUserAccessBindingRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L878}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L878}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  GetGcpUserAccessBinding(google::identity::accesscontextmanager::v1::
                              GetGcpUserAccessBindingRequest const& request,
                          Options options = {});

  ///
  /// Creates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
  /// client specifies a [name]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
  /// the server will ignore it. Fails if a resource already exists with the
  /// same [group_key]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
  /// Completion of this long-running operation does not necessarily signify
  /// that the new binding is deployed onto all affected users, which may take
  /// more time.
  ///
  /// @param parent  Required. Example: "organizations/256"
  /// @param gcp_user_access_binding  Required. [GcpUserAccessBinding]
  ///  [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L890}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  CreateGcpUserAccessBinding(
      std::string const& parent,
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
          gcp_user_access_binding,
      Options options = {});

  ///
  /// Creates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
  /// client specifies a [name]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
  /// the server will ignore it. Fails if a resource already exists with the
  /// same [group_key]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
  /// Completion of this long-running operation does not necessarily signify
  /// that the new binding is deployed onto all affected users, which may take
  /// more time.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::CreateGcpUserAccessBindingRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L890}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L890}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  CreateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          CreateGcpUserAccessBindingRequest const& request,
      Options options = {});

  ///
  /// Updates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify
  /// that the changed binding is deployed onto all affected users, which may
  /// take more time.
  ///
  /// @param gcp_user_access_binding  Required. [GcpUserAccessBinding]
  ///  [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
  /// @param update_mask  Required. Only the fields specified in this mask are
  /// updated. Because name and
  ///  group_key cannot be changed, update_mask is required and must always be:
  ///  update_mask {
  ///  paths: "access_levels"
  ///  }
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L906}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  UpdateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
          gcp_user_access_binding,
      google::protobuf::FieldMask const& update_mask, Options options = {});

  ///
  /// Updates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify
  /// that the changed binding is deployed onto all affected users, which may
  /// take more time.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::UpdateGcpUserAccessBindingRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L906}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBinding,google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  /// [google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L906}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L34}
  ///
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  UpdateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          UpdateGcpUserAccessBindingRequest const& request,
      Options options = {});

  ///
  /// Deletes a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify
  /// that the binding deletion is deployed onto all affected users, which may
  /// take more time.
  ///
  /// @param name  Required. Example:
  /// "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBindingOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L935}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L922}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L935}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      GcpUserAccessBindingOperationMetadata>>
  DeleteGcpUserAccessBinding(std::string const& name, Options options = {});

  ///
  /// Deletes a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify
  /// that the binding deletion is deployed onto all affected users, which may
  /// take more time.
  ///
  /// @param request
  /// @googleapis_link{google::identity::accesscontextmanager::v1::DeleteGcpUserAccessBindingRequest,google/identity/accesscontextmanager/v1/access_context_manager.proto#L922}
  /// @param options  Optional. Operation options.
  /// @return
  /// @googleapis_link{google::identity::accesscontextmanager::v1::GcpUserAccessBindingOperationMetadata,google/identity/accesscontextmanager/v1/access_context_manager.proto#L935}
  ///
  /// [google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L922}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata]:
  /// @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L935}
  ///
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      GcpUserAccessBindingOperationMetadata>>
  DeleteGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          DeleteGcpUserAccessBindingRequest const& request,
      Options options = {});

 private:
  std::shared_ptr<AccessContextManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accesscontextmanager
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_ACCESS_CONTEXT_MANAGER_CLIENT_H
