// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

#include "google/cloud/accesscontextmanager/access_context_manager_client.h"
#include "google/cloud/accesscontextmanager/internal/access_context_manager_option_defaults.h"
#include <memory>

namespace google {
namespace cloud {
namespace accesscontextmanager {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AccessContextManagerClient::AccessContextManagerClient(
    std::shared_ptr<AccessContextManagerConnection> connection, Options options)
    : connection_(std::move(connection)),
      options_(internal::MergeOptions(
          std::move(options),
          accesscontextmanager_internal::AccessContextManagerDefaultOptions(
              connection_->options()))) {}
AccessContextManagerClient::~AccessContextManagerClient() = default;

StreamRange<google::identity::accesscontextmanager::v1::AccessPolicy>
AccessContextManagerClient::ListAccessPolicies(
    google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListAccessPolicies(std::move(request));
}

StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
AccessContextManagerClient::GetAccessPolicy(std::string const& name,
                                            Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::GetAccessPolicyRequest request;
  request.set_name(name);
  return connection_->GetAccessPolicy(request);
}

StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
AccessContextManagerClient::GetAccessPolicy(
    google::identity::accesscontextmanager::v1::GetAccessPolicyRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetAccessPolicy(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
AccessContextManagerClient::CreateAccessPolicy(
    google::identity::accesscontextmanager::v1::AccessPolicy const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateAccessPolicy(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
AccessContextManagerClient::UpdateAccessPolicy(
    google::identity::accesscontextmanager::v1::AccessPolicy const& policy,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::UpdateAccessPolicyRequest request;
  *request.mutable_policy() = policy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAccessPolicy(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
AccessContextManagerClient::UpdateAccessPolicy(
    google::identity::accesscontextmanager::v1::UpdateAccessPolicyRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateAccessPolicy(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerClient::DeleteAccessPolicy(std::string const& name,
                                               Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::DeleteAccessPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteAccessPolicy(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerClient::DeleteAccessPolicy(
    google::identity::accesscontextmanager::v1::DeleteAccessPolicyRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteAccessPolicy(request);
}

StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
AccessContextManagerClient::ListAccessLevels(std::string const& parent,
                                             Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::ListAccessLevelsRequest request;
  request.set_parent(parent);
  return connection_->ListAccessLevels(request);
}

StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
AccessContextManagerClient::ListAccessLevels(
    google::identity::accesscontextmanager::v1::ListAccessLevelsRequest request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListAccessLevels(std::move(request));
}

StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
AccessContextManagerClient::GetAccessLevel(std::string const& name,
                                           Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::GetAccessLevelRequest request;
  request.set_name(name);
  return connection_->GetAccessLevel(request);
}

StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
AccessContextManagerClient::GetAccessLevel(
    google::identity::accesscontextmanager::v1::GetAccessLevelRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetAccessLevel(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
AccessContextManagerClient::CreateAccessLevel(
    std::string const& parent,
    google::identity::accesscontextmanager::v1::AccessLevel const& access_level,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::CreateAccessLevelRequest request;
  request.set_parent(parent);
  *request.mutable_access_level() = access_level;
  return connection_->CreateAccessLevel(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
AccessContextManagerClient::CreateAccessLevel(
    google::identity::accesscontextmanager::v1::CreateAccessLevelRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateAccessLevel(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
AccessContextManagerClient::UpdateAccessLevel(
    google::identity::accesscontextmanager::v1::AccessLevel const& access_level,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::UpdateAccessLevelRequest request;
  *request.mutable_access_level() = access_level;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAccessLevel(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
AccessContextManagerClient::UpdateAccessLevel(
    google::identity::accesscontextmanager::v1::UpdateAccessLevelRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateAccessLevel(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerClient::DeleteAccessLevel(std::string const& name,
                                              Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::DeleteAccessLevelRequest request;
  request.set_name(name);
  return connection_->DeleteAccessLevel(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerClient::DeleteAccessLevel(
    google::identity::accesscontextmanager::v1::DeleteAccessLevelRequest const&
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteAccessLevel(request);
}

future<StatusOr<
    google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>>
AccessContextManagerClient::ReplaceAccessLevels(
    google::identity::accesscontextmanager::v1::
        ReplaceAccessLevelsRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ReplaceAccessLevels(request);
}

StreamRange<google::identity::accesscontextmanager::v1::ServicePerimeter>
AccessContextManagerClient::ListServicePerimeters(std::string const& parent,
                                                  Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::ListServicePerimetersRequest
      request;
  request.set_parent(parent);
  return connection_->ListServicePerimeters(request);
}

StreamRange<google::identity::accesscontextmanager::v1::ServicePerimeter>
AccessContextManagerClient::ListServicePerimeters(
    google::identity::accesscontextmanager::v1::ListServicePerimetersRequest
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListServicePerimeters(std::move(request));
}

StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
AccessContextManagerClient::GetServicePerimeter(std::string const& name,
                                                Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::GetServicePerimeterRequest
      request;
  request.set_name(name);
  return connection_->GetServicePerimeter(request);
}

StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
AccessContextManagerClient::GetServicePerimeter(
    google::identity::accesscontextmanager::v1::
        GetServicePerimeterRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetServicePerimeter(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
AccessContextManagerClient::CreateServicePerimeter(
    std::string const& parent,
    google::identity::accesscontextmanager::v1::ServicePerimeter const&
        service_perimeter,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::CreateServicePerimeterRequest
      request;
  request.set_parent(parent);
  *request.mutable_service_perimeter() = service_perimeter;
  return connection_->CreateServicePerimeter(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
AccessContextManagerClient::CreateServicePerimeter(
    google::identity::accesscontextmanager::v1::
        CreateServicePerimeterRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateServicePerimeter(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
AccessContextManagerClient::UpdateServicePerimeter(
    google::identity::accesscontextmanager::v1::ServicePerimeter const&
        service_perimeter,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::UpdateServicePerimeterRequest
      request;
  *request.mutable_service_perimeter() = service_perimeter;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateServicePerimeter(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
AccessContextManagerClient::UpdateServicePerimeter(
    google::identity::accesscontextmanager::v1::
        UpdateServicePerimeterRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateServicePerimeter(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerClient::DeleteServicePerimeter(std::string const& name,
                                                   Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::DeleteServicePerimeterRequest
      request;
  request.set_name(name);
  return connection_->DeleteServicePerimeter(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    AccessContextManagerOperationMetadata>>
AccessContextManagerClient::DeleteServicePerimeter(
    google::identity::accesscontextmanager::v1::
        DeleteServicePerimeterRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteServicePerimeter(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    ReplaceServicePerimetersResponse>>
AccessContextManagerClient::ReplaceServicePerimeters(
    google::identity::accesscontextmanager::v1::
        ReplaceServicePerimetersRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ReplaceServicePerimeters(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    CommitServicePerimetersResponse>>
AccessContextManagerClient::CommitServicePerimeters(
    google::identity::accesscontextmanager::v1::
        CommitServicePerimetersRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CommitServicePerimeters(request);
}

StreamRange<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
AccessContextManagerClient::ListGcpUserAccessBindings(std::string const& parent,
                                                      Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::ListGcpUserAccessBindingsRequest
      request;
  request.set_parent(parent);
  return connection_->ListGcpUserAccessBindings(request);
}

StreamRange<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
AccessContextManagerClient::ListGcpUserAccessBindings(
    google::identity::accesscontextmanager::v1::ListGcpUserAccessBindingsRequest
        request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->ListGcpUserAccessBindings(std::move(request));
}

StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
AccessContextManagerClient::GetGcpUserAccessBinding(std::string const& name,
                                                    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::GetGcpUserAccessBindingRequest
      request;
  request.set_name(name);
  return connection_->GetGcpUserAccessBinding(request);
}

StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
AccessContextManagerClient::GetGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        GetGcpUserAccessBindingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->GetGcpUserAccessBinding(request);
}

future<
    StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
AccessContextManagerClient::CreateGcpUserAccessBinding(
    std::string const& parent,
    google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
        gcp_user_access_binding,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::CreateGcpUserAccessBindingRequest
      request;
  request.set_parent(parent);
  *request.mutable_gcp_user_access_binding() = gcp_user_access_binding;
  return connection_->CreateGcpUserAccessBinding(request);
}

future<
    StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
AccessContextManagerClient::CreateGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        CreateGcpUserAccessBindingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->CreateGcpUserAccessBinding(request);
}

future<
    StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
AccessContextManagerClient::UpdateGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
        gcp_user_access_binding,
    google::protobuf::FieldMask const& update_mask, Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::UpdateGcpUserAccessBindingRequest
      request;
  *request.mutable_gcp_user_access_binding() = gcp_user_access_binding;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGcpUserAccessBinding(request);
}

future<
    StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
AccessContextManagerClient::UpdateGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        UpdateGcpUserAccessBindingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->UpdateGcpUserAccessBinding(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    GcpUserAccessBindingOperationMetadata>>
AccessContextManagerClient::DeleteGcpUserAccessBinding(std::string const& name,
                                                       Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  google::identity::accesscontextmanager::v1::DeleteGcpUserAccessBindingRequest
      request;
  request.set_name(name);
  return connection_->DeleteGcpUserAccessBinding(request);
}

future<StatusOr<google::identity::accesscontextmanager::v1::
                    GcpUserAccessBindingOperationMetadata>>
AccessContextManagerClient::DeleteGcpUserAccessBinding(
    google::identity::accesscontextmanager::v1::
        DeleteGcpUserAccessBindingRequest const& request,
    Options options) {
  internal::OptionsSpan span(
      internal::MergeOptions(std::move(options), options_));
  return connection_->DeleteGcpUserAccessBinding(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accesscontextmanager
}  // namespace cloud
}  // namespace google
