// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/accessapproval/v1/accessapproval.proto

#include "google/cloud/accessapproval/internal/access_approval_metadata_decorator.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/status_or.h"
#include <google/cloud/accessapproval/v1/accessapproval.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace accessapproval_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AccessApprovalMetadata::AccessApprovalMetadata(
    std::shared_ptr<AccessApprovalStub> child)
    : child_(std::move(child)),
      api_client_header_(
          google::cloud::internal::ApiClientHeader("generator")) {}

StatusOr<google::cloud::accessapproval::v1::ListApprovalRequestsResponse>
AccessApprovalMetadata::ListApprovalRequests(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::ListApprovalRequestsMessage const&
        request) {
  SetMetadata(context, "parent=" + request.parent());
  return child_->ListApprovalRequests(context, request);
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalMetadata::GetApprovalRequest(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::GetApprovalRequestMessage const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetApprovalRequest(context, request);
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalMetadata::ApproveApprovalRequest(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->ApproveApprovalRequest(context, request);
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalMetadata::DismissApprovalRequest(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DismissApprovalRequest(context, request);
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
AccessApprovalMetadata::GetAccessApprovalSettings(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::GetAccessApprovalSettingsMessage const&
        request) {
  SetMetadata(context, "name=" + request.name());
  return child_->GetAccessApprovalSettings(context, request);
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
AccessApprovalMetadata::UpdateAccessApprovalSettings(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::
        UpdateAccessApprovalSettingsMessage const& request) {
  SetMetadata(context, "settings.name=" + request.settings().name());
  return child_->UpdateAccessApprovalSettings(context, request);
}

Status AccessApprovalMetadata::DeleteAccessApprovalSettings(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::
        DeleteAccessApprovalSettingsMessage const& request) {
  SetMetadata(context, "name=" + request.name());
  return child_->DeleteAccessApprovalSettings(context, request);
}

void AccessApprovalMetadata::SetMetadata(grpc::ClientContext& context,
                                         std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context);
}

void AccessApprovalMetadata::SetMetadata(grpc::ClientContext& context) {
  context.AddMetadata("x-goog-api-client", api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval_internal
}  // namespace cloud
}  // namespace google
