// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/accessapproval/v1/accessapproval.proto

#include "google/cloud/accessapproval/internal/access_approval_auth_decorator.h"
#include <google/cloud/accessapproval/v1/accessapproval.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace accessapproval_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AccessApprovalAuth::AccessApprovalAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<AccessApprovalStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::accessapproval::v1::ListApprovalRequestsResponse>
AccessApprovalAuth::ListApprovalRequests(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::ListApprovalRequestsMessage const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListApprovalRequests(context, request);
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalAuth::GetApprovalRequest(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::GetApprovalRequestMessage const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetApprovalRequest(context, request);
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalAuth::ApproveApprovalRequest(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ApproveApprovalRequest(context, request);
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalAuth::DismissApprovalRequest(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DismissApprovalRequest(context, request);
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
AccessApprovalAuth::GetAccessApprovalSettings(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::GetAccessApprovalSettingsMessage const&
        request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetAccessApprovalSettings(context, request);
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
AccessApprovalAuth::UpdateAccessApprovalSettings(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::
        UpdateAccessApprovalSettingsMessage const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateAccessApprovalSettings(context, request);
}

Status AccessApprovalAuth::DeleteAccessApprovalSettings(
    grpc::ClientContext& context,
    google::cloud::accessapproval::v1::
        DeleteAccessApprovalSettingsMessage const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteAccessApprovalSettings(context, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval_internal
}  // namespace cloud
}  // namespace google
