// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/accessapproval/v1/accessapproval.proto

#include "google/cloud/accessapproval/access_approval_connection_idempotency_policy.h"
#include "absl/memory/memory.h"
#include <memory>

namespace google {
namespace cloud {
namespace accessapproval {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AccessApprovalConnectionIdempotencyPolicy::
    ~AccessApprovalConnectionIdempotencyPolicy() = default;

namespace {
class DefaultAccessApprovalConnectionIdempotencyPolicy
    : public AccessApprovalConnectionIdempotencyPolicy {
 public:
  ~DefaultAccessApprovalConnectionIdempotencyPolicy() override = default;

  /// Create a new copy of this object.
  std::unique_ptr<AccessApprovalConnectionIdempotencyPolicy> clone()
      const override {
    return absl::make_unique<DefaultAccessApprovalConnectionIdempotencyPolicy>(
        *this);
  }

  Idempotency ListApprovalRequests(
      google::cloud::accessapproval::v1::ListApprovalRequestsMessage) override {
    return Idempotency::kIdempotent;
  }

  Idempotency GetApprovalRequest(
      google::cloud::accessapproval::v1::GetApprovalRequestMessage const&)
      override {
    return Idempotency::kIdempotent;
  }

  Idempotency ApproveApprovalRequest(
      google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DismissApprovalRequest(
      google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&)
      override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency GetAccessApprovalSettings(
      google::cloud::accessapproval::v1::
          GetAccessApprovalSettingsMessage const&) override {
    return Idempotency::kIdempotent;
  }

  Idempotency UpdateAccessApprovalSettings(
      google::cloud::accessapproval::v1::
          UpdateAccessApprovalSettingsMessage const&) override {
    return Idempotency::kNonIdempotent;
  }

  Idempotency DeleteAccessApprovalSettings(
      google::cloud::accessapproval::v1::
          DeleteAccessApprovalSettingsMessage const&) override {
    return Idempotency::kNonIdempotent;
  }
};
}  // namespace

std::unique_ptr<AccessApprovalConnectionIdempotencyPolicy>
MakeDefaultAccessApprovalConnectionIdempotencyPolicy() {
  return absl::make_unique<DefaultAccessApprovalConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval
}  // namespace cloud
}  // namespace google
