// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/accessapproval/v1/accessapproval.proto

#include "google/cloud/accessapproval/access_approval_connection.h"
#include "google/cloud/accessapproval/access_approval_options.h"
#include "google/cloud/accessapproval/internal/access_approval_connection_impl.h"
#include "google/cloud/accessapproval/internal/access_approval_option_defaults.h"
#include "google/cloud/accessapproval/internal/access_approval_stub_factory.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace accessapproval {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AccessApprovalConnection::~AccessApprovalConnection() = default;

StreamRange<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalConnection::ListApprovalRequests(
    google::cloud::accessapproval::v1::ListApprovalRequestsMessage request) {
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::accessapproval::v1::ApprovalRequest>>(
      std::move(request),
      [](google::cloud::accessapproval::v1::
             ListApprovalRequestsMessage const&) {
        return StatusOr<
            google::cloud::accessapproval::v1::ListApprovalRequestsResponse>{};
      },
      [](google::cloud::accessapproval::v1::
             ListApprovalRequestsResponse const&) {
        return std::vector<
            google::cloud::accessapproval::v1::ApprovalRequest>();
      });
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalConnection::GetApprovalRequest(
    google::cloud::accessapproval::v1::GetApprovalRequestMessage const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalConnection::ApproveApprovalRequest(
    google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
AccessApprovalConnection::DismissApprovalRequest(
    google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
AccessApprovalConnection::GetAccessApprovalSettings(
    google::cloud::accessapproval::v1::
        GetAccessApprovalSettingsMessage const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
AccessApprovalConnection::UpdateAccessApprovalSettings(
    google::cloud::accessapproval::v1::
        UpdateAccessApprovalSettingsMessage const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AccessApprovalConnection::DeleteAccessApprovalSettings(
    google::cloud::accessapproval::v1::
        DeleteAccessApprovalSettingsMessage const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<AccessApprovalConnection> MakeAccessApprovalConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 AccessApprovalPolicyOptionList>(options,
                                                                 __func__);
  options =
      accessapproval_internal::AccessApprovalDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = accessapproval_internal::CreateDefaultAccessApprovalStub(
      background->cq(), options);
  return std::make_shared<
      accessapproval_internal::AccessApprovalConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace accessapproval_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<accessapproval::AccessApprovalConnection>
MakeAccessApprovalConnection(std::shared_ptr<AccessApprovalStub> stub,
                             Options options) {
  options = AccessApprovalDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  return std::make_shared<
      accessapproval_internal::AccessApprovalConnectionImpl>(
      std::move(background), std::move(stub), std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval_internal
}  // namespace cloud
}  // namespace google
