// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/internal/golden_kitchen_sink_connection_impl.h"
#include "generator/integration_tests/golden/internal/golden_kitchen_sink_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/resumable_streaming_read_rpc.h"
#include "google/cloud/internal/retry_loop.h"
#include "google/cloud/internal/streaming_read_rpc_logging.h"
#include <memory>

namespace google {
namespace cloud {
namespace golden_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GoldenKitchenSinkConnectionImpl::GoldenKitchenSinkConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<golden_internal::GoldenKitchenSinkStub> stub,
    Options options)
  : background_(std::move(background)), stub_(std::move(stub)),
    options_(internal::MergeOptions(std::move(options),
      golden_internal::GoldenKitchenSinkDefaultOptions(
        GoldenKitchenSinkConnection::options()))) {}

StatusOr<google::test::admin::database::v1::GenerateAccessTokenResponse>
GoldenKitchenSinkConnectionImpl::GenerateAccessToken(google::test::admin::database::v1::GenerateAccessTokenRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GenerateAccessToken(request),
      [this](grpc::ClientContext& context,
          google::test::admin::database::v1::GenerateAccessTokenRequest const& request) {
        return stub_->GenerateAccessToken(context, request);
      },
      request, __func__);
}

StatusOr<google::test::admin::database::v1::GenerateIdTokenResponse>
GoldenKitchenSinkConnectionImpl::GenerateIdToken(google::test::admin::database::v1::GenerateIdTokenRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->GenerateIdToken(request),
      [this](grpc::ClientContext& context,
          google::test::admin::database::v1::GenerateIdTokenRequest const& request) {
        return stub_->GenerateIdToken(context, request);
      },
      request, __func__);
}

StatusOr<google::test::admin::database::v1::WriteLogEntriesResponse>
GoldenKitchenSinkConnectionImpl::WriteLogEntries(google::test::admin::database::v1::WriteLogEntriesRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->WriteLogEntries(request),
      [this](grpc::ClientContext& context,
          google::test::admin::database::v1::WriteLogEntriesRequest const& request) {
        return stub_->WriteLogEntries(context, request);
      },
      request, __func__);
}

StreamRange<std::string>
GoldenKitchenSinkConnectionImpl::ListLogs(google::test::admin::database::v1::ListLogsRequest request) {
  request.clear_page_token();
  auto stub = stub_;
  auto retry = std::shared_ptr<golden::GoldenKitchenSinkRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());
  auto idempotency = idempotency_policy()->ListLogs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<std::string>>(
      std::move(request),
      [stub, retry, backoff, idempotency, function_name]
        (google::test::admin::database::v1::ListLogsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, google::test::admin::database::v1::ListLogsRequest const& request) {
              return stub->ListLogs(context, request);
            },
            r, function_name);
      },
      [](google::test::admin::database::v1::ListLogsResponse r) {
        std::vector<std::string> result(r.log_names().size());
        auto& messages = *r.mutable_log_names();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::test::admin::database::v1::TailLogEntriesResponse>
GoldenKitchenSinkConnectionImpl::TailLogEntries(google::test::admin::database::v1::TailLogEntriesRequest const& request) {
  auto stub = stub_;
  auto retry = std::shared_ptr<golden::GoldenKitchenSinkRetryPolicy const>(retry_policy());
  auto backoff = std::shared_ptr<BackoffPolicy const>(backoff_policy());

  auto factory = [stub](google::test::admin::database::v1::TailLogEntriesRequest const& request) {
    return stub->TailLogEntries(absl::make_unique<grpc::ClientContext>(), request);
  };
  auto resumable =
      internal::MakeResumableStreamingReadRpc<google::test::admin::database::v1::TailLogEntriesResponse, google::test::admin::database::v1::TailLogEntriesRequest>(
          retry->clone(), backoff->clone(), [](std::chrono::milliseconds) {},
          factory,
          golden::GoldenKitchenSinkTailLogEntriesStreamingUpdater,
          request);
  return internal::MakeStreamRange(internal::StreamReader<google::test::admin::database::v1::TailLogEntriesResponse>(
      [resumable]{return resumable->Read();}));
}
StatusOr<google::test::admin::database::v1::ListServiceAccountKeysResponse>
GoldenKitchenSinkConnectionImpl::ListServiceAccountKeys(google::test::admin::database::v1::ListServiceAccountKeysRequest const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->ListServiceAccountKeys(request),
      [this](grpc::ClientContext& context,
          google::test::admin::database::v1::ListServiceAccountKeysRequest const& request) {
        return stub_->ListServiceAccountKeys(context, request);
      },
      request, __func__);
}

Status
GoldenKitchenSinkConnectionImpl::DoNothing(google::protobuf::Empty const& request) {
  return google::cloud::internal::RetryLoop(
      retry_policy(), backoff_policy(),
      idempotency_policy()->DoNothing(request),
      [this](grpc::ClientContext& context,
          google::protobuf::Empty const& request) {
        return stub_->DoNothing(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_internal
}  // namespace cloud
}  // namespace google
