// Copyright 2020 The Gitea Authors. All rights reserved.
// Use of this source code is governed by a MIT-style
// license that can be found in the LICENSE file.

package context

import (
	"sync"

	"code.gitea.io/gitea/modules/cache"
	"code.gitea.io/gitea/modules/setting"

	"gitea.com/go-chi/captcha"
)

var imageCaptchaOnce sync.Once
var cpt *captcha.Captcha

// GetImageCaptcha returns global image captcha
func GetImageCaptcha() *captcha.Captcha {
	imageCaptchaOnce.Do(func() {
		cpt = captcha.NewCaptcha(captcha.Options{
			SubURL: setting.AppSubURL,
		})
		cpt.Store = cache.GetCache()
	})
	return cpt
}
