---
date: "2019-02-14T11:51:04+08:00"
title: "横向对比 Gitea 与其它 Git 托管工具"
slug: "comparison"
weight: 5
toc: false
draft: false
menu:
  sidebar:
    parent: "features"
    name: "横向对比"
    weight: 5
    identifier: "comparison"
---

# 横向对比 Gitea 与其它 Git 托管工具

这里列出了 Gitea 与其它一些 Git 托管工具之间的异同，以便确认 Gitea 是否能够满足您的需求。

请注意，此列表中的某些表项可能已经过时，因为我们并没有定期检查其它产品的功能是否有所更改。你可以前往 [Github issue](https://github.com/go-gitea/gitea/issues) 来帮助我们更新过时的内容，感谢！

_表格中的符号含义:_

* _✓ - 支持_

* _⁄ - 部分支持_

* _✘ - 不支持_

* _? - 不确定_

#### 主要特性

| 特性                  | Gitea | Gogs | GitHub EE | GitLab CE | GitLab EE | BitBucket | RhodeCode CE |
|-----------------------|-------|------|-----------|-----------|-----------|-----------|--------------|
| 开源免费              | ✓     | ✓    | ✘         | ✓         | ✘         | ✘         | ✓            |
| 低资源开销 (RAM/CPU)  | ✓     | ✓    | ✘         | ✘         | ✘         | ✘         | ✘            |
| 支持多种数据库        | ✓     | ✓    | ✘         | ⁄         | ⁄         | ✓         | ✓            |
| 支持多种操作系统      | ✓     | ✓    | ✘         | ✘         | ✘         | ✘         | ✓            |
| 升级简便              | ✓     | ✓    | ✘         | ✓         | ✓         | ✘         | ✓            |
| 支持 Markdown         | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 支持 Orgmode          | ✓     | ✘    | ✓         | ✘         | ✘         | ✘         | ?            |
| 支持 CSV              | ✓     | ✘    | ✓         | ✘         | ✘         | ✓         | ?            |
| 支持第三方渲染工具    | ✓     | ✘    | ✘         | ✘         | ✘         | ✓         | ?            |
| Git 驱动的静态 pages  | ✘     | ✘    | ✓         | ✓         | ✓         | ✘         | ✘            |
| Git 驱动的集成化 wiki | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✘            |
| 部署令牌              | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 仓库写权限令牌        | ✓     | ✘    | ✓         | ✓         | ✓         | ✘         | ✓            |
| 内置容器 Registry     | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |
| 外部 Git 镜像         | ✓     | ✓    | ✘         | ✘         | ✓         | ✓         | ✓            |
| FIDO U2F (2FA)        | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✘            |
| 内置 CI/CD            | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |
| 子组织：组织内的组织  | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✓            |

#### 代码管理

| 特性                                     | Gitea | Gogs | GitHub EE | GitLab CE | GitLab EE | BitBucket | RhodeCode CE |
|------------------------------------------|-------|------|-----------|-----------|-----------|-----------|--------------|
| 仓库主题描述                             | ✓     | ✘    | ✓         | ✓         | ✓         | ✘         | ✘            |
| 仓库内代码搜索                           | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 全局代码搜索                             | ✓     | ✘    | ✓         | ✘         | ✓         | ✓         | ✓            |
| Git LFS 2.0                              | ✓     | ✘    | ✓         | ✓         | ✓         | ⁄         | ✓            |
| 组织里程碑                               | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |
| 细粒度用户角色 (例如 Code, Issues, Wiki) | ✓     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |
| 提交人的身份验证                         | ✘     | ✘    | ?         | ✓         | ✓         | ✓         | ✘            |
| GPG 签名的提交                           | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 拒绝未用通过验证的提交                   | ✓     | ✘    | ✓         | ✓         | ✓         | ✘         | ✓            |
| 仓库活跃度页面                           | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 分支管理                                 | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 建立新分支                               | ✓     | ✘    | ✓         | ✓         | ✓         | ✘         | ✘            |
| 在线代码编辑                             | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 提交的统计图表                           | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |

#### Issue 管理

| 特性                 | Gitea | Gogs | GitHub EE | GitLab CE | GitLab EE | BitBucket | RhodeCode CE |
|----------------------|-------|------|-----------|-----------|-----------|-----------|--------------|
| 跟踪 Issue           | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✘            |
| Issue 模板           | ✓     | ✓    | ✓         | ✓         | ✓         | ✘         | ✘            |
| 标签                 | ✓     | ✓    | ✓         | ✓         | ✓         | ✘         | ✘            |
| 跟踪时间             | ✓     | ✘    | ✓         | ✓         | ✓         | ✘         | ✘            |
| Issue 可有多个负责人 | ✓     | ✘    | ✓         | ✘         | ✓         | ✘         | ✘            |
| 关联的 issues        | ✘     | ✘    | ⁄         | ✘         | ✓         | ✘         | ✘            |
| 私密 issues          | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |
| 评论反馈             | ✓     | ✘    | ✓         | ✓         | ✓         | ✘         | ✘            |
| 锁定讨论             | ✘     | ✘    | ✓         | ✓         | ✓         | ✘         | ✘            |
| Issue 批量处理       | ✓     | ✘    | ✓         | ✓         | ✓         | ✘         | ✘            |
| Issue 看板           | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |
| 从 issues 创建分支   | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |
| Issue 搜索           | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✘            |
| 全局 Issue 搜索      | ✘     | ✘    | ✓         | ✓         | ✓         | ✓         | ✘            |
| Issue 依赖           | ✓     | ✘    | ✘         | ✘         | ✘         | ✘         | ✘            |
| 通过 Email 创建工单 | [✘](https://github.com/go-gitea/gitea/issues/6226) | [✘](https://github.com/gogs/gogs/issues/2602) | ✘ | ✘ | ✓ | ✓ | ✘ |
| Service Desk | [✘](https://github.com/go-gitea/gitea/issues/6219) | ✘ | ✘ | ✘ | ✓ | ✘ | ✘ |

#### Pull/Merge requests

| 特性                                 | Gitea | Gogs | GitHub EE | GitLab CE | GitLab EE | BitBucket | RhodeCode CE |
|--------------------------------------|-------|------|-----------|-----------|-----------|-----------|--------------|
| Pull/Merge requests                  | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✓            |
| Squash merging                       | ✓     | ✘    | ✓         | ✘         | ✓         | ✓         | ✓            |
| Rebase merging                       | ✓     | ✓    | ✓         | ✘         | ⁄         | ✘         | ✓            |
| 评论 Pull/Merge request 中的某行代码 | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 指定 Pull/Merge request 的审核人     | ✓     | ✘    | ⁄         | ✓         | ✓         | ✓         | ✓            |
| 解决 Merge 冲突                      | ✘     | ✘    | ✓         | ✓         | ✓         | ✓         | ✘            |
| 限制某些用户的 push 和 merge 权限    | ✓     | ✘    | ✓         | ⁄         | ✓         | ✓         | ✓            |
| 回退某些 commits 或 merge request    | ✘     | ✘    | ✓         | ✓         | ✓         | ✓         | ✘            |
| Pull/Merge requests 模板             | ✓     | ✓    | ✓         | ✓         | ✓         | ✘         | ✘            |
| 查看 Cherry-picking 的更改           | ✘     | ✘    | ✘         | ✓         | ✓         | ✘         | ✘            |


#### 第三方集成

| 特性                       | Gitea | Gogs | GitHub EE | GitLab CE | GitLab EE | BitBucket | RhodeCode CE |
|----------------------------|-------|------|-----------|-----------|-----------|-----------|--------------|
| 支持 Webhook               | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 自定义 Git 钩子            | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 集成 AD / LDAP             | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 支持多个 LDAP / AD 服务    | ✓     | ✓    | ✘         | ✘         | ✓         | ✓         | ✓            |
| LDAP 用户同步              | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |
| 支持 OpenId 连接           | ✓     | ✘    | ✓         | ✓         | ✓         | ?         | ✘            |
| 集成 OAuth 2.0（外部授权） | ✓     | ✘    | ⁄         | ✓         | ✓         | ?         | ✓            |
| 作为 OAuth 2.0 provider    | [✓](https://github.com/go-gitea/gitea/pull/5378)     | ✘    | ✓         | ✓         | ✓         | ✓         | ✘            |
| 二次验证 (2FA)             | ✓     | ✓    | ✓         | ✓         | ✓         | ✓         | ✘            |
| 集成 Mattermost/Slack      | ✓     | ✓    | ⁄         | ✓         | ✓         | ⁄         | ✓            |
| 集成 Discord               | ✓     | ✓    | ✓         | ✓         | ✓         | ✘         | ✘            |
| 显示外部 CI/CD 的状态      | ✓     | ✘    | ✓         | ✓         | ✓         | ✓         | ✓            |
