// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
//
// Portions Copyright 2017 The Chromium OS Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the THIRD-PARTY file.

/*
 * automatically generated by rust-bindgen
 * From upstream linux include/uapi/linux/elf.h at commit:
 * 806276b7f07a39a1cc3f38bb1ef5c573d4594a38
 */
pub const EI_MAG0: ::std::os::raw::c_uint = 0;
pub const EI_MAG1: ::std::os::raw::c_uint = 1;
pub const EI_MAG2: ::std::os::raw::c_uint = 2;
pub const EI_MAG3: ::std::os::raw::c_uint = 3;
pub const EI_DATA: ::std::os::raw::c_uint = 5;

pub const ELFMAG0: ::std::os::raw::c_uint = 127;

pub const ELFDATA2LSB: ::std::os::raw::c_uint = 1;
pub const PT_LOAD: ::std::os::raw::c_uint = 1;

pub const ELFMAG1: u8 = b'E';
pub const ELFMAG2: u8 = b'L';
pub const ELFMAG3: u8 = b'F';

type Elf64_Addr = __u64;
type Elf64_Half = __u16;
type Elf64_Off = __u64;
type Elf64_Word = __u32;
type Elf64_Xword = __u64;

type __s8 = ::std::os::raw::c_schar;
type __u8 = ::std::os::raw::c_uchar;
type __s16 = ::std::os::raw::c_short;
type __u16 = ::std::os::raw::c_ushort;
type __s32 = ::std::os::raw::c_int;
type __u32 = ::std::os::raw::c_uint;
type __s64 = ::std::os::raw::c_longlong;
type __u64 = ::std::os::raw::c_ulonglong;

#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct elf64_hdr {
    pub e_ident: [::std::os::raw::c_uchar; 16usize],
    pub e_type: Elf64_Half,
    pub e_machine: Elf64_Half,
    pub e_version: Elf64_Word,
    pub e_entry: Elf64_Addr,
    pub e_phoff: Elf64_Off,
    pub e_shoff: Elf64_Off,
    pub e_flags: Elf64_Word,
    pub e_ehsize: Elf64_Half,
    pub e_phentsize: Elf64_Half,
    pub e_phnum: Elf64_Half,
    pub e_shentsize: Elf64_Half,
    pub e_shnum: Elf64_Half,
    pub e_shstrndx: Elf64_Half,
}
impl Clone for elf64_hdr {
    fn clone(&self) -> Self {
        *self
    }
}
pub type Elf64_Ehdr = elf64_hdr;

#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct elf64_phdr {
    pub p_type: Elf64_Word,
    pub p_flags: Elf64_Word,
    pub p_offset: Elf64_Off,
    pub p_vaddr: Elf64_Addr,
    pub p_paddr: Elf64_Addr,
    pub p_filesz: Elf64_Xword,
    pub p_memsz: Elf64_Xword,
    pub p_align: Elf64_Xword,
}

impl Clone for elf64_phdr {
    fn clone(&self) -> Self {
        *self
    }
}
pub type Elf64_Phdr = elf64_phdr;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    #[allow(clippy::zero_ptr)]
    fn bindgen_test_layout_elf64_phdr() {
        assert_eq!(
            ::std::mem::size_of::<elf64_phdr>(),
            56usize,
            concat!("Size of: ", stringify!(elf64_phdr))
        );
        assert_eq!(
            ::std::mem::align_of::<elf64_phdr>(),
            8usize,
            concat!("Alignment of ", stringify!(elf64_phdr))
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_type as *const _ as usize },
            0usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_type)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_flags as *const _ as usize },
            4usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_flags)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_offset as *const _ as usize },
            8usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_offset)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_vaddr as *const _ as usize },
            16usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_vaddr)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_paddr as *const _ as usize },
            24usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_paddr)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_filesz as *const _ as usize },
            32usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_filesz)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_memsz as *const _ as usize },
            40usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_memsz)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_phdr)).p_align as *const _ as usize },
            48usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_phdr),
                "::",
                stringify!(p_align)
            )
        );
    }

    #[test]
    #[allow(clippy::zero_ptr)]
    fn bindgen_test_layout_elf64_hdr() {
        assert_eq!(
            ::std::mem::size_of::<elf64_hdr>(),
            64usize,
            concat!("Size of: ", stringify!(elf64_hdr))
        );
        assert_eq!(
            ::std::mem::align_of::<elf64_hdr>(),
            8usize,
            concat!("Alignment of ", stringify!(elf64_hdr))
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_ident as *const _ as usize },
            0usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_ident)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_type as *const _ as usize },
            16usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_type)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_machine as *const _ as usize },
            18usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_machine)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_version as *const _ as usize },
            20usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_version)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_entry as *const _ as usize },
            24usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_entry)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_phoff as *const _ as usize },
            32usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_phoff)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_shoff as *const _ as usize },
            40usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_shoff)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_flags as *const _ as usize },
            48usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_flags)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_ehsize as *const _ as usize },
            52usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_ehsize)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_phentsize as *const _ as usize },
            54usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_phentsize)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_phnum as *const _ as usize },
            56usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_phnum)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_shentsize as *const _ as usize },
            58usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_shentsize)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_shnum as *const _ as usize },
            60usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_shnum)
            )
        );
        assert_eq!(
            unsafe { &(*(0 as *const elf64_hdr)).e_shstrndx as *const _ as usize },
            62usize,
            concat!(
                "Alignment of field: ",
                stringify!(elf64_hdr),
                "::",
                stringify!(e_shstrndx)
            )
        );
    }
}
