// Code generated by openapi-cli-generator. DO NOT EDIT.
// See https://github.com/exoscale/openapi-cli-generator

package x

import (
	"fmt"
	"strings"

	"github.com/exoscale/openapi-cli-generator/cli"
	"github.com/pkg/errors"
	"github.com/rs/zerolog/log"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
	"gopkg.in/h2non/gentleman.v2"
)

var xSubcommand bool

func xServers() []map[string]string {
	return []map[string]string{

		map[string]string{
			"description": "",
			"url":         "https://api-{zone}.exoscale.com/v2",
		},
	}
}

// XCreateAntiAffinityGroup Create an Anti-affinity Group
func XCreateAntiAffinityGroup(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-anti-affinity-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListAntiAffinityGroups List Anti-affinity Groups
func XListAntiAffinityGroups(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-anti-affinity-groups"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteAntiAffinityGroup Delete an Anti-affinity Group
func XDeleteAntiAffinityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-anti-affinity-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetAntiAffinityGroup Retrieve Anti-affinity Group details
func XGetAntiAffinityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-anti-affinity-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasCaCertificate Get a CA Certificate required to reach a DBaaS service through a TLS-protected connection.
func XGetDbaasCaCertificate(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-ca-certificate"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-ca-certificate"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceKafka Create a DBaaS Kafka service
func XCreateDbaasServiceKafka(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceKafka Get a DBaaS Kafka service
func XGetDbaasServiceKafka(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceKafka Update a DBaaS Kafka service
func XUpdateDbaasServiceKafka(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceMysql Create a DBaaS MySQL service
func XCreateDbaasServiceMysql(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceMysql Get a DBaaS MySQL service
func XGetDbaasServiceMysql(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceMysql Update a DBaaS MySQL service
func XUpdateDbaasServiceMysql(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServicePg Create a DBaaS PostgreSQL service
func XCreateDbaasServicePg(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServicePg Get a DBaaS PostgreSQL service
func XGetDbaasServicePg(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServicePg Update a DBaaS PostgreSQL service
func XUpdateDbaasServicePg(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceRedis Create a DBaaS Redis service
func XCreateDbaasServiceRedis(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-redis"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-redis/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceRedis Get a DBaaS Redis service
func XGetDbaasServiceRedis(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-redis"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-redis/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceRedis Update a DBaaS Redis service
func XUpdateDbaasServiceRedis(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-redis"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-redis/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasService Create a DBaaS service
func XCreateDbaasService(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasServices List DBaaS services
func XListDbaasServices(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-services"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasServiceTypes DBaaS Service Types
func XListDbaasServiceTypes(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-service-types"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service-type"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceType Get a DBaaS service type
func XGetDbaasServiceType(paramServiceTypeName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-type"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service-type/{service-type-name}"
	url = strings.Replace(url, "{service-type-name}", paramServiceTypeName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasService Delete a DBaaS service
func XDeleteDbaasService(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasService Get a DBaaS service
func XGetDbaasService(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasService Update a DBaaS service
func XUpdateDbaasService(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsKafka Get DBaaS Kafka settings
func XGetDbaasSettingsKafka(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-kafka"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsMysql Get DBaaS MySQL settings
func XGetDbaasSettingsMysql(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-mysql"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsPg Get DBaaS PostgreSQL settings
func XGetDbaasSettingsPg(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-pg"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsRedis Get DBaaS PostgreSQL settings
func XGetDbaasSettingsRedis(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-redis"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-redis"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDeployTargets List Deploy Targets
func XListDeployTargets(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-deploy-targets"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/deploy-target"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDeployTarget Retrieve Deploy Target details
func XGetDeployTarget(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-deploy-target"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/deploy-target/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDnsDomains List DNS domains
func XListDnsDomains(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dns-domains"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDnsDomain Retrieve DNS domain details
func XGetDnsDomain(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dns-domain"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDnsDomainRecords List DNS domain records
func XListDnsDomainRecords(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dns-domain-records"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{id}/record"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDnsDomainRecord Retrieve DNS domain record details
func XGetDnsDomainRecord(paramId string, paramRecordId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dns-domain-record"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{id}/record/{record-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{record-id}", paramRecordId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateElasticIp Create an Elastic IP
func XCreateElasticIp(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListElasticIps List Elastic IPs
func XListElasticIps(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-elastic-ips"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteElasticIp Delete an Elastic IP
func XDeleteElasticIp(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetElasticIp Retrieve Elastic IP details
func XGetElasticIp(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateElasticIp Update an Elastic IP
func XUpdateElasticIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetElasticIpField Reset an Elastic IP field to its default value
func XResetElasticIpField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-elastic-ip-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachInstanceToElasticIp Attach a Compute instance to an Elastic IP
func XAttachInstanceToElasticIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-instance-to-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}:attach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachInstanceFromElasticIp Detach a Compute instance from an Elastic IP
func XDetachInstanceFromElasticIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-instance-from-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}:detach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListEvents List Events
func XListEvents(params *viper.Viper) (*gentleman.Response, interface{}, error) {
	handlerPath := "list-events"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/event"

	req := cli.Client.Get().URL(url)

	paramFrom := params.GetString("from")
	if paramFrom != "" {
		req = req.AddQuery("from", fmt.Sprintf("%v", paramFrom))
	}
	paramTo := params.GetString("to")
	if paramTo != "" {
		req = req.AddQuery("to", fmt.Sprintf("%v", paramTo))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after
	}

	return resp, decoded, nil
}

// XCreateInstance Create a Compute instance
func XCreateInstance(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListInstances List Compute instances
func XListInstances(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-instances"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance"

	req := cli.Client.Get().URL(url)

	paramManagerId := params.GetString("manager-id")
	if paramManagerId != "" {
		req = req.AddQuery("manager-id", fmt.Sprintf("%v", paramManagerId))
	}
	paramManagerType := params.GetString("manager-type")
	if paramManagerType != "" {
		req = req.AddQuery("manager-type", fmt.Sprintf("%v", paramManagerType))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateInstancePool Create an Instance Pool
func XCreateInstancePool(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListInstancePools List Instance Pools
func XListInstancePools(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-instance-pools"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteInstancePool Delete an Instance Pool
func XDeleteInstancePool(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetInstancePool Retrieve Instance Pool details
func XGetInstancePool(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateInstancePool Update an Instance Pool
func XUpdateInstancePool(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetInstancePoolField Reset an Instance Pool field to its default value
func XResetInstancePoolField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-instance-pool-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XEvictInstancePoolMembers Evict Instance Pool members
func XEvictInstancePoolMembers(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "evict-instance-pool-members"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}:evict"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XScaleInstancePool Scale an Instance Pool
func XScaleInstancePool(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "scale-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}:scale"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListInstanceTypes List Compute instance Types
func XListInstanceTypes(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-instance-types"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-type"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetInstanceType Retrieve Instance Type details
func XGetInstanceType(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-instance-type"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-type/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteInstance Delete a Compute instance
func XDeleteInstance(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetInstance Retrieve Compute instance details
func XGetInstance(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateInstance Update a Compute instance
func XUpdateInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetInstanceField Reset Instance field
func XResetInstanceField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-instance-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSnapshot Create a Snapshot of a Compute instance
func XCreateSnapshot(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:create-snapshot"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRebootInstance Reboot a Compute instance
func XRebootInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reboot-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:reboot"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetInstance Reset a Compute instance to a base/target template
func XResetInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:reset"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResizeInstanceDisk Resize a Compute instance disk
func XResizeInstanceDisk(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "resize-instance-disk"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:resize-disk"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XScaleInstance Scale a Compute instance to a new Instance Type
func XScaleInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "scale-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:scale"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartInstance Start a Compute instance
func XStartInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:start"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStopInstance Stop a Compute instance
func XStopInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "stop-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:stop"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevertInstanceToSnapshot Revert a snapshot for an instance
func XRevertInstanceToSnapshot(paramInstanceId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "revert-instance-to-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{instance-id}:revert-snapshot"
	url = strings.Replace(url, "{instance-id}", paramInstanceId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateLoadBalancer Create a Load Balancer
func XCreateLoadBalancer(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListLoadBalancers List Load Balancers
func XListLoadBalancers(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-load-balancers"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteLoadBalancer Delete a Load Balancer
func XDeleteLoadBalancer(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetLoadBalancer Retrieve Load Balancer details
func XGetLoadBalancer(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateLoadBalancer Update a Load Balancer
func XUpdateLoadBalancer(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAddServiceToLoadBalancer Add a Load Balancer Service
func XAddServiceToLoadBalancer(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "add-service-to-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteLoadBalancerService Delete a Load Balancer Service
func XDeleteLoadBalancerService(paramId string, paramServiceId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-load-balancer-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetLoadBalancerService Retrieve Load Balancer Service details
func XGetLoadBalancerService(paramId string, paramServiceId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-load-balancer-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateLoadBalancerService Update a Load Balancer Service
func XUpdateLoadBalancerService(paramId string, paramServiceId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-load-balancer-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetLoadBalancerServiceField Reset a Load Balancer Service field to its default value
func XResetLoadBalancerServiceField(paramId string, paramServiceId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-load-balancer-service-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetLoadBalancerField Reset a Load Balancer field to its default value
func XResetLoadBalancerField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-load-balancer-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetOperation Retrieve Operation details
func XGetOperation(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-operation"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/operation/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreatePrivateNetwork Create a Private Network
func XCreatePrivateNetwork(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListPrivateNetworks List Private Networks
func XListPrivateNetworks(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-private-networks"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeletePrivateNetwork Delete a Private Network
func XDeletePrivateNetwork(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetPrivateNetwork Retrieve Private Network details
func XGetPrivateNetwork(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdatePrivateNetwork Update a Private Network
func XUpdatePrivateNetwork(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetPrivateNetworkField Reset Private Network field
func XResetPrivateNetworkField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-private-network-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachInstanceToPrivateNetwork Attach a Compute instance to a Private Network
func XAttachInstanceToPrivateNetwork(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-instance-to-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}:attach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachInstanceFromPrivateNetwork Detach a Compute instance from a Private Network
func XDetachInstanceFromPrivateNetwork(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-instance-from-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}:detach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdatePrivateNetworkInstanceIp Update the IP address of an instance attached to a managed private network
func XUpdatePrivateNetworkInstanceIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-private-network-instance-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}:update-ip"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListQuotas List Organization Quotas
func XListQuotas(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-quotas"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/quota"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetQuota Retrieve Resource Quota
func XGetQuota(paramEntity string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-quota"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/quota/{entity}"
	url = strings.Replace(url, "{entity}", paramEntity, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSecurityGroup Create a Security Group
func XCreateSecurityGroup(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSecurityGroups List Security Groups
func XListSecurityGroups(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-security-groups"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSecurityGroup Delete a Security Group
func XDeleteSecurityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSecurityGroup Retrieve Security Group details
func XGetSecurityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAddRuleToSecurityGroup Create a Security Group rule
func XAddRuleToSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "add-rule-to-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}/rules"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteRuleFromSecurityGroup Delete a Security Group rule
func XDeleteRuleFromSecurityGroup(paramId string, paramRuleId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-rule-from-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}/rules/{rule-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{rule-id}", paramRuleId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAddExternalSourceToSecurityGroup Add an external source as a member of a Security Group
func XAddExternalSourceToSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "add-external-source-to-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:add-source"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachInstanceToSecurityGroup Attach a Compute instance to a Security Group
func XAttachInstanceToSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-instance-to-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:attach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachInstanceFromSecurityGroup Detach a Compute instance from a Security Group
func XDetachInstanceFromSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-instance-from-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:detach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRemoveExternalSourceFromSecurityGroup Remove an external source from a Security Group
func XRemoveExternalSourceFromSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "remove-external-source-from-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:remove-source"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSksCluster Create an SKS cluster
func XCreateSksCluster(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSksClusters List SKS clusters
func XListSksClusters(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-sks-clusters"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGenerateSksClusterKubeconfig Generate a new Kubeconfig file for a SKS cluster
func XGenerateSksClusterKubeconfig(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "generate-sks-cluster-kubeconfig"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster-kubeconfig/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSksClusterVersions List available versions for SKS clusters
func XListSksClusterVersions(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-sks-cluster-versions"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster-version"

	req := cli.Client.Get().URL(url)

	paramIncludeDeprecated := params.GetString("include-deprecated")
	if paramIncludeDeprecated != "" {
		req = req.AddQuery("include-deprecated", fmt.Sprintf("%v", paramIncludeDeprecated))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSksCluster Delete an SKS cluster
func XDeleteSksCluster(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSksCluster Retrieve SKS cluster details
func XGetSksCluster(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateSksCluster Update an SKS cluster
func XUpdateSksCluster(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSksClusterAuthorityCert Get the certificate for a SKS cluster authority
func XGetSksClusterAuthorityCert(paramId string, paramAuthority string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sks-cluster-authority-cert"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/authority/{authority}/cert"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{authority}", paramAuthority, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSksNodepool Create a new SKS Nodepool
func XCreateSksNodepool(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSksNodepool Delete an SKS Nodepool
func XDeleteSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSksNodepool Retrieve SKS Nodepool details
func XGetSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateSksNodepool Update an SKS Nodepool
func XUpdateSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetSksNodepoolField Reset an SKS Nodepool field to its default value
func XResetSksNodepoolField(paramId string, paramSksNodepoolId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-sks-nodepool-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XEvictSksNodepoolMembers Evict Nodepool members
func XEvictSksNodepoolMembers(paramId string, paramSksNodepoolId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "evict-sks-nodepool-members"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}:evict"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XScaleSksNodepool Scale a SKS Nodepool
func XScaleSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "scale-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}:scale"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRotateSksCcmCredentials Rotate Exoscale CCM credentials
func XRotateSksCcmCredentials(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "rotate-sks-ccm-credentials"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/rotate-ccm-credentials"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpgradeSksCluster Upgrade an SKS cluster
func XUpgradeSksCluster(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "upgrade-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/upgrade"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpgradeSksClusterServiceLevel Upgrade a SKS cluster to pro
func XUpgradeSksClusterServiceLevel(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "upgrade-sks-cluster-service-level"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/upgrade-service-level"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetSksClusterField Reset an SKS cluster field to its default value
func XResetSksClusterField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-sks-cluster-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSnapshots List Snapshots
func XListSnapshots(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-snapshots"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSnapshot Delete a Snapshot
func XDeleteSnapshot(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSnapshot Retrieve Snapshot details
func XGetSnapshot(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XExportSnapshot Export a Snapshot
func XExportSnapshot(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "export-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}:export"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XPromoteSnapshotToTemplate Promote a Snapshot to a Template
func XPromoteSnapshotToTemplate(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "promote-snapshot-to-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}:promote"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSosPresignedUrl Retrieve Presigned Download URL for SOS object
func XGetSosPresignedUrl(paramBucket string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sos-presigned-url"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sos/{bucket}/presigned-url"
	url = strings.Replace(url, "{bucket}", paramBucket, 1)

	req := cli.Client.Get().URL(url)

	paramKey := params.GetString("key")
	if paramKey != "" {
		req = req.AddQuery("key", fmt.Sprintf("%v", paramKey))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSshKeys List SSH keys
func XListSshKeys(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-ssh-keys"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRegisterSshKey Import SSH key
func XRegisterSshKey(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "register-ssh-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSshKey Delete a SSH key
func XDeleteSshKey(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-ssh-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSshKey Retrieve SSH key details
func XGetSshKey(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-ssh-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListTemplates List Templates
func XListTemplates(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-templates"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template"

	req := cli.Client.Get().URL(url)

	paramVisibility := params.GetString("visibility")
	if paramVisibility != "" {
		req = req.AddQuery("visibility", fmt.Sprintf("%v", paramVisibility))
	}
	paramFamily := params.GetString("family")
	if paramFamily != "" {
		req = req.AddQuery("family", fmt.Sprintf("%v", paramFamily))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRegisterTemplate Register a Template
func XRegisterTemplate(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "register-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCopyTemplate Copy a Template from a zone to another
func XCopyTemplate(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "copy-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteTemplate Delete a Template
func XDeleteTemplate(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetTemplate Retrieve Template details
func XGetTemplate(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateTemplate Update template attributes
func XUpdateTemplate(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListZones List Zones
func XListZones(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-zones"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/zone"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

func xRegister(subcommand bool) {
	root := cli.Root

	if subcommand {
		root = &cobra.Command{
			Use:   "x",
			Short: "Exoscale Public API",
			Long:  cli.Markdown("\nInfrastructure automation API, allowing programmatic access to all Exoscale products and services.\n\nThe [OpenAPI Specification](http://spec.openapis.org/oas/v3.0.3.html) source of this documentation can be obtained here:\n\n* [JSON format](https://bump.sh/doc/exoscale-api.json)\n* [YAML format](https://bump.sh/doc/exoscale-api.yaml)"),
		}
		xSubcommand = true
	} else {
		cli.Root.Short = "Exoscale Public API"
		cli.Root.Long = cli.Markdown("\nInfrastructure automation API, allowing programmatic access to all Exoscale products and services.\n\nThe [OpenAPI Specification](http://spec.openapis.org/oas/v3.0.3.html) source of this documentation can be obtained here:\n\n* [JSON format](https://bump.sh/doc/exoscale-api.json)\n* [YAML format](https://bump.sh/doc/exoscale-api.yaml)")
	}

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-anti-affinity-group",
			Short:   "Create an Anti-affinity Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Anti-affinity Group description\n    maxLength: 255\n    minLength: 1\n    type: string\n  name:\n    description: Anti-affinity Group name\n    maxLength: 255\n    minLength: 1\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateAntiAffinityGroup(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-anti-affinity-groups",
			Short:   "List Anti-affinity Groups",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListAntiAffinityGroups(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-anti-affinity-group id",
			Short:   "Delete an Anti-affinity Group",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteAntiAffinityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-anti-affinity-group id",
			Short:   "Retrieve Anti-affinity Group details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetAntiAffinityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-ca-certificate",
			Short:   "Get a CA Certificate required to reach a DBaaS service through a TLS-protected connection.",
			Long:    cli.Markdown("Get a DBaaS CA Certificate"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasCaCertificate(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-kafka name",
			Short:   "Create a DBaaS Kafka service",
			Long:    cli.Markdown("Create a DBaaS Kafka service\n## Request Schema (application/json)\n\nproperties:\n  authentication-methods:\n    description: Kafka authentication methods\n    properties:\n      certificate:\n        description: Enable certificate/SSL authentication\n        type: boolean\n      sasl:\n        description: Enable SASL authentication\n        type: boolean\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  kafka-connect-enabled:\n    description: Allow clients to connect to kafka_connect from the public internet\n      for service nodes that are in a project VPC or another type of private network\n    type: boolean\n  kafka-connect-settings:\n    description: Kafka Connect configuration values\n    type: object\n  kafka-rest-enabled:\n    description: Enable Kafka-REST service\n    type: boolean\n  kafka-rest-settings:\n    description: Kafka REST configuration\n    type: object\n  kafka-settings:\n    description: Kafka-specific settings\n    type: object\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  schema-registry-enabled:\n    description: Enable Schema-Registry service\n    type: boolean\n  schema-registry-settings:\n    description: Schema Registry configuration\n    type: object\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  version:\n    description: Kafka major version\n    minLength: 1\n    type: string\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceKafka(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-kafka name",
			Short:   "Get a DBaaS Kafka service",
			Long:    cli.Markdown("Get a DBaaS Kafka service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceKafka(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-kafka name",
			Short:   "Update a DBaaS Kafka service",
			Long:    cli.Markdown("Update a DBaaS Kafka service\n## Request Schema (application/json)\n\nproperties:\n  authentication-methods:\n    description: Kafka authentication methods\n    properties:\n      certificate:\n        description: Enable certificate/SSL authentication\n        type: boolean\n      sasl:\n        description: Enable SASL authentication\n        type: boolean\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  kafka-connect-enabled:\n    description: Allow clients to connect to kafka_connect from the public internet\n      for service nodes that are in a project VPC or another type of private network\n    type: boolean\n  kafka-connect-settings:\n    description: Kafka Connect configuration values\n    type: object\n  kafka-rest-enabled:\n    description: Enable Kafka-REST service\n    type: boolean\n  kafka-rest-settings:\n    description: Kafka REST configuration\n    type: object\n  kafka-settings:\n    description: Kafka-specific settings\n    type: object\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  schema-registry-enabled:\n    description: Enable Schema-Registry service\n    type: boolean\n  schema-registry-settings:\n    description: Schema Registry configuration\n    type: object\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceKafka(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-mysql name",
			Short:   "Create a DBaaS MySQL service",
			Long:    cli.Markdown("Create a DBaaS MySQL service\n## Request Schema (application/json)\n\nproperties:\n  admin-password:\n    description: Custom password for admin user. Defaults to random string. This must\n      be set only when a new service is being created.\n    maxLength: 256\n    minLength: 8\n    type: string\n  admin-username:\n    description: Custom username for admin user. This must be set only when a new\n      service is being created.\n    maxLength: 64\n    minLength: 1\n    type: string\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  binlog-retention-period:\n    description: The minimum amount of time in seconds to keep binlog entries before\n      deletion. This may be extended for services that require binlog entries for\n      longer than the default for example if using the MySQL Debezium Kafka connector.\n    format: int64\n    maximum: 86400\n    minimum: 600\n    type: integer\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    type: object\n  mysql-settings:\n    description: MySQL-specific settings\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  recovery-backup-time:\n    description: ISO time of a backup to recover from for services that support arbitrary\n      times\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  version:\n    description: MySQL major version\n    minLength: 1\n    type: string\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceMysql(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-mysql name",
			Short:   "Get a DBaaS MySQL service",
			Long:    cli.Markdown("Get a DBaaS MySQL service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceMysql(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-mysql name",
			Short:   "Update a DBaaS MySQL service",
			Long:    cli.Markdown("Update a DBaaS MySQL service\n## Request Schema (application/json)\n\nproperties:\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  binlog-retention-period:\n    description: The minimum amount of time in seconds to keep binlog entries before\n      deletion. This may be extended for services that require binlog entries for\n      longer than the default for example if using the MySQL Debezium Kafka connector.\n    format: int64\n    maximum: 86400\n    minimum: 600\n    type: integer\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    type: object\n  mysql-settings:\n    description: MySQL-specific settings\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceMysql(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-pg name",
			Short:   "Create a DBaaS PostgreSQL service",
			Long:    cli.Markdown("Create a DBaaS PostgreSQL service\n## Request Schema (application/json)\n\nproperties:\n  admin-password:\n    description: Custom password for admin user. Defaults to random string. This must\n      be set only when a new service is being created.\n    maxLength: 256\n    minLength: 8\n    type: string\n  admin-username:\n    description: Custom username for admin user. This must be set only when a new\n      service is being created.\n    maxLength: 64\n    minLength: 1\n    type: string\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    type: object\n  pg-settings:\n    description: PostgreSQL-specific settings\n    type: object\n  pgbouncer-settings:\n    description: PGBouncer connection pooling settings\n    type: object\n  pglookout-settings:\n    description: PGLookout settings\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  recovery-backup-time:\n    description: ISO time of a backup to recover from for services that support arbitrary\n      times\n    minLength: 1\n    type: string\n  shared-buffers-percentage:\n    description: Percentage of total RAM that the database server uses for shared\n      memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%.\n      This setting adjusts the shared_buffers configuration value.\n    format: int64\n    maximum: 60\n    minimum: 20\n    type: integer\n  synchronous-replication:\n    $ref: '#/components/schemas/enum-pg-synchronous-replication'\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  timescaledb-settings:\n    description: TimescaleDB extension configuration values\n    type: object\n  variant:\n    $ref: '#/components/schemas/enum-pg-variant'\n  version:\n    description: PostgreSQL major version\n    minLength: 1\n    type: string\n  work-mem:\n    description: Sets the maximum amount of memory to be used by a query operation\n      (such as a sort or hash table) before writing to temporary disk files, in MB.\n      Default is 1MB + 0.075% of total RAM (up to 32MB).\n    format: int64\n    maximum: 1024\n    minimum: 1\n    type: integer\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServicePg(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-pg name",
			Short:   "Get a DBaaS PostgreSQL service",
			Long:    cli.Markdown("Get a DBaaS PostgreSQL service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServicePg(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-pg name",
			Short:   "Update a DBaaS PostgreSQL service",
			Long:    cli.Markdown("Update a DBaaS PostgreSQL service\n## Request Schema (application/json)\n\nproperties:\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started.\n          New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    type: object\n  pg-settings:\n    description: PostgreSQL-specific settings\n    type: object\n  pgbouncer-settings:\n    description: PGBouncer connection pooling settings\n    type: object\n  pglookout-settings:\n    description: PGLookout settings\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  shared-buffers-percentage:\n    description: Percentage of total RAM that the database server uses for shared\n      memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%.\n      This setting adjusts the shared_buffers configuration value.\n    format: int64\n    maximum: 60\n    minimum: 20\n    type: integer\n  synchronous-replication:\n    $ref: '#/components/schemas/enum-pg-synchronous-replication'\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  timescaledb-settings:\n    description: TimescaleDB extension configuration values\n    type: object\n  variant:\n    $ref: '#/components/schemas/enum-pg-variant'\n  work-mem:\n    description: Sets the maximum amount of memory to be used by a query operation\n      (such as a sort or hash table) before writing to temporary disk files, in MB.\n      Default is 1MB + 0.075% of total RAM (up to 32MB).\n    format: int64\n    maximum: 1024\n    minimum: 1\n    type: integer\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServicePg(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-redis name",
			Short:   "Create a DBaaS Redis service",
			Long:    cli.Markdown("Create a DBaaS Redis service\n## Request Schema (application/json)\n\nproperties:\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  recovery-backup-name:\n    description: Name of a backup to recover from for services that support backup\n      names\n    minLength: 1\n    type: string\n  redis-settings:\n    description: Redis.conf settings\n    type: object\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceRedis(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-redis name",
			Short:   "Get a DBaaS Redis service",
			Long:    cli.Markdown("Get a DBaaS Redis service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceRedis(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-redis name",
			Short:   "Update a DBaaS Redis service",
			Long:    cli.Markdown("Update a DBaaS Redis service\n## Request Schema (application/json)\n\nproperties:\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  redis-settings:\n    description: Redis.conf settings\n    type: object\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceRedis(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service",
			Short:   "Create a DBaaS service",
			Long:    cli.Markdown("Create a DBaaS service\n## Request Schema (application/json)\n\nproperties:\n  backup-name:\n    description: Name of a backup to recover from for services that support backup\n      names\n    minLength: 1\n    type: string\n  backup-time:\n    description: ISO time of a backup to recover from for services that support arbitrary\n      times\n    minLength: 1\n    type: string\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  integrations:\n    description: Integrations with other services\n    items:\n      $ref: '#/components/schemas/dbaas-service-integration'\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  name:\n    $ref: '#/components/schemas/dbaas-service-name'\n  plan:\n    description: Subscription plan\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  type:\n    $ref: '#/components/schemas/dbaas-service-type-name'\n  user-config:\n    description: Service type-specific settings\n    type: object\nrequired:\n- plan\n- name\n- type\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasService(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-services",
			Short:   "List DBaaS services",
			Long:    cli.Markdown("List DBaaS services"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasServices(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-service-types",
			Short:   "DBaaS Service Types",
			Long:    cli.Markdown("List available service types for DBaaS"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasServiceTypes(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-type service-type-name",
			Short:   "Get a DBaaS service type",
			Long:    cli.Markdown("Get a DBaaS service type"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceType(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service name",
			Short:   "Delete a DBaaS service",
			Long:    cli.Markdown("Delete a DBaaS service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasService(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service name",
			Short:   "Get a DBaaS service",
			Long:    cli.Markdown("Get a DBaaS service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasService(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service name",
			Short:   "Update a DBaaS service",
			Long:    cli.Markdown("Update a DBaaS service\n## Request Schema (application/json)\n\nproperties:\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  plan:\n    description: Subscription plan\n    minLength: 1\n    type: string\n  powered:\n    description: Power-on the service (true) or power-off (false)\n    type: boolean\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  user-config:\n    description: Service type-specific settings\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasService(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-kafka",
			Short:   "Get DBaaS Kafka settings",
			Long:    cli.Markdown("Get DBaaS Kafka settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsKafka(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-mysql",
			Short:   "Get DBaaS MySQL settings",
			Long:    cli.Markdown("Get DBaaS MySQL settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsMysql(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-pg",
			Short:   "Get DBaaS PostgreSQL settings",
			Long:    cli.Markdown("Get DBaaS PostgreSQL settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsPg(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-redis",
			Short:   "Get DBaaS PostgreSQL settings",
			Long:    cli.Markdown("Get DBaaS PostgreSQL settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsRedis(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-deploy-targets",
			Short:   "List Deploy Targets",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDeployTargets(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-deploy-target id",
			Short:   "Retrieve Deploy Target details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDeployTarget(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dns-domains",
			Short:   "List DNS domains",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDnsDomains(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dns-domain id",
			Short:   "Retrieve DNS domain details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDnsDomain(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dns-domain-records id",
			Short:   "List DNS domain records",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDnsDomainRecords(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dns-domain-record id record-id",
			Short:   "Retrieve DNS domain record details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDnsDomainRecord(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-elastic-ip",
			Short:   "Create an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Elastic IP description\n    maxLength: 255\n    minLength: 1\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/elastic-ip-healthcheck'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateElasticIp(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-elastic-ips",
			Short:   "List Elastic IPs",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListElasticIps(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-elastic-ip id",
			Short:   "Delete an Elastic IP",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteElasticIp(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-elastic-ip id",
			Short:   "Retrieve Elastic IP details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetElasticIp(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-elastic-ip id",
			Short:   "Update an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Elastic IP description\n    maxLength: 255\n    minLength: 1\n    nullable: true\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/elastic-ip-healthcheck'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateElasticIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-elastic-ip-field id field",
			Short:   "Reset an Elastic IP field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetElasticIpField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-instance-to-elastic-ip id",
			Short:   "Attach a Compute instance to an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachInstanceToElasticIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-instance-from-elastic-ip id",
			Short:   "Detach a Compute instance from an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachInstanceFromElasticIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-events",
			Short:   "List Events",
			Long:    cli.Markdown("Retrieve Events for a given date range. Defaults to retrieving Events\n          for the current and previous day. Both a `from` and `to` arguments can\n          be passed specifying dates to start from and to"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListEvents(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("from", "", "")
		cmd.Flags().String("to", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-instance",
			Short:   "Create a Compute instance",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Instance Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  disk-size:\n    description: Instance disk size in GB\n    format: int64\n    maximum: 50000\n    minimum: 10\n    type: integer\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  ipv6-enabled:\n    description: Enable IPv6\n    type: boolean\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Instance name\n    maxLength: 255\n    minLength: 1\n    type: string\n  security-groups:\n    description: Instance Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  ssh-key:\n    $ref: '#/components/schemas/ssh-key'\n  template:\n    $ref: '#/components/schemas/template'\n  user-data:\n    description: Instance Cloud-init user-data\n    minLength: 1\n    type: string\nrequired:\n- disk-size\n- instance-type\n- template\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateInstance(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-instances",
			Short:   "List Compute instances",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListInstances(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("manager-id", "", "")
		cmd.Flags().String("manager-type", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-instance-pool",
			Short:   "Create an Instance Pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Instance Pool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Instance Pool description\n    maxLength: 255\n    minLength: 1\n    type: string\n  disk-size:\n    description: Instances disk size in GB\n    format: int64\n    maximum: 50000\n    minimum: 10\n    type: integer\n  elastic-ips:\n    description: Instances Elastic IPs\n    items:\n      $ref: '#/components/schemas/elastic-ip'\n    type: array\n    uniqueItems: true\n  instance-prefix:\n    description: 'Prefix to apply to instances names (default: pool)'\n    maxLength: 30\n    minLength: 1\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  ipv6-enabled:\n    description: Enable IPv6 for instances\n    type: boolean\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Instance Pool name\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Instance Pool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    type: array\n    uniqueItems: true\n  security-groups:\n    description: Instance Pool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  size:\n    description: Number of instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  ssh-key:\n    $ref: '#/components/schemas/ssh-key'\n  template:\n    $ref: '#/components/schemas/template'\n  user-data:\n    description: Instances Cloud-init user-data\n    minLength: 1\n    type: string\nrequired:\n- name\n- size\n- instance-type\n- template\n- disk-size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateInstancePool(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-instance-pools",
			Short:   "List Instance Pools",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListInstancePools(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-instance-pool id",
			Short:   "Delete an Instance Pool",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteInstancePool(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-instance-pool id",
			Short:   "Retrieve Instance Pool details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetInstancePool(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-instance-pool id",
			Short:   "Update an Instance Pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Instance Pool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Instance Pool description\n    maxLength: 255\n    minLength: 1\n    nullable: true\n    type: string\n  disk-size:\n    description: Instances disk size in GB\n    format: int64\n    maximum: 50000\n    minimum: 10\n    type: integer\n  elastic-ips:\n    description: Instances Elastic IPs\n    items:\n      $ref: '#/components/schemas/elastic-ip'\n    type: array\n  instance-prefix:\n    description: 'Prefix to apply to instances names (default: pool)'\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  ipv6-enabled:\n    description: Enable IPv6 for instances\n    type: boolean\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Instance Pool name\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Instance Pool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    type: array\n    uniqueItems: true\n  security-groups:\n    description: Instance Pool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  ssh-key:\n    $ref: '#/components/schemas/ssh-key'\n  template:\n    $ref: '#/components/schemas/template'\n  user-data:\n    description: Instances Cloud-init user-data\n    minLength: 1\n    nullable: true\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateInstancePool(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-instance-pool-field id field",
			Short:   "Reset an Instance Pool field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetInstancePoolField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "evict-instance-pool-members id",
			Short:   "Evict Instance Pool members",
			Long:    cli.Markdown("This operation evicts the specified Compute instances member from the Instance Pool, shrinking it to `&lt;current pool size&gt; - &lt;# evicted members&gt;`.\n## Request Schema (application/json)\n\nproperties:\n  instances:\n    items:\n      format: uuid\n      type: string\n    type: array\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XEvictInstancePoolMembers(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "scale-instance-pool id",
			Short:   "Scale an Instance Pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  size:\n    description: Number of managed instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\nrequired:\n- size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XScaleInstancePool(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-instance-types",
			Short:   "List Compute instance Types",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListInstanceTypes(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-instance-type id",
			Short:   "Retrieve Instance Type details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetInstanceType(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-instance id",
			Short:   "Delete a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteInstance(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-instance id",
			Short:   "Retrieve Compute instance details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetInstance(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-instance id",
			Short:   "Update a Compute instance",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Instance name\n    maxLength: 255\n    minLength: 1\n    type: string\n  user-data:\n    description: Instance Cloud-init user-data\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-instance-field id field",
			Short:   "Reset Instance field",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetInstanceField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-snapshot id",
			Short:   "Create a Snapshot of a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reboot-instance id",
			Short:   "Reboot a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRebootInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-instance id",
			Short:   "Reset a Compute instance to a base/target template",
			Long:    cli.Markdown("This operation re-installs a Compute instance to a base template. If target template is provided it will be used to recreated instance from. Warning: the operation wipes all data stored on the disk.\n## Request Schema (application/json)\n\nproperties:\n  disk-size:\n    description: Instance disk size in GB\n    format: int64\n    maximum: 50000\n    minimum: 10\n    type: integer\n  template:\n    $ref: '#/components/schemas/template'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "resize-instance-disk id",
			Short:   "Resize a Compute instance disk",
			Long:    cli.Markdown("This operation resizes a Compute instance's disk volume. Note: the disk can only grow, cannot be shrunk.\n## Request Schema (application/json)\n\nproperties:\n  disk-size:\n    description: Instance disk size in GB\n    format: int64\n    maximum: 50000\n    minimum: 10\n    type: integer\nrequired:\n- disk-size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResizeInstanceDisk(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "scale-instance id",
			Short:   "Scale a Compute instance to a new Instance Type",
			Long:    cli.Markdown("This operation changes the Compute instance's type. Note: the new Instance Type must be within the same family (e.g. a standard instance cannot be scaled to gpu2 or storage).\n## Request Schema (application/json)\n\nproperties:\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\nrequired:\n- instance-type\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XScaleInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-instance id",
			Short:   "Start a Compute instance",
			Long:    cli.Markdown("This operation starts a virtual machine, potentially using a rescue profile if specified\n## Request Schema (application/json)\n\nproperties:\n  rescue-profile:\n    description: 'Boot in Rescue Mode, using named profile (supported: netboot, netboot-efi)'\n    enum:\n    - netboot-efi\n    - netboot\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "stop-instance id",
			Short:   "Stop a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStopInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "revert-instance-to-snapshot instance-id",
			Short:   "Revert a snapshot for an instance",
			Long:    cli.Markdown("This operation reverts the snapshot to the Compute instance volume, restoring stored data as it was at the time of the snapshot.\nThe Compute instance must be previously stopped.\n## Request Schema (application/json)\n\nproperties:\n  id:\n    description: Snapshot ID\n    format: uuid\n    type: string\nrequired:\n- id\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRevertInstanceToSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-load-balancer",
			Short:   "Create a Load Balancer",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Load Balancer description\n    maxLength: 255\n    minLength: 1\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Load Balancer name\n    maxLength: 255\n    minLength: 1\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateLoadBalancer(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-load-balancers",
			Short:   "List Load Balancers",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListLoadBalancers(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-load-balancer id",
			Short:   "Delete a Load Balancer",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteLoadBalancer(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-load-balancer id",
			Short:   "Retrieve Load Balancer details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetLoadBalancer(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-load-balancer id",
			Short:   "Update a Load Balancer",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    maxLength: 255\n    nullable: true\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    maxLength: 255\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateLoadBalancer(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "add-service-to-load-balancer id",
			Short:   "Add a Load Balancer Service",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Load Balancer Service description\n    maxLength: 255\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/load-balancer-service-healthcheck'\n  instance-pool:\n    $ref: '#/components/schemas/instance-pool'\n  name:\n    description: Load Balancer Service name\n    maxLength: 255\n    minLength: 1\n    type: string\n  port:\n    description: Port exposed on the Load Balancer's public IP\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  protocol:\n    description: Network traffic protocol\n    enum:\n    - tcp\n    - udp\n    type: string\n  strategy:\n    description: Load balancing strategy\n    enum:\n    - round-robin\n    - source-hash\n    type: string\n  target-port:\n    description: Port on which the network traffic will be forwarded to on the receiving\n      instance\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\nrequired:\n- name\n- instance-pool\n- protocol\n- strategy\n- port\n- target-port\n- healthcheck\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAddServiceToLoadBalancer(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-load-balancer-service id service-id",
			Short:   "Delete a Load Balancer Service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteLoadBalancerService(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-load-balancer-service id service-id",
			Short:   "Retrieve Load Balancer Service details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetLoadBalancerService(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-load-balancer-service id service-id",
			Short:   "Update a Load Balancer Service",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Load Balancer Service description\n    maxLength: 255\n    nullable: true\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/load-balancer-service-healthcheck'\n  name:\n    description: Load Balancer Service name\n    maxLength: 255\n    type: string\n  port:\n    description: Port exposed on the Load Balancer's public IP\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  protocol:\n    description: Network traffic protocol\n    enum:\n    - tcp\n    - udp\n    type: string\n  strategy:\n    description: Load balancing strategy\n    enum:\n    - round-robin\n    - source-hash\n    type: string\n  target-port:\n    description: Port on which the network traffic will be forwarded to on the receiving\n      instance\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateLoadBalancerService(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-load-balancer-service-field id service-id field",
			Short:   "Reset a Load Balancer Service field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(3),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetLoadBalancerServiceField(args[0], args[1], args[2], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-load-balancer-field id field",
			Short:   "Reset a Load Balancer field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetLoadBalancerField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-operation id",
			Short:   "Retrieve Operation details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetOperation(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-private-network",
			Short:   "Create a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Private Network description\n    maxLength: 255\n    minLength: 1\n    type: string\n  end-ip:\n    description: Private Network end IP address\n    format: ipv4\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Private Network name\n    maxLength: 255\n    minLength: 1\n    type: string\n  netmask:\n    description: Private Network netmask\n    format: ipv4\n    type: string\n  start-ip:\n    description: Private Network start IP address\n    format: ipv4\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreatePrivateNetwork(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-private-networks",
			Short:   "List Private Networks",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListPrivateNetworks(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-private-network id",
			Short:   "Delete a Private Network",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeletePrivateNetwork(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-private-network id",
			Short:   "Retrieve Private Network details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetPrivateNetwork(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-private-network id",
			Short:   "Update a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Private Network description\n    maxLength: 255\n    minLength: 1\n    type: string\n  end-ip:\n    description: Private Network end IP address\n    format: ipv4\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Private Network name\n    maxLength: 255\n    minLength: 1\n    type: string\n  netmask:\n    description: Private Network netmask\n    format: ipv4\n    type: string\n  start-ip:\n    description: Private Network start IP address\n    format: ipv4\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdatePrivateNetwork(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-private-network-field id field",
			Short:   "Reset Private Network field",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetPrivateNetworkField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-instance-to-private-network id",
			Short:   "Attach a Compute instance to a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\n  ip:\n    description: Static IP address lease for the corresponding network interface\n    format: ipv4\n    type: string\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachInstanceToPrivateNetwork(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-instance-from-private-network id",
			Short:   "Detach a Compute instance from a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachInstanceFromPrivateNetwork(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-private-network-instance-ip id",
			Short:   "Update the IP address of an instance attached to a managed private network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\n  ip:\n    description: Static IP address lease for the corresponding network interface\n    format: ipv4\n    type: string\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdatePrivateNetworkInstanceIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-quotas",
			Short:   "List Organization Quotas",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListQuotas(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-quota entity",
			Short:   "Retrieve Resource Quota",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetQuota(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-security-group",
			Short:   "Create a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Security Group description\n    maxLength: 255\n    minLength: 1\n    type: string\n  name:\n    description: Security Group name\n    maxLength: 255\n    minLength: 1\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSecurityGroup(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-security-groups",
			Short:   "List Security Groups",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSecurityGroups(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-security-group id",
			Short:   "Delete a Security Group",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSecurityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-security-group id",
			Short:   "Retrieve Security Group details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSecurityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "add-rule-to-security-group id",
			Short:   "Create a Security Group rule",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Security Group rule description\n    maxLength: 255\n    minLength: 1\n    type: string\n  end-port:\n    description: End port of the range\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\n  flow-direction:\n    description: Network flow direction to match\n    enum:\n    - ingress\n    - egress\n    type: string\n  icmp:\n    description: ICMP details\n    properties:\n      code:\n        format: int64\n        maximum: 254\n        minimum: 0\n        type: integer\n      type:\n        format: int64\n        maximum: 254\n        minimum: 0\n        type: integer\n    type: object\n  network:\n    description: CIDR-formatted network allowed\n    type: string\n  protocol:\n    description: Network protocol\n    enum:\n    - tcp\n    - esp\n    - icmp\n    - udp\n    - gre\n    - ah\n    - ipip\n    - icmpv6\n    type: string\n  security-group:\n    $ref: '#/components/schemas/security-group-resource'\n  start-port:\n    description: Start port of the range\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\nrequired:\n- flow-direction\n- protocol\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAddRuleToSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-rule-from-security-group id rule-id",
			Short:   "Delete a Security Group rule",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteRuleFromSecurityGroup(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "add-external-source-to-security-group id",
			Short:   "Add an external source as a member of a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  cidr:\n    description: CIDR-formatted network to add\n    type: string\nrequired:\n- cidr\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAddExternalSourceToSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-instance-to-security-group id",
			Short:   "Attach a Compute instance to a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachInstanceToSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-instance-from-security-group id",
			Short:   "Detach a Compute instance from a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachInstanceFromSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "remove-external-source-from-security-group id",
			Short:   "Remove an external source from a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  cidr:\n    description: CIDR-formatted network to remove\n    type: string\nrequired:\n- cidr\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRemoveExternalSourceFromSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-sks-cluster",
			Short:   "Create an SKS cluster",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  addons:\n    description: Cluster addons\n    items:\n      enum:\n      - exoscale-cloud-controller\n      - metrics-server\n      type: string\n    type: array\n    uniqueItems: true\n  auto-upgrade:\n    description: Enable auto upgrade of the control plane to the latest patch version\n      available\n    type: boolean\n  cni:\n    description: Cluster CNI\n    enum:\n    - calico\n    type: string\n  description:\n    description: Cluster description\n    maxLength: 255\n    minLength: 1\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  level:\n    description: Cluster service level\n    enum:\n    - starter\n    - pro\n    type: string\n  name:\n    description: Cluster name\n    maxLength: 255\n    minLength: 1\n    type: string\n  oidc:\n    $ref: '#/components/schemas/sks-oidc'\n  version:\n    description: Control plane Kubernetes version\n    type: string\nrequired:\n- name\n- level\n- version\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSksCluster(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-sks-clusters",
			Short:   "List SKS clusters",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSksClusters(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "generate-sks-cluster-kubeconfig id",
			Short:   "Generate a new Kubeconfig file for a SKS cluster",
			Long:    cli.Markdown("This operation returns a Kubeconfig file encoded in base64.\n## Request Schema (application/json)\n\ndescription: Kubeconfig request for a SKS cluster\nproperties:\n  groups:\n    description: List of roles. The certificate present in the Kubeconfig will have\n      these roles set in the Org field.\n    items:\n      type: string\n    type: array\n  ttl:\n    description: 'Validity in seconds of the Kubeconfig user certificate (default:\n      30 days)'\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  user:\n    description: User name in the generated Kubeconfig. The certificate present in\n      the Kubeconfig will also have this name set for the CN field.\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XGenerateSksClusterKubeconfig(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-sks-cluster-versions",
			Short:   "List available versions for SKS clusters",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSksClusterVersions(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("include-deprecated", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-sks-cluster id",
			Short:   "Delete an SKS cluster",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSksCluster(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sks-cluster id",
			Short:   "Retrieve SKS cluster details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSksCluster(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-sks-cluster id",
			Short:   "Update an SKS cluster",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  auto-upgrade:\n    description: Enable auto upgrade of the control plane to the latest patch version\n      available\n    type: boolean\n  description:\n    description: Cluster description\n    maxLength: 255\n    minLength: 1\n    nullable: true\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Cluster name\n    maxLength: 255\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateSksCluster(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sks-cluster-authority-cert id authority",
			Short:   "Get the certificate for a SKS cluster authority",
			Long:    cli.Markdown("This operation returns the certificate for the given SKS cluster authority encoded in base64."),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSksClusterAuthorityCert(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-sks-nodepool id",
			Short:   "Create a new SKS Nodepool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  addons:\n    description: Nodepool addons\n    items:\n      enum:\n      - linbit\n      type: string\n    type: array\n    uniqueItems: true\n  anti-affinity-groups:\n    description: Nodepool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Nodepool description\n    maxLength: 255\n    minLength: 1\n    type: string\n  disk-size:\n    description: Nodepool instances disk size in GB\n    format: int64\n    maximum: 50000\n    minimum: 20\n    type: integer\n  instance-prefix:\n    description: 'Prefix to apply to instances names (default: pool)'\n    maxLength: 30\n    minLength: 1\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Nodepool name\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Nodepool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    type: array\n    uniqueItems: true\n  security-groups:\n    description: Nodepool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  size:\n    description: Number of instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  taints:\n    $ref: '#/components/schemas/sks-nodepool-taints'\nrequired:\n- name\n- size\n- disk-size\n- instance-type\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSksNodepool(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-sks-nodepool id sks-nodepool-id",
			Short:   "Delete an SKS Nodepool",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSksNodepool(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sks-nodepool id sks-nodepool-id",
			Short:   "Retrieve SKS Nodepool details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSksNodepool(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-sks-nodepool id sks-nodepool-id",
			Short:   "Update an SKS Nodepool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Nodepool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Nodepool description\n    maxLength: 255\n    minLength: 1\n    nullable: true\n    type: string\n  disk-size:\n    description: Nodepool instances disk size in GB\n    format: int64\n    maximum: 50000\n    minimum: 20\n    type: integer\n  instance-prefix:\n    description: 'Prefix to apply to managed instances names (default: pool)'\n    maxLength: 30\n    minLength: 1\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Nodepool name\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Nodepool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    type: array\n    uniqueItems: true\n  security-groups:\n    description: Nodepool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  taints:\n    $ref: '#/components/schemas/sks-nodepool-taints'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateSksNodepool(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-sks-nodepool-field id sks-nodepool-id field",
			Short:   "Reset an SKS Nodepool field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(3),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetSksNodepoolField(args[0], args[1], args[2], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "evict-sks-nodepool-members id sks-nodepool-id",
			Short:   "Evict Nodepool members",
			Long:    cli.Markdown("This operation evicts the specified Compute instances member from the Nodepool, shrinking it to `&lt;current nodepool size&gt; - &lt;# evicted members&gt;`.\n## Request Schema (application/json)\n\nproperties:\n  instances:\n    items:\n      format: uuid\n      type: string\n    type: array\n    uniqueItems: true\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XEvictSksNodepoolMembers(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "scale-sks-nodepool id sks-nodepool-id",
			Short:   "Scale a SKS Nodepool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  size:\n    description: Number of instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\nrequired:\n- size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XScaleSksNodepool(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "rotate-sks-ccm-credentials id",
			Short:   "Rotate Exoscale CCM credentials",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRotateSksCcmCredentials(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "upgrade-sks-cluster id",
			Short:   "Upgrade an SKS cluster",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  version:\n    description: Control plane Kubernetes version\n    type: string\nrequired:\n- version\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpgradeSksCluster(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "upgrade-sks-cluster-service-level id",
			Short:   "Upgrade a SKS cluster to pro",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpgradeSksClusterServiceLevel(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-sks-cluster-field id field",
			Short:   "Reset an SKS cluster field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetSksClusterField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-snapshots",
			Short:   "List Snapshots",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSnapshots(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-snapshot id",
			Short:   "Delete a Snapshot",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSnapshot(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-snapshot id",
			Short:   "Retrieve Snapshot details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSnapshot(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "export-snapshot id",
			Short:   "Export a Snapshot",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XExportSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "promote-snapshot-to-template id",
			Short:   "Promote a Snapshot to a Template",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  default-user:\n    description: Template default user\n    maxLength: 255\n    minLength: 1\n    type: string\n  name:\n    description: Template name\n    maxLength: 255\n    minLength: 1\n    type: string\n  password-enabled:\n    description: Enable password-based login in the template\n    type: boolean\n  ssh-key-enabled:\n    description: Enable SSH key-based login in the template\n    type: boolean\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XPromoteSnapshotToTemplate(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sos-presigned-url bucket",
			Short:   "Retrieve Presigned Download URL for SOS object",
			Long:    cli.Markdown("Generates Presigned Download URL for SOS object"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSosPresignedUrl(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("key", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-ssh-keys",
			Short:   "List SSH keys",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSshKeys(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "register-ssh-key",
			Short:   "Import SSH key",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  name:\n    description: Private Network name\n    type: string\n  public-key:\n    description: Public key value\n    type: string\nrequired:\n- name\n- public-key\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRegisterSshKey(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-ssh-key name",
			Short:   "Delete a SSH key",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSshKey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-ssh-key name",
			Short:   "Retrieve SSH key details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSshKey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-templates",
			Short:   "List Templates",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListTemplates(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("visibility", "", "")
		cmd.Flags().String("family", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "register-template",
			Short:   "Register a Template",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  boot-mode:\n    description: 'Boot mode (default: legacy)'\n    enum:\n    - legacy\n    - uefi\n    type: string\n  checksum:\n    description: Template MD5 checksum\n    minLength: 1\n    type: string\n  default-user:\n    description: Template default user\n    maxLength: 255\n    minLength: 1\n    type: string\n  description:\n    description: Template description\n    maxLength: 255\n    minLength: 1\n    type: string\n  name:\n    description: Template name\n    maxLength: 255\n    minLength: 1\n    type: string\n  password-enabled:\n    description: Enable password-based login\n    type: boolean\n  size:\n    description: Template size\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  ssh-key-enabled:\n    description: Enable SSH key-based login\n    type: boolean\n  url:\n    description: Template source URL\n    minLength: 1\n    type: string\nrequired:\n- name\n- url\n- checksum\n- ssh-key-enabled\n- password-enabled\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRegisterTemplate(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "copy-template id",
			Short:   "Copy a Template from a zone to another",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  target-zone:\n    $ref: '#/components/schemas/zone'\nrequired:\n- target-zone\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCopyTemplate(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-template id",
			Short:   "Delete a Template",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteTemplate(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-template id",
			Short:   "Retrieve Template details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetTemplate(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-template id",
			Short:   "Update template attributes",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Template Description\n    maxLength: 255\n    minLength: 1\n    type: string\n  name:\n    description: Template name\n    maxLength: 255\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateTemplate(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-zones",
			Short:   "List Zones",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListZones(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

}
