/*
 * Copyright (C) 2021 Kim Woelders
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/* *INDENT-OFF* */

#ifdef DEFINE_ATOM_MISC

   /* Misc atoms */
   DEFINE_ATOM_MISC(UTF8_STRING)
   DEFINE_ATOM_MISC(MANAGER)

   /* Root background atoms */
   DEFINE_ATOM_MISC(_XROOTPMAP_ID)
   DEFINE_ATOM_MISC(_XROOTCOLOR_PIXEL)

   /* E16 atoms */
   DEFINE_ATOM_MISC(ENLIGHTENMENT_VERSION)

   DEFINE_ATOM_MISC(ENLIGHTENMENT_COMMS)
   DEFINE_ATOM_MISC(ENL_MSG)

   DEFINE_ATOM_MISC(ENL_INTERNAL_AREA_DATA)
   DEFINE_ATOM_MISC(ENL_INTERNAL_DESK_DATA)
   DEFINE_ATOM_MISC(ENL_WIN_DATA)
   DEFINE_ATOM_MISC(ENL_WIN_BORDER)
#endif /* DEFINE_ATOM_MISC */

#ifdef DEFINE_ATOM_ICCCM
#ifndef notdef_ATOM_ICCCM
#define notdef_ATOM_ICCCM(a)
#endif

   DEFINE_ATOM_ICCCM(WM_STATE)
   DEFINE_ATOM_ICCCM(WM_WINDOW_ROLE)
   DEFINE_ATOM_ICCCM(WM_CLIENT_LEADER)
   DEFINE_ATOM_ICCCM(WM_COLORMAP_WINDOWS)
   DEFINE_ATOM_ICCCM(WM_CHANGE_STATE)
   DEFINE_ATOM_ICCCM(WM_PROTOCOLS)
   DEFINE_ATOM_ICCCM(WM_DELETE_WINDOW)
   DEFINE_ATOM_ICCCM(WM_TAKE_FOCUS)

   notdef_ATOM_ICCCM(WM_SAVE_YOURSELF)			/* Not used */

   /* These exist as defines but we treat them like the rest anyway */
   DEFINE_ATOM_ICCCM(WM_COMMAND)
   DEFINE_ATOM_ICCCM(WM_HINTS)
   DEFINE_ATOM_ICCCM(WM_CLIENT_MACHINE)
   DEFINE_ATOM_ICCCM(WM_ICON_NAME)
   DEFINE_ATOM_ICCCM(WM_NAME)
   DEFINE_ATOM_ICCCM(WM_NORMAL_HINTS)
   DEFINE_ATOM_ICCCM(WM_CLASS)
   DEFINE_ATOM_ICCCM(WM_TRANSIENT_FOR)
#endif /* DEFINE_ATOM_ICCCM */

#ifdef DEFINE_ATOM_NETWM
#ifndef notdef_ATOM_NETWM
#define notdef_ATOM_NETWM(a)
#endif

   /* Window manager info */
   DEFINE_ATOM_NETWM(_NET_SUPPORTED)
   DEFINE_ATOM_NETWM(_NET_SUPPORTING_WM_CHECK)

   /* Desktop status/requests */
   DEFINE_ATOM_NETWM(_NET_NUMBER_OF_DESKTOPS)
   DEFINE_ATOM_NETWM(_NET_VIRTUAL_ROOTS)
   DEFINE_ATOM_NETWM(_NET_DESKTOP_GEOMETRY)
   DEFINE_ATOM_NETWM(_NET_DESKTOP_NAMES)
   DEFINE_ATOM_NETWM(_NET_DESKTOP_VIEWPORT)
   DEFINE_ATOM_NETWM(_NET_WORKAREA)
   DEFINE_ATOM_NETWM(_NET_CURRENT_DESKTOP)
   DEFINE_ATOM_NETWM(_NET_SHOWING_DESKTOP)

   DEFINE_ATOM_NETWM(_NET_ACTIVE_WINDOW)
   DEFINE_ATOM_NETWM(_NET_CLIENT_LIST)
   DEFINE_ATOM_NETWM(_NET_CLIENT_LIST_STACKING)

   /* Client window props/client messages */
   DEFINE_ATOM_NETWM(_NET_WM_NAME)
   DEFINE_ATOM_NETWM(_NET_WM_VISIBLE_NAME)
   DEFINE_ATOM_NETWM(_NET_WM_ICON_NAME)
   DEFINE_ATOM_NETWM(_NET_WM_VISIBLE_ICON_NAME)

   DEFINE_ATOM_NETWM(_NET_WM_DESKTOP)

   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_DESKTOP)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_DOCK)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_TOOLBAR)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_MENU)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_UTILITY)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_SPLASH)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_DIALOG)
   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_TYPE_NORMAL)

   DEFINE_ATOM_NETWM(_NET_WM_STATE)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_MODAL)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_STICKY)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_MAXIMIZED_VERT)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_MAXIMIZED_HORZ)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_SHADED)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_SKIP_TASKBAR)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_SKIP_PAGER)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_HIDDEN)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_FULLSCREEN)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_ABOVE)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_BELOW)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_DEMANDS_ATTENTION)
   DEFINE_ATOM_NETWM(_NET_WM_STATE_FOCUSED)

   DEFINE_ATOM_NETWM(_NET_WM_ALLOWED_ACTIONS)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_MOVE)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_RESIZE)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_MINIMIZE)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_SHADE)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_STICK)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_MAXIMIZE_HORZ)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_MAXIMIZE_VERT)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_FULLSCREEN)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_CHANGE_DESKTOP)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_CLOSE)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_ABOVE)
   DEFINE_ATOM_NETWM(_NET_WM_ACTION_BELOW)

   DEFINE_ATOM_NETWM(_NET_WM_STRUT)
   DEFINE_ATOM_NETWM(_NET_WM_STRUT_PARTIAL)

   notdef_ATOM_NETWM(_NET_WM_ICON_GEOMETRY)		/* Not used */
   DEFINE_ATOM_NETWM(_NET_WM_ICON)

   DEFINE_ATOM_NETWM(_NET_WM_PID)

   notdef_ATOM_NETWM(_NET_WM_HANDLED_ICONS)		/* Not used */

   DEFINE_ATOM_NETWM(_NET_WM_USER_TIME)
   DEFINE_ATOM_NETWM(_NET_WM_USER_TIME_WINDOW)

   DEFINE_ATOM_NETWM(_NET_FRAME_EXTENTS)

   notdef_ATOM_NETWM(_NET_WM_OPAQUE_REGION)
   notdef_ATOM_NETWM(_NET_WM_BYPASS_COMPOSITOR)

   DEFINE_ATOM_NETWM(_NET_WM_WINDOW_OPACITY)

   /* Window Manager Protocols */
   notdef_ATOM_NETWM(_NET_WM_PING)			/* Not used */

   DEFINE_ATOM_NETWM(_NET_WM_SYNC_REQUEST)
   DEFINE_ATOM_NETWM(_NET_WM_SYNC_REQUEST_COUNTER)

   /* Misc window ops */
   DEFINE_ATOM_NETWM(_NET_CLOSE_WINDOW)
   DEFINE_ATOM_NETWM(_NET_MOVERESIZE_WINDOW)
   DEFINE_ATOM_NETWM(_NET_WM_MOVERESIZE)
   DEFINE_ATOM_NETWM(_NET_RESTACK_WINDOW)

   notdef_ATOM_NETWM(_NET_REQUEST_FRAME_EXTENTS)	/* Not implemented */

   /* Startup notification */
   DEFINE_ATOM_NETWM(_NET_STARTUP_ID)
   DEFINE_ATOM_NETWM(_NET_STARTUP_INFO_BEGIN)
   DEFINE_ATOM_NETWM(_NET_STARTUP_INFO)
#endif /* DEFINE_ATOM_NETWM */

/* *INDENT-ON* */
