# vim:sw=4 sta showmatch

# A poor imitation of SGMLSpm / SGMLSpl using PerlSAX.
# [steve@ggi-project.org]

use strict;

package XML::SGMLSpl::Element;

sub new {
    my ($class, $gi, $attrs, $parent) = @_;
    my $self = [ $gi, $parent, $attrs, {} ];
    return bless($self, $class);
}

sub name 	{ $_[0]->[0] }
sub parent 	{ $_[0]->[1] }
sub attributes 	{ $_[0]->[2] }
sub attribute 	{ $_[0]->[2]->{$_[1]} }
sub ext 	{ $_[0]->[3] }

sub within {
    my ($self,$name) = @_;
    for ($self = $self->parent; $self; $self = $self->parent) {
	return $self if ($self->name eq $name);
    }

    return undef;
}

sub in {
    my ($self,$name) = @_;
    if ($self->parent && $self->parent->name eq $name) {
	return $self->parent;
    } else {
	return undef;
    }
}
				
package XML::SGMLSpl;

# uses PerlSAX interface

sub new {
    my($class) = @_;
    my $self = { 'start_element'=>{}, 'end_element'=>{} };
    return bless($self, $class);
}

sub set_document_locator {
    my ($self, $arg) = @_;
    $self->{Locator} = $arg->{Locator};
}

sub start_document {
    my ($self) = @_;
    &{($self->{start_document} || sub{})}($self);
}

sub end_document {
    my ($self) = @_;
    &{($self->{end_document} || sub{})}($self);
}


sub start_element {
    my ($self, $arg) = @_;
    my $elem = new XML::SGMLSpl::Element(
	$arg->{'Name'}, 
	$arg->{'Attributes'},
	$self->{'_current_element'});
    $self->{'_current_element'} = $elem;

    &{($self->{'start_element'}->{$arg->{'Name'}} || 
       $self->{'start_element'}->{''} || sub{})}($elem, $self);
}

sub end_element {
    my ($self, $arg) = @_;
    my $elem = $self->{'_current_element'};

    &{($self->{'end_element'}->{$arg->{'Name'}} ||
       $self->{'end_element'}->{''} || sub{})}($elem, $self);

    # unlink after
    $self->{'_current_element'} = $elem->parent;
}

sub characters {
    my ($self, $arg) = @_;

    &{($self->{'characters'} || sub{})}
	($arg->{'Data'}, $self->{'_current_element'}, $self);
}

sub processing_instruction {
    my ($self, $arg) = @_;
    &{($self->{'processing_instruction'} || sub{})}
	($arg->{'Target'}, $arg->{'Data'}, $self->{'_current_element'}, $self);
}

sub ignorable_whitespace {
    my ($self, $arg) = @_;

    &{($self->{'ignorable_whitespace'} || sub{})}
	($arg->{'Data'}, $self->{'_current_element'}, $self);
}

sub comment {
    my ($self, $arg) = @_;
    &{($self->{'comment'} || sub{})}
	($arg->{'Data'}, $self->{'_current_element'}, $self);
}

1;

