/* gridframe.c generated by valac 0.42.3, the Vala compiler
 * generated from gridframe.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A container that guarantees that the internal allocated space is a fixed*/
/* multiple of an integer. This is a fairly literal translation of the LGPLv2+*/
/* original by Callum McKenzie, itself based on GtkFrame and GtkAspectFrame.*/


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define GAMES_TYPE_GRID_FRAME (games_grid_frame_get_type ())
#define GAMES_GRID_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GRID_FRAME, GamesGridFrame))
#define GAMES_GRID_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GRID_FRAME, GamesGridFrameClass))
#define GAMES_IS_GRID_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GRID_FRAME))
#define GAMES_IS_GRID_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GRID_FRAME))
#define GAMES_GRID_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GRID_FRAME, GamesGridFrameClass))

typedef struct _GamesGridFrame GamesGridFrame;
typedef struct _GamesGridFrameClass GamesGridFrameClass;
typedef struct _GamesGridFramePrivate GamesGridFramePrivate;
enum  {
	GAMES_GRID_FRAME_0_PROPERTY,
	GAMES_GRID_FRAME_XPADDING_PROPERTY,
	GAMES_GRID_FRAME_YPADDING_PROPERTY,
	GAMES_GRID_FRAME_WIDTH_PROPERTY,
	GAMES_GRID_FRAME_HEIGHT_PROPERTY,
	GAMES_GRID_FRAME_XALIGN_PROPERTY,
	GAMES_GRID_FRAME_YALIGN_PROPERTY,
	GAMES_GRID_FRAME_NUM_PROPERTIES
};
static GParamSpec* games_grid_frame_properties[GAMES_GRID_FRAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesGridFrame {
	GtkBin parent_instance;
	GamesGridFramePrivate * priv;
};

struct _GamesGridFrameClass {
	GtkBinClass parent_class;
};

struct _GamesGridFramePrivate {
	gint _xpadding;
	gint _ypadding;
	gint _xmult;
	gint _ymult;
	gfloat _xalign;
	gfloat _yalign;
	GtkAllocation old_allocation;
};


static gint GamesGridFrame_private_offset;
static gpointer games_grid_frame_parent_class = NULL;

GType games_grid_frame_get_type (void) G_GNUC_CONST;
GamesGridFrame* games_grid_frame_new (gint width,
                                      gint height);
GamesGridFrame* games_grid_frame_construct (GType object_type,
                                            gint width,
                                            gint height);
void games_grid_frame_set (GamesGridFrame* self,
                           gint width,
                           gint height);
void games_grid_frame_set_width (GamesGridFrame* self,
                                 gint value);
void games_grid_frame_set_height (GamesGridFrame* self,
                                  gint value);
void games_grid_frame_set_padding (GamesGridFrame* self,
                                   gint xpadding,
                                   gint ypadding);
void games_grid_frame_set_xpadding (GamesGridFrame* self,
                                    gint value);
void games_grid_frame_set_ypadding (GamesGridFrame* self,
                                    gint value);
void games_grid_frame_set_alignment (GamesGridFrame* self,
                                     gfloat xalign,
                                     gfloat yalign);
void games_grid_frame_set_xalign (GamesGridFrame* self,
                                  gfloat value);
void games_grid_frame_set_yalign (GamesGridFrame* self,
                                  gfloat value);
static void games_grid_frame_real_size_allocate (GtkWidget* base,
                                          GtkAllocation* allocation);
gint games_grid_frame_get_xpadding (GamesGridFrame* self);
gint games_grid_frame_get_ypadding (GamesGridFrame* self);
gint games_grid_frame_get_width (GamesGridFrame* self);
gint games_grid_frame_get_height (GamesGridFrame* self);
gfloat games_grid_frame_get_xalign (GamesGridFrame* self);
gfloat games_grid_frame_get_yalign (GamesGridFrame* self);
static void games_grid_frame_finalize (GObject * obj);
static void _vala_games_grid_frame_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_games_grid_frame_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);


static inline gpointer
games_grid_frame_get_instance_private (GamesGridFrame* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGridFrame_private_offset);
}


GamesGridFrame*
games_grid_frame_construct (GType object_type,
                            gint width,
                            gint height)
{
	GamesGridFrame * self = NULL;
#line 117 "gridframe.vala"
	self = (GamesGridFrame*) g_object_new (object_type, "width", width, "height", height, NULL);
#line 115 "gridframe.vala"
	return self;
#line 147 "gridframe.c"
}


GamesGridFrame*
games_grid_frame_new (gint width,
                      gint height)
{
#line 115 "gridframe.vala"
	return games_grid_frame_construct (GAMES_TYPE_GRID_FRAME, width, height);
#line 157 "gridframe.c"
}


void
games_grid_frame_set (GamesGridFrame* self,
                      gint width,
                      gint height)
{
#line 120 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 122 "gridframe.vala"
	games_grid_frame_set_width (self, width);
#line 123 "gridframe.vala"
	games_grid_frame_set_height (self, height);
#line 172 "gridframe.c"
}


void
games_grid_frame_set_padding (GamesGridFrame* self,
                              gint xpadding,
                              gint ypadding)
{
#line 126 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 128 "gridframe.vala"
	games_grid_frame_set_xpadding (self, xpadding);
#line 129 "gridframe.vala"
	games_grid_frame_set_ypadding (self, ypadding);
#line 187 "gridframe.c"
}


void
games_grid_frame_set_alignment (GamesGridFrame* self,
                                gfloat xalign,
                                gfloat yalign)
{
#line 132 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 134 "gridframe.vala"
	games_grid_frame_set_xalign (self, xalign);
#line 135 "gridframe.vala"
	games_grid_frame_set_yalign (self, yalign);
#line 202 "gridframe.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 161 "gridframe.vala"
	return self ? g_object_ref (self) : NULL;
#line 211 "gridframe.c"
}


static void
games_grid_frame_real_size_allocate (GtkWidget* base,
                                     GtkAllocation* allocation)
{
	GamesGridFrame * self;
	GtkAllocation _tmp0_;
	gint xsize = 0;
	GtkAllocation _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint ysize = 0;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint size = 0;
	gint _tmp9_;
	gint _tmp10_;
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp11_ = {0};
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GtkAllocation _tmp18_;
	gint _tmp19_;
	GtkAllocation _tmp20_;
	gint _tmp21_;
	gfloat _tmp22_;
	GtkAllocation _tmp23_;
	gint _tmp24_;
	GtkAllocation _tmp25_;
	gint _tmp26_;
	GtkAllocation _tmp27_;
	gint _tmp28_;
	gfloat _tmp29_;
	GtkAllocation _tmp30_;
	gint _tmp31_;
	gboolean _tmp32_ = FALSE;
	GtkWidget* child = NULL;
	GtkWidget* _tmp55_;
	GtkWidget* _tmp56_;
	gboolean _tmp57_ = FALSE;
	GtkWidget* _tmp58_;
	GtkAllocation _tmp62_;
#line 138 "gridframe.vala"
	self = (GamesGridFrame*) base;
#line 138 "gridframe.vala"
	g_return_if_fail (allocation != NULL);
#line 140 "gridframe.vala"
	_tmp0_ = *allocation;
#line 140 "gridframe.vala"
	GTK_WIDGET_CLASS (games_grid_frame_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin), &_tmp0_);
#line 142 "gridframe.vala"
	_tmp1_ = *allocation;
#line 142 "gridframe.vala"
	_tmp2_ = _tmp1_.width;
#line 142 "gridframe.vala"
	_tmp3_ = self->priv->_xpadding;
#line 142 "gridframe.vala"
	_tmp4_ = self->priv->_xmult;
#line 142 "gridframe.vala"
	xsize = MAX (1, (_tmp2_ - _tmp3_) / _tmp4_);
#line 143 "gridframe.vala"
	_tmp5_ = *allocation;
#line 143 "gridframe.vala"
	_tmp6_ = _tmp5_.height;
#line 143 "gridframe.vala"
	_tmp7_ = self->priv->_ypadding;
#line 143 "gridframe.vala"
	_tmp8_ = self->priv->_ymult;
#line 143 "gridframe.vala"
	ysize = MAX (1, (_tmp6_ - _tmp7_) / _tmp8_);
#line 144 "gridframe.vala"
	_tmp9_ = xsize;
#line 144 "gridframe.vala"
	_tmp10_ = ysize;
#line 144 "gridframe.vala"
	size = MIN (_tmp9_, _tmp10_);
#line 146 "gridframe.vala"
	_tmp11_.x = 0;
#line 146 "gridframe.vala"
	_tmp11_.y = 0;
#line 146 "gridframe.vala"
	_tmp11_.width = 0;
#line 146 "gridframe.vala"
	_tmp11_.height = 0;
#line 146 "gridframe.vala"
	child_allocation = _tmp11_;
#line 147 "gridframe.vala"
	_tmp12_ = size;
#line 147 "gridframe.vala"
	_tmp13_ = self->priv->_xmult;
#line 147 "gridframe.vala"
	_tmp14_ = self->priv->_xpadding;
#line 147 "gridframe.vala"
	child_allocation.width = (_tmp12_ * _tmp13_) + _tmp14_;
#line 148 "gridframe.vala"
	_tmp15_ = size;
#line 148 "gridframe.vala"
	_tmp16_ = self->priv->_ymult;
#line 148 "gridframe.vala"
	_tmp17_ = self->priv->_ypadding;
#line 148 "gridframe.vala"
	child_allocation.height = (_tmp15_ * _tmp16_) + _tmp17_;
#line 149 "gridframe.vala"
	_tmp18_ = *allocation;
#line 149 "gridframe.vala"
	_tmp19_ = _tmp18_.width;
#line 149 "gridframe.vala"
	_tmp20_ = child_allocation;
#line 149 "gridframe.vala"
	_tmp21_ = _tmp20_.width;
#line 149 "gridframe.vala"
	_tmp22_ = self->priv->_xalign;
#line 149 "gridframe.vala"
	_tmp23_ = *allocation;
#line 149 "gridframe.vala"
	_tmp24_ = _tmp23_.x;
#line 149 "gridframe.vala"
	child_allocation.x = (gint) (((_tmp19_ - _tmp21_) * _tmp22_) + _tmp24_);
#line 150 "gridframe.vala"
	_tmp25_ = *allocation;
#line 150 "gridframe.vala"
	_tmp26_ = _tmp25_.height;
#line 150 "gridframe.vala"
	_tmp27_ = child_allocation;
#line 150 "gridframe.vala"
	_tmp28_ = _tmp27_.height;
#line 150 "gridframe.vala"
	_tmp29_ = self->priv->_yalign;
#line 150 "gridframe.vala"
	_tmp30_ = *allocation;
#line 150 "gridframe.vala"
	_tmp31_ = _tmp30_.y;
#line 150 "gridframe.vala"
	child_allocation.y = (gint) (((_tmp26_ - _tmp28_) * _tmp29_) + _tmp31_);
#line 152 "gridframe.vala"
	if (gtk_widget_get_mapped ((GtkWidget*) self)) {
#line 357 "gridframe.c"
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		GtkAllocation _tmp36_;
		gint _tmp37_;
		GtkAllocation _tmp38_;
		gint _tmp39_;
#line 153 "gridframe.vala"
		_tmp36_ = child_allocation;
#line 153 "gridframe.vala"
		_tmp37_ = _tmp36_.x;
#line 153 "gridframe.vala"
		_tmp38_ = self->priv->old_allocation;
#line 153 "gridframe.vala"
		_tmp39_ = _tmp38_.x;
#line 153 "gridframe.vala"
		if (_tmp37_ != _tmp39_) {
#line 153 "gridframe.vala"
			_tmp35_ = TRUE;
#line 377 "gridframe.c"
		} else {
			GtkAllocation _tmp40_;
			gint _tmp41_;
			GtkAllocation _tmp42_;
			gint _tmp43_;
#line 154 "gridframe.vala"
			_tmp40_ = child_allocation;
#line 154 "gridframe.vala"
			_tmp41_ = _tmp40_.y;
#line 154 "gridframe.vala"
			_tmp42_ = self->priv->old_allocation;
#line 154 "gridframe.vala"
			_tmp43_ = _tmp42_.y;
#line 154 "gridframe.vala"
			_tmp35_ = _tmp41_ != _tmp43_;
#line 393 "gridframe.c"
		}
#line 153 "gridframe.vala"
		if (_tmp35_) {
#line 153 "gridframe.vala"
			_tmp34_ = TRUE;
#line 399 "gridframe.c"
		} else {
			GtkAllocation _tmp44_;
			gint _tmp45_;
			GtkAllocation _tmp46_;
			gint _tmp47_;
#line 155 "gridframe.vala"
			_tmp44_ = child_allocation;
#line 155 "gridframe.vala"
			_tmp45_ = _tmp44_.width;
#line 155 "gridframe.vala"
			_tmp46_ = self->priv->old_allocation;
#line 155 "gridframe.vala"
			_tmp47_ = _tmp46_.width;
#line 155 "gridframe.vala"
			_tmp34_ = _tmp45_ != _tmp47_;
#line 415 "gridframe.c"
		}
#line 153 "gridframe.vala"
		if (_tmp34_) {
#line 153 "gridframe.vala"
			_tmp33_ = TRUE;
#line 421 "gridframe.c"
		} else {
			GtkAllocation _tmp48_;
			gint _tmp49_;
			GtkAllocation _tmp50_;
			gint _tmp51_;
#line 156 "gridframe.vala"
			_tmp48_ = child_allocation;
#line 156 "gridframe.vala"
			_tmp49_ = _tmp48_.height;
#line 156 "gridframe.vala"
			_tmp50_ = self->priv->old_allocation;
#line 156 "gridframe.vala"
			_tmp51_ = _tmp50_.height;
#line 156 "gridframe.vala"
			_tmp33_ = _tmp49_ != _tmp51_;
#line 437 "gridframe.c"
		}
#line 153 "gridframe.vala"
		_tmp32_ = _tmp33_;
#line 441 "gridframe.c"
	} else {
#line 152 "gridframe.vala"
		_tmp32_ = FALSE;
#line 445 "gridframe.c"
	}
#line 152 "gridframe.vala"
	if (_tmp32_) {
#line 449 "gridframe.c"
		GdkWindow* _tmp52_;
		GtkAllocation _tmp53_;
		GdkRectangle _tmp54_;
#line 158 "gridframe.vala"
		_tmp52_ = gtk_widget_get_window ((GtkWidget*) self);
#line 158 "gridframe.vala"
		_tmp53_ = *allocation;
#line 158 "gridframe.vala"
		_tmp54_ = _tmp53_;
#line 158 "gridframe.vala"
		gdk_window_invalidate_rect (_tmp52_, &_tmp54_, FALSE);
#line 461 "gridframe.c"
	}
#line 161 "gridframe.vala"
	_tmp55_ = gtk_bin_get_child ((GtkBin*) self);
#line 161 "gridframe.vala"
	_tmp56_ = _g_object_ref0 (_tmp55_);
#line 161 "gridframe.vala"
	child = _tmp56_;
#line 162 "gridframe.vala"
	_tmp58_ = child;
#line 162 "gridframe.vala"
	if (_tmp58_ != NULL) {
#line 473 "gridframe.c"
		GtkWidget* _tmp59_;
#line 162 "gridframe.vala"
		_tmp59_ = child;
#line 162 "gridframe.vala"
		_tmp57_ = gtk_widget_get_visible (_tmp59_);
#line 479 "gridframe.c"
	} else {
#line 162 "gridframe.vala"
		_tmp57_ = FALSE;
#line 483 "gridframe.c"
	}
#line 162 "gridframe.vala"
	if (_tmp57_) {
#line 487 "gridframe.c"
		GtkWidget* _tmp60_;
		GtkAllocation _tmp61_;
#line 163 "gridframe.vala"
		_tmp60_ = child;
#line 163 "gridframe.vala"
		_tmp61_ = child_allocation;
#line 163 "gridframe.vala"
		gtk_widget_size_allocate (_tmp60_, &_tmp61_);
#line 496 "gridframe.c"
	}
#line 165 "gridframe.vala"
	_tmp62_ = child_allocation;
#line 165 "gridframe.vala"
	self->priv->old_allocation = _tmp62_;
#line 138 "gridframe.vala"
	_g_object_unref0 (child);
#line 504 "gridframe.c"
}


gint
games_grid_frame_get_xpadding (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
#line 32 "gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 32 "gridframe.vala"
	_tmp0_ = self->priv->_xpadding;
#line 32 "gridframe.vala"
	result = _tmp0_;
#line 32 "gridframe.vala"
	return result;
#line 521 "gridframe.c"
}


void
games_grid_frame_set_xpadding (GamesGridFrame* self,
                               gint value)
{
#line 34 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 36 "gridframe.vala"
	if (value >= 0) {
#line 38 "gridframe.vala"
		self->priv->_xpadding = value;
#line 39 "gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 537 "gridframe.c"
	}
#line 34 "gridframe.vala"
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_XPADDING_PROPERTY]);
#line 541 "gridframe.c"
}


gint
games_grid_frame_get_ypadding (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
#line 47 "gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 47 "gridframe.vala"
	_tmp0_ = self->priv->_ypadding;
#line 47 "gridframe.vala"
	result = _tmp0_;
#line 47 "gridframe.vala"
	return result;
#line 558 "gridframe.c"
}


void
games_grid_frame_set_ypadding (GamesGridFrame* self,
                               gint value)
{
#line 49 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 51 "gridframe.vala"
	if (value >= 0) {
#line 53 "gridframe.vala"
		self->priv->_ypadding = value;
#line 54 "gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 574 "gridframe.c"
	}
#line 49 "gridframe.vala"
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_YPADDING_PROPERTY]);
#line 578 "gridframe.c"
}


gint
games_grid_frame_get_width (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
#line 62 "gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "gridframe.vala"
	_tmp0_ = self->priv->_xmult;
#line 62 "gridframe.vala"
	result = _tmp0_;
#line 62 "gridframe.vala"
	return result;
#line 595 "gridframe.c"
}


void
games_grid_frame_set_width (GamesGridFrame* self,
                            gint value)
{
#line 64 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 66 "gridframe.vala"
	if (value > 0) {
#line 68 "gridframe.vala"
		self->priv->_xmult = value;
#line 69 "gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 611 "gridframe.c"
	}
#line 64 "gridframe.vala"
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_WIDTH_PROPERTY]);
#line 615 "gridframe.c"
}


gint
games_grid_frame_get_height (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
#line 77 "gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 77 "gridframe.vala"
	_tmp0_ = self->priv->_ymult;
#line 77 "gridframe.vala"
	result = _tmp0_;
#line 77 "gridframe.vala"
	return result;
#line 632 "gridframe.c"
}


void
games_grid_frame_set_height (GamesGridFrame* self,
                             gint value)
{
#line 79 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 81 "gridframe.vala"
	if (value > 0) {
#line 83 "gridframe.vala"
		self->priv->_ymult = value;
#line 84 "gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 648 "gridframe.c"
	}
#line 79 "gridframe.vala"
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_HEIGHT_PROPERTY]);
#line 652 "gridframe.c"
}


gfloat
games_grid_frame_get_xalign (GamesGridFrame* self)
{
	gfloat result;
	gfloat _tmp0_;
#line 92 "gridframe.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 92 "gridframe.vala"
	_tmp0_ = self->priv->_xalign;
#line 92 "gridframe.vala"
	result = _tmp0_;
#line 92 "gridframe.vala"
	return result;
#line 669 "gridframe.c"
}


void
games_grid_frame_set_xalign (GamesGridFrame* self,
                             gfloat value)
{
#line 94 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 96 "gridframe.vala"
	self->priv->_xalign = CLAMP (value, 0.0f, 1.0f);
#line 97 "gridframe.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 94 "gridframe.vala"
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_XALIGN_PROPERTY]);
#line 685 "gridframe.c"
}


gfloat
games_grid_frame_get_yalign (GamesGridFrame* self)
{
	gfloat result;
	gfloat _tmp0_;
#line 104 "gridframe.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 104 "gridframe.vala"
	_tmp0_ = self->priv->_yalign;
#line 104 "gridframe.vala"
	result = _tmp0_;
#line 104 "gridframe.vala"
	return result;
#line 702 "gridframe.c"
}


void
games_grid_frame_set_yalign (GamesGridFrame* self,
                             gfloat value)
{
#line 106 "gridframe.vala"
	g_return_if_fail (self != NULL);
#line 108 "gridframe.vala"
	self->priv->_yalign = CLAMP (value, 0.0f, 1.0f);
#line 109 "gridframe.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 106 "gridframe.vala"
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_YALIGN_PROPERTY]);
#line 718 "gridframe.c"
}


static void
games_grid_frame_class_init (GamesGridFrameClass * klass)
{
#line 27 "gridframe.vala"
	games_grid_frame_parent_class = g_type_class_peek_parent (klass);
#line 27 "gridframe.vala"
	g_type_class_adjust_private_offset (klass, &GamesGridFrame_private_offset);
#line 27 "gridframe.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) games_grid_frame_real_size_allocate;
#line 27 "gridframe.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_games_grid_frame_get_property;
#line 27 "gridframe.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_games_grid_frame_set_property;
#line 27 "gridframe.vala"
	G_OBJECT_CLASS (klass)->finalize = games_grid_frame_finalize;
#line 27 "gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XPADDING_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_XPADDING_PROPERTY] = g_param_spec_int ("xpadding", "xpadding", "xpadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YPADDING_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_YPADDING_PROPERTY] = g_param_spec_int ("ypadding", "ypadding", "ypadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_WIDTH_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_HEIGHT_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XALIGN_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_XALIGN_PROPERTY] = g_param_spec_float ("xalign", "xalign", "xalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YALIGN_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_YALIGN_PROPERTY] = g_param_spec_float ("yalign", "yalign", "yalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 749 "gridframe.c"
}


static void
games_grid_frame_instance_init (GamesGridFrame * self)
{
#line 27 "gridframe.vala"
	self->priv = games_grid_frame_get_instance_private (self);
#line 29 "gridframe.vala"
	self->priv->_xpadding = 0;
#line 44 "gridframe.vala"
	self->priv->_ypadding = 0;
#line 59 "gridframe.vala"
	self->priv->_xmult = 1;
#line 74 "gridframe.vala"
	self->priv->_ymult = 1;
#line 89 "gridframe.vala"
	self->priv->_xalign = 0.5f;
#line 101 "gridframe.vala"
	self->priv->_yalign = 0.5f;
#line 770 "gridframe.c"
}


static void
games_grid_frame_finalize (GObject * obj)
{
	GamesGridFrame * self;
#line 27 "gridframe.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
#line 27 "gridframe.vala"
	G_OBJECT_CLASS (games_grid_frame_parent_class)->finalize (obj);
#line 782 "gridframe.c"
}


GType
games_grid_frame_get_type (void)
{
	static volatile gsize games_grid_frame_type_id__volatile = 0;
	if (g_once_init_enter (&games_grid_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesGridFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_grid_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGridFrame), 0, (GInstanceInitFunc) games_grid_frame_instance_init, NULL };
		GType games_grid_frame_type_id;
		games_grid_frame_type_id = g_type_register_static (gtk_bin_get_type (), "GamesGridFrame", &g_define_type_info, 0);
		GamesGridFrame_private_offset = g_type_add_instance_private (games_grid_frame_type_id, sizeof (GamesGridFramePrivate));
		g_once_init_leave (&games_grid_frame_type_id__volatile, games_grid_frame_type_id);
	}
	return games_grid_frame_type_id__volatile;
}


static void
_vala_games_grid_frame_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
#line 27 "gridframe.vala"
	switch (property_id) {
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_XPADDING_PROPERTY:
#line 27 "gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_xpadding (self));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_YPADDING_PROPERTY:
#line 27 "gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_ypadding (self));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_WIDTH_PROPERTY:
#line 27 "gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_width (self));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_HEIGHT_PROPERTY:
#line 27 "gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_height (self));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_XALIGN_PROPERTY:
#line 27 "gridframe.vala"
		g_value_set_float (value, games_grid_frame_get_xalign (self));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_YALIGN_PROPERTY:
#line 27 "gridframe.vala"
		g_value_set_float (value, games_grid_frame_get_yalign (self));
#line 27 "gridframe.vala"
		break;
#line 847 "gridframe.c"
		default:
#line 27 "gridframe.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "gridframe.vala"
		break;
#line 853 "gridframe.c"
	}
}


static void
_vala_games_grid_frame_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
#line 27 "gridframe.vala"
	switch (property_id) {
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_XPADDING_PROPERTY:
#line 27 "gridframe.vala"
		games_grid_frame_set_xpadding (self, g_value_get_int (value));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_YPADDING_PROPERTY:
#line 27 "gridframe.vala"
		games_grid_frame_set_ypadding (self, g_value_get_int (value));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_WIDTH_PROPERTY:
#line 27 "gridframe.vala"
		games_grid_frame_set_width (self, g_value_get_int (value));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_HEIGHT_PROPERTY:
#line 27 "gridframe.vala"
		games_grid_frame_set_height (self, g_value_get_int (value));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_XALIGN_PROPERTY:
#line 27 "gridframe.vala"
		games_grid_frame_set_xalign (self, g_value_get_float (value));
#line 27 "gridframe.vala"
		break;
#line 27 "gridframe.vala"
		case GAMES_GRID_FRAME_YALIGN_PROPERTY:
#line 27 "gridframe.vala"
		games_grid_frame_set_yalign (self, g_value_get_float (value));
#line 27 "gridframe.vala"
		break;
#line 904 "gridframe.c"
		default:
#line 27 "gridframe.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "gridframe.vala"
		break;
#line 910 "gridframe.c"
	}
}



