#include "audioaiassistantsetting.h"
#include "private/eaiexecutor.h"
#include "audiowizard/gui/iatwidget.h"
#include <dconfigmanager.h>

#include <QSettings>
#include <QApplication>
#include <QThread>
#include <QStandardPaths>
#include <QFileInfo>
#include <QDir>

UOSAI_USE_NAMESPACE

AudioAiassistantSetting::AudioAiassistantSetting(QObject *parent) : QObject(parent)
{
    Q_ASSERT(QThread::currentThread() == qApp->thread());
}

AudioAiassistantSetting *AudioAiassistantSetting::instance()
{
    static AudioAiassistantSetting set;
    return &set;
}

void AudioAiassistantSetting::setTTSEnable(bool enable)
{
    DConfigManager::instance()->setValue(TTS_GROUP, "enable", enable);
}

bool AudioAiassistantSetting::getTTSEnable()
{
    if(!EAiExec()->isAudioOutputAvailable()) {
        qWarning() << "microphone is not found";
        return false;
    }

    return DConfigManager::instance()->value(TTS_GROUP, "enable", true).toBool();
}

void AudioAiassistantSetting::setEnableWindow(bool enable)
{
    DConfigManager::instance()->setValue(TTS_GROUP, "enableWindow", enable);
}

bool AudioAiassistantSetting::getEnableWindow()
{
    return DConfigManager::instance()->value(TTS_GROUP, "enableWindow", true).toBool();
}

void AudioAiassistantSetting::setIatEnable(bool on)
{
    DConfigManager::instance()->setValue(IAT_GROUP, "enable", on);
}

bool AudioAiassistantSetting::getIatEnable()
{
    if (IatWidget::hasRecorder()) {
        return DConfigManager::instance()->value(IAT_GROUP, "enable", true).toBool();
    }

    return false;
}

void AudioAiassistantSetting::setIatLanguage(QString language)
{
    DConfigManager::instance()->setValue(IAT_GROUP, "language", language);
}

QString AudioAiassistantSetting::getIatLanguage()
{
    QString defaultv = "zh_cn";
    return DConfigManager::instance()->value(IAT_GROUP, "language", defaultv).toString();
}

bool AudioAiassistantSetting::setEos(int eos)
{
    if(eos < 0 || eos > 10000)
    {
        return false;
    }

    DConfigManager::instance()->setValue(IAT_GROUP, "eos", eos);
    return true;
}

int  AudioAiassistantSetting::getEos()
{
    int defaultv = 10000;
    return DConfigManager::instance()->value(IAT_GROUP, "eos", defaultv).toInt();
}

bool AudioAiassistantSetting::setBos(int bos)
{
    if(bos < 0 || bos > 10000)
    {
        return false;
    }

    DConfigManager::instance()->setValue(IAT_GROUP, "bos", bos);
    return true;
}

int  AudioAiassistantSetting::getBos()
{
    int defaultv = 10000;
    return DConfigManager::instance()->value(IAT_GROUP, "bos", defaultv).toInt();
}

bool  AudioAiassistantSetting::setBosWarning(int warningTime)
{
    if(warningTime < 0 || warningTime > 10000)
    {
        return false;
    }

    DConfigManager::instance()->setValue(IAT_GROUP, "BosWarning", warningTime);
    return true;
}

int  AudioAiassistantSetting::getBosWarning()
{
    int defaultv = 5000;
    return DConfigManager::instance()->value(IAT_GROUP, "BosWarning", defaultv).toInt();
}

QVariantMap AudioAiassistantSetting::getIatParam()
{
    //params_str = "sub = iat, domain = iat, dwa=wpgs, language = zh_cn, accent = mandarin, sample_rate = 16000, eos=3000, result_type = json, result_encoding = utf8";
    QVariantMap param;
    param["sub"] = QString("iat");
    param["dwa"] = QString("wpgs");
    param["language"] = getIatLanguage();
    param["accent"] = QString("mandarin");
    param["sample_rate"] = QString("16000");
    param["vad_eos"] = QString::number(getEos());
    param["vad_bos"] = QString::number(getBos());
    param["result_type"] = QString("json");
    param["result_encoding"] = QString("utf8");
    return param;
}

void AudioAiassistantSetting::sync()
{
}
