// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include <fuzzer/FuzzedDataProvider.h>

#include <stddef.h>
#include <stdint.h>

#include <memory>
#include <string_view>

#include "components/client_update_protocol/ecdsa.h"

namespace client_update_protocol {

constexpr uint8_t kKeyPubBytes[] = {
    0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02,
    0x01, 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03, 0x01, 0x07, 0x03,
    0x42, 0x00, 0x04, 0x59, 0x65, 0x1F, 0x1D, 0x36, 0x33, 0x81, 0xE1, 0xB2,
    0xD3, 0x78, 0x4B, 0xE1, 0x7B, 0x8D, 0x07, 0x33, 0x55, 0x4F, 0x0D, 0x67,
    0x1C, 0x33, 0xD2, 0xFE, 0x78, 0x02, 0xB6, 0xD2, 0xDF, 0x2F, 0x45, 0x1F,
    0x49, 0xBA, 0xD2, 0xE6, 0x67, 0x4E, 0x4D, 0xA9, 0x77, 0xB3, 0x34, 0x12,
    0xEB, 0x6D, 0xC0, 0xDC, 0x86, 0xE7, 0xBE, 0xF7, 0x09, 0x56, 0x77, 0x2A,
    0xF3, 0xE8, 0x4E, 0x96, 0xAB, 0xAB, 0x12};

extern "C" int LLVMFuzzerTestOneInput(const uint8_t* data, size_t size) {
  FuzzedDataProvider fdp(data, size);
  std::string_view public_key = {reinterpret_cast<const char*>(kKeyPubBytes),
                                 sizeof(kKeyPubBytes)};
  std::unique_ptr<client_update_protocol::Ecdsa> cup =
      client_update_protocol::Ecdsa::Create(6, public_key);
  cup->SignRequest(fdp.ConsumeRandomLengthString());
  cup->ValidateResponse(fdp.ConsumeRandomLengthString(),
                        fdp.ConsumeRandomLengthString());
  return 0;
}

}  // namespace client_update_protocol
