/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ItemFilter;
import net.sf.saxon.expr.ItemMapper;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class ItemMappingIterator
implements SequenceIterator,
LookaheadIterator,
LastPositionFinder {
    private final SequenceIterator base;
    private final ItemMappingFunction action;
    private boolean oneToOne = false;

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction action) {
        this.base = base;
        this.action = action;
    }

    public static ItemMappingIterator map(SequenceIterator base, ItemMapper.Lambda mappingExpression) {
        return new ItemMappingIterator(base, ItemMapper.of(mappingExpression));
    }

    public static ItemMappingIterator filter(SequenceIterator base, ItemFilter.Lambda filterExpression) {
        return new ItemMappingIterator(base, ItemFilter.of(filterExpression));
    }

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction action, boolean oneToOne) {
        this.base = base;
        this.action = action;
        this.oneToOne = oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    protected SequenceIterator getBaseIterator() {
        return this.base;
    }

    protected ItemMappingFunction getMappingFunction() {
        return this.action;
    }

    @Override
    public boolean supportsHasNext() {
        return this.oneToOne && this.base instanceof LookaheadIterator && ((LookaheadIterator)this.base).supportsHasNext();
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public Item next() {
        try {
            Item nextSource;
            Item current;
            do {
                if ((nextSource = this.base.next()) != null) continue;
                return null;
            } while ((current = this.action.mapItem(nextSource)) == null);
            return current;
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public void discharge() {
        this.base.discharge();
    }

    @Override
    public boolean supportsGetLength() {
        return this.oneToOne && SequenceTool.supportsGetLength(this.base);
    }

    @Override
    public int getLength() {
        return SequenceTool.getLength(this.base);
    }
}

