#ifndef CACHEDATA_H
#define CACHEDATA_H
#include <string>
#include <atomic>
#include <deque>
#include <mutex>
#include <chrono>
#include <thread>
#include <fstream>
#include <map>
#include <memory>
#include <condition_variable>
#include "boost/serialization/singleton.hpp"
#include "boost/logic/tribool.hpp"
#include "boost/asio.hpp"
#include "json.hpp"
#include "common.h"

using namespace std;
using namespace boost::asio;

using json = nlohmann::json;

struct FileCompare
{
    uint64_t GetIndex(const string &str) const
    {
        string::size_type beginpos = str.rfind("_");
        string::size_type endpos = str.rfind(".");
        string strindex = str.substr(beginpos + 1, endpos - beginpos - 1);
        return strtoul(strindex.c_str(), nullptr, 10);
    }

    bool operator() (const string &str1, const string &str2) const
    {
        if(str1.find(".log") != string::npos)
        {
            return false;
        }
        else if(str2.find(".log") != string::npos)
        {
            return true;
        }
        else
        {
            return GetIndex(str1) < GetIndex(str2);
        }
    }
};

class CacheData:public boost::serialization::singleton<CacheData>
{
    typedef map<string, long, FileCompare> ScanMap;
public:
    CacheData();

    ~CacheData();

    void Init();

    void AddData(const string &package, const string &strdata);

    uint64_t GetNextEventCode();
private:
    // 添加任务至队列中
    void AddTaskInfo(TASKTYPE type, const string &data = "");

    // 获取日志文件（/var/lib/deepin/event-log/xxx.log）
    std::string FindLogFile();

    // 创建新日志（格式：event_1676449575.log）
    void CreateNewLog();

    // 扫描日志目录
    void ScanLogDir(uint64_t &totalsize, ScanMap &mapscan);

    void ArchiveLog(string strlog);

    void OnArchiveHandle(string logname);

    void OnScanHandle(int period);

    void ScanForRemove();

    // 删除旧文件
    void RemoveOldFiles(uint64_t totalsize, ScanMap &mapscan);

    // 移动日志文件 .log -> .bk
    void MoveLogFile();

    // 获取事件码文件和事件码
    void LoadEventCode();

    // 更新事件码（+100）
    void UpdateEventCode();

    // 校验本地缓存目录和文件（若不存在则创建，可能本地会被删除）
    bool CheckCache();
    void WriteCacheData(const string &strdata);

    void OnTimerReport(const boost::system::error_code &ec, uint period);

    bool CreateFile(const std::string &filename);

    static void LoopWriteData(void *p);
private:
    io_service m_io;
    steady_timer m_archivetimer;
    steady_timer m_scantimer;
    std::deque<TaskInfo> m_taskqueue;
    std::mutex m_mutex;
    std::condition_variable m_cond;
    atomic_bool m_quit;
    std::thread m_thrd;
    std::string m_cachedir;
    uint64_t m_fileindex;
    atomic_uint64_t m_eventcode;
    uint64_t m_nextevcode;
    std::string m_codefile;
    std::ofstream m_ofscache;
    std::string m_logfile;
};

#endif // CACHEDATA_H
