// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef SERVERPLUGIN_RECENTMANAGER_GLOBAL_H
#define SERVERPLUGIN_RECENTMANAGER_GLOBAL_H

#include <dfm-base/dfm_log_defines.h>

#define SERVERRECENTMANAGER_NAMESPACE serverplugin_recentmanager

#define SERVERRECENTMANAGER_BEGIN_NAMESPACE namespace SERVERRECENTMANAGER_NAMESPACE {
#define SERVERRECENTMANAGER_END_NAMESPACE }
#define SERVERRECENTMANAGER_USE_NAMESPACE using namespace SERVERRECENTMANAGER_NAMESPACE;

SERVERRECENTMANAGER_BEGIN_NAMESPACE
DFM_LOG_USE_CATEGORY(SERVERRECENTMANAGER_NAMESPACE)
SERVERRECENTMANAGER_END_NAMESPACE

SERVERRECENTMANAGER_BEGIN_NAMESPACE

inline int kRecentItemLimit { 1000 };

struct RecentItem
{
    QString href;
    qint64 modified;
};

SERVERRECENTMANAGER_END_NAMESPACE

Q_DECLARE_METATYPE(SERVERRECENTMANAGER_NAMESPACE::RecentItem);

#endif   // SERVERPLUGIN_RECENTMANAGER_GLOBAL_H
