/* This file is part of the OWL API.
 * The contents of this file are subject to the LGPL License, Version 3.0.
 * Copyright 2014, The University of Manchester
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0 in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. */
package org.semanticweb.owlapi.reasoner;

/**
 * A fresh entity is an entity that is not a built in entity (see
 * {@link org.semanticweb.owlapi.model.OWLEntity#isBuiltIn()} and is not contained within the
 * signature of the root ontology imports closure.
 *
 * @author Matthew Horridge, The University of Manchester, Information Management Group
 * @see org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration
 * @since 3.0.0
 */
public enum FreshEntityPolicy {
    /**
     * Specifies that fresh entities are allowed when they are encountered in the signature of
     * {@code OWLObject} instances in queries to a reasoner.
     */
    ALLOW,
    /**
     * Specifies that fresh entities are not disallowed. When a fresh entity is encountered in the
     * signature of an OWLObject that is used in a query to a reasoner an
     * {@link FreshEntitiesException} will be thrown in the calling thread.
     */
    DISALLOW
}
