<?php
return CRM_Core_CodeGen_OptionGroup::create('report_template', 'a/0039')
  ->addMetadata([
    'title' => ts('Report Template'),
  ])
  ->addValues([
    [
      'label' => ts('Constituent Report (Summary)'),
      'value' => 'contact/summary',
      'name' => 'CRM_Report_Form_Contact_Summary',
      'weight' => 1,
      'description' => ts('Provides a list of address and telephone information for constituent records in your system.'),
    ],
    [
      'label' => ts('Constituent Report (Detail)'),
      'value' => 'contact/detail',
      'name' => 'CRM_Report_Form_Contact_Detail',
      'weight' => 2,
      'description' => ts('Provides contact-related information on contributions, memberships, events and activities.'),
    ],
    [
      'label' => ts('Activity Details Report'),
      'value' => 'activity',
      'name' => 'CRM_Report_Form_Activity',
      'weight' => 3,
      'description' => ts('Provides a list of constituent activity including activity statistics for one/all contacts during a given date range(required)'),
    ],
    [
      'label' => ts('Walk / Phone List Report'),
      'value' => 'walklist',
      'name' => 'CRM_Report_Form_Walklist_Walklist',
      'weight' => 4,
      'description' => ts('Provides a detailed report for your walk/phonelist for targeted contacts'),
      'is_active' => 0,
    ],
    [
      'label' => ts('Current Employer Report'),
      'value' => 'contact/currentEmployer',
      'name' => 'CRM_Report_Form_Contact_CurrentEmployer',
      'weight' => 5,
      'description' => ts('Provides detail list of employer employee relationships along with employment details Ex Join Date'),
    ],
    [
      'label' => ts('Contribution Summary Report'),
      'value' => 'contribute/summary',
      'name' => 'CRM_Report_Form_Contribute_Summary',
      'weight' => 6,
      'description' => ts('Groups and totals contributions by criteria including contact, time period, financial type, contributor location, etc.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Contribution Detail Report'),
      'value' => 'contribute/detail',
      'name' => 'CRM_Report_Form_Contribute_Detail',
      'weight' => 7,
      'description' => ts('Lists specific contributions by criteria including contact, time period, financial type, contributor location, etc. Contribution summary report points to this report for contribution details.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Repeat Contributions Report'),
      'value' => 'contribute/repeat',
      'name' => 'CRM_Report_Form_Contribute_Repeat',
      'weight' => 8,
      'description' => ts('Given two date ranges, shows contacts who contributed in both the date ranges with the amount contributed in each and the percentage increase / decrease.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Contributions by Organization Report'),
      'value' => 'contribute/organizationSummary',
      'name' => 'CRM_Report_Form_Contribute_OrganizationSummary',
      'weight' => 9,
      'description' => ts('Displays a detailed list of contributions grouped by organization, which includes contributions made by employees for the organisation.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Contributions by Household Report'),
      'value' => 'contribute/householdSummary',
      'name' => 'CRM_Report_Form_Contribute_HouseholdSummary',
      'weight' => 10,
      'description' => ts('Displays a detailed list of contributions grouped by household which includes contributions made by members of the household.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Top Donors Report'),
      'value' => 'contribute/topDonor',
      'name' => 'CRM_Report_Form_Contribute_TopDonor',
      'weight' => 11,
      'description' => ts('Provides a list of the top donors during a time period you define. You can include as many donors as you want (for example, top 100 of your donors).'),
      'component_id' => 2,
    ],
    [
      'label' => ts('SYBUNT Report'),
      'value' => 'contribute/sybunt',
      'name' => 'CRM_Report_Form_Contribute_Sybunt',
      'weight' => 12,
      'description' => ts('SYBUNT means some year(s) but not this year. Provides a list of constituents who donated at some time in the history of your organization but did not donate during the time period you specify.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('LYBUNT Report'),
      'value' => 'contribute/lybunt',
      'name' => 'CRM_Report_Form_Contribute_Lybunt',
      'weight' => 13,
      'description' => ts('LYBUNT means last year but not this year. Provides a list of constituents who donated last year but did not donate during the time period you specify as the current year.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Soft Credit Report'),
      'value' => 'contribute/softcredit',
      'name' => 'CRM_Report_Form_Contribute_SoftCredit',
      'weight' => 14,
      'description' => ts('Shows contributions made by contacts that have been soft-credited to other contacts.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Membership Report (Summary)'),
      'value' => 'member/summary',
      'name' => 'CRM_Report_Form_Member_Summary',
      'weight' => 15,
      'description' => ts('Provides a summary of memberships by type and Member Since.'),
      'component_id' => 3,
    ],
    [
      'label' => ts('Membership Report (Detail)'),
      'value' => 'member/detail',
      'name' => 'CRM_Report_Form_Member_Detail',
      'weight' => 16,
      'description' => ts('Provides a list of members along with their membership status and membership details (Member Since, Membership Start Date, Membership Expiration Date). Can also display contributions (payments) associated with each membership.'),
      'component_id' => 3,
    ],
    [
      'label' => ts('Membership Report (Lapsed)'),
      'value' => 'member/lapse',
      'name' => 'CRM_Report_Form_Member_Lapse',
      'weight' => 17,
      'description' => ts('Provides a list of memberships that lapsed or will lapse before the date you specify.'),
      'component_id' => 3,
    ],
    [
      'label' => ts('Event Participant Report (List)'),
      'value' => 'event/participantListing',
      'name' => 'CRM_Report_Form_Event_ParticipantListing',
      'weight' => 18,
      'description' => ts('Provides lists of participants for an event.'),
      'component_id' => 1,
    ],
    [
      'label' => ts('Event Income Report (Summary)'),
      'value' => 'event/summary',
      'name' => 'CRM_Report_Form_Event_Summary',
      'weight' => 19,
      'description' => ts('Provides an overview of event income. You can include key information such as event ID, registration, attendance, and income generated to help you determine the success of an event.'),
      'component_id' => 1,
    ],
    [
      'label' => ts('Event Income Report (Detail)'),
      'value' => 'event/income',
      'name' => 'CRM_Report_Form_Event_Income',
      'weight' => 20,
      'description' => ts('Helps you to analyze the income generated by an event. The report can include details by participant type, status and payment method.'),
      'component_id' => 1,
    ],
    [
      'label' => ts('Pledge Detail Report'),
      'value' => 'pledge/detail',
      'name' => 'CRM_Report_Form_Pledge_Detail',
      'weight' => 21,
      'description' => ts('List of pledges including amount pledged, pledge status, next payment date, balance due, total amount paid etc.'),
      'component_id' => 6,
    ],
    [
      'label' => ts('Pledged but not Paid Report'),
      'value' => 'pledge/pbnp',
      'name' => 'CRM_Report_Form_Pledge_Pbnp',
      'weight' => 22,
      'description' => ts('Pledged but not Paid Report'),
      'component_id' => 6,
    ],
    [
      'label' => ts('Relationship Report'),
      'value' => 'contact/relationship',
      'name' => 'CRM_Report_Form_Contact_Relationship',
      'weight' => 23,
      'description' => ts('Relationship Report'),
    ],
    [
      'label' => ts('Case Summary Report'),
      'value' => 'case/summary',
      'name' => 'CRM_Report_Form_Case_Summary',
      'weight' => 24,
      'description' => ts('Provides a summary of cases and their duration by date range, status, staff member and / or case role.'),
      'component_id' => 7,
    ],
    [
      'label' => ts('Case Time Spent Report'),
      'value' => 'case/timespent',
      'name' => 'CRM_Report_Form_Case_TimeSpent',
      'weight' => 25,
      'description' => ts('Aggregates time spent on case and / or non-case activities by activity type and contact.'),
      'component_id' => 7,
    ],
    [
      'label' => ts('Contact Demographics Report'),
      'value' => 'case/demographics',
      'name' => 'CRM_Report_Form_Case_Demographics',
      'weight' => 26,
      'description' => ts('Demographic breakdown for case clients (and or non-case contacts) in your database. Includes custom contact fields.'),
      'component_id' => 7,
    ],
    [
      'label' => ts('Database Log Report'),
      'value' => 'contact/log',
      'name' => 'CRM_Report_Form_Contact_Log',
      'weight' => 27,
      'description' => ts('Log of contact and activity records created or updated in a given date range.'),
    ],
    [
      'label' => ts('Activity Summary Report'),
      'value' => 'activitySummary',
      'name' => 'CRM_Report_Form_ActivitySummary',
      'weight' => 28,
      'description' => ts('Shows activity statistics by type / date'),
    ],
    [
      'label' => ts('Bookkeeping Transactions Report'),
      'value' => 'contribute/bookkeeping',
      'name' => 'CRM_Report_Form_Contribute_Bookkeeping',
      'weight' => 29,
      'description' => ts('Shows Bookkeeping Transactions Report'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Participant list Count Report'),
      'value' => 'event/participantlist',
      'name' => 'CRM_Report_Form_Event_ParticipantListCount',
      'weight' => 31,
      'description' => ts('Shows the Participant list with Participant Count.'),
      'component_id' => 1,
    ],
    [
      'label' => ts('Income Count Summary Report'),
      'value' => 'event/incomesummary',
      'name' => 'CRM_Report_Form_Event_IncomeCountSummary',
      'weight' => 32,
      'description' => ts('Shows the Income Summary of events with Count.'),
      'component_id' => 1,
    ],
    [
      'label' => ts('Case Detail Report'),
      'value' => 'case/detail',
      'name' => 'CRM_Report_Form_Case_Detail',
      'weight' => 33,
      'description' => ts('Case Details'),
      'component_id' => 7,
    ],
    [
      'label' => ts('Mail Bounce Report'),
      'value' => 'Mailing/bounce',
      'name' => 'CRM_Report_Form_Mailing_Bounce',
      'weight' => 34,
      'description' => ts('Bounce Report for mailings'),
      'component_id' => 4,
    ],
    [
      'label' => ts('Mail Summary Report'),
      'value' => 'Mailing/summary',
      'name' => 'CRM_Report_Form_Mailing_Summary',
      'weight' => 35,
      'description' => ts('Summary statistics for mailings'),
      'component_id' => 4,
    ],
    [
      'label' => ts('Mail Opened Report'),
      'value' => 'Mailing/opened',
      'name' => 'CRM_Report_Form_Mailing_Opened',
      'weight' => 36,
      'description' => ts('Display contacts who opened emails from a mailing'),
      'component_id' => 4,
    ],
    [
      'label' => ts('Mail Click-Through Report'),
      'value' => 'Mailing/clicks',
      'name' => 'CRM_Report_Form_Mailing_Clicks',
      'weight' => 37,
      'description' => ts('Display clicks from each mailing'),
      'component_id' => 4,
    ],
    [
      'label' => ts('Contact Logging Report (Summary)'),
      'value' => 'logging/contact/summary',
      'name' => 'CRM_Report_Form_Contact_LoggingSummary',
      'weight' => 38,
      'description' => ts('Contact modification report for the logging infrastructure (summary).'),
      'is_active' => 0,
    ],
    [
      'label' => ts('Contact Logging Report (Detail)'),
      'value' => 'logging/contact/detail',
      'name' => 'CRM_Report_Form_Contact_LoggingDetail',
      'weight' => 39,
      'description' => ts('Contact modification report for the logging infrastructure (detail).'),
      'is_active' => 0,
    ],
    [
      'label' => ts('Survey Report (Detail)'),
      'value' => 'survey/detail',
      'name' => 'CRM_Report_Form_Campaign_SurveyDetails',
      'weight' => 43,
      'description' => ts('Detailed report for canvassing, phone-banking, walk lists or other surveys.'),
      'component_id' => 9,
    ],
    [
      'label' => ts('Personal Campaign Page Report'),
      'value' => 'contribute/pcp',
      'name' => 'CRM_Report_Form_Contribute_PCP',
      'weight' => 44,
      'description' => ts('Summarizes amount raised and number of contributors for each Personal Campaign Page.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Pledge Summary Report'),
      'value' => 'pledge/summary',
      'name' => 'CRM_Report_Form_Pledge_Summary',
      'weight' => 45,
      'description' => ts('Groups and totals pledges by criteria including contact, time period, pledge status, location, etc.'),
      'component_id' => 6,
    ],
    [
      'label' => ts('Contribution Aggregate by Relationship'),
      'value' => 'contribute/history',
      'name' => 'CRM_Report_Form_Contribute_History',
      'weight' => 46,
      'description' => ts('List contact\'s donation history, grouped by year, along with contributions attributed to any of the contact\'s related contacts.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Mail Detail Report'),
      'value' => 'mailing/detail',
      'name' => 'CRM_Report_Form_Mailing_Detail',
      'weight' => 47,
      'description' => ts('Provides reporting on Intended and Successful Deliveries, Unsubscribes and Opt-outs, Replies and Forwards.'),
      'component_id' => 4,
    ],
    [
      'label' => ts('Contribution and Membership Details'),
      'value' => 'member/contributionDetail',
      'name' => 'CRM_Report_Form_Member_ContributionDetail',
      'weight' => 48,
      'description' => ts('Contribution details for any type of contribution, plus associated membership information for contributions which are in payment for memberships.'),
      'component_id' => 3,
    ],
    [
      'label' => ts('Recurring Contributions Report'),
      'value' => 'contribute/recur',
      'name' => 'CRM_Report_Form_Contribute_Recur',
      'weight' => 49,
      'description' => ts('Provides information about the status of recurring contributions'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Recurring Contributions Summary'),
      'value' => 'contribute/recursummary',
      'name' => 'CRM_Report_Form_Contribute_RecurSummary',
      'weight' => 49,
      'description' => ts('Provides simple summary for each payment instrument for which there are recurring contributions (e.g. Credit Card, Standing Order, Direct Debit, etc., NULL), showing within a given date range.'),
      'component_id' => 2,
    ],
    [
      'label' => ts('Deferred Revenue Details'),
      'value' => 'contribute/deferredrevenue',
      'name' => 'CRM_Report_Form_Contribute_DeferredRevenue',
      'weight' => 50,
      'description' => ts('Deferred Revenue Details Report'),
      'component_id' => 2,
    ],
  ]);
