# CiviCRM 5.59.0

Released March 1, 2023

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

- **Add Report Instance apiv4
  ([25226](https://github.com/civicrm/civicrm-core/pull/25226))**

  Adds the Report Instance entity to APIv4.

- **Add support for extension .mo in [civicrm.l10n]
  ([dev/translation#76](https://lab.civicrm.org/dev/translation/-/issues/76):
  [25419](https://github.com/civicrm/civicrm-core/pull/25419))**

  Allows extension "mo" files to live in the I18N resource dir.

- **luxembourg-provices added missing provinces, updated outdated ISO code…
  ([25211](https://github.com/civicrm/civicrm-core/pull/25211))**

  Adds missing provinces for luxembourg, updates 3 outdated ISO codes for
  Diekirch, Grevenmacher and Luxembourg provinces because after 2015 they were
  changed and also changes GreveNmacher province name to Grevenmacher.

- **Proposal - change title for all `is_primary` fields to 'Is Primary'
  ([dev/core#4096](https://lab.civicrm.org/dev/core/-/issues/4096):
  [25473](https://github.com/civicrm/civicrm-core/pull/25473))**

  Renames the import field "Primary Email" to "Is Primary".

- **Scheduled jobs: Warning text if runInNonProductionEnvironment=TRUE  
  ([25307](https://github.com/civicrm/civicrm-core/pull/25307))**

  Adds a description to inform admins about runInNonProductionEnvironment=TRUE
  sending emails even if mail sending is suppressed in settings.

- **APIv4 - Support autocompletes of the Entity entity
  ([25409](https://github.com/civicrm/civicrm-core/pull/25409))**

  Adds missing metadata to allow browsing API entities with the APIv4
  autocomplete select.

- **Enhance metadata for OptionGroups
  ([25188](https://github.com/civicrm/civicrm-core/pull/25188))**

  Improves metadata for Option Groups.

- **CRM_Core_BAO_CMSUser - use system specific method rather than checking
  userFramework
  ([dev/core#4074](https://lab.civicrm.org/dev/core/-/issues/4074):
  [25323](https://github.com/civicrm/civicrm-core/pull/25323))**

  Helps make CiviCRM more CMS agnostic.

- **Smarty Mixin - Allow extensions to enable Smarty via mixin
  ([25369](https://github.com/civicrm/civicrm-core/pull/25369))**

  Define a mixin, smarty-v2@1.0.0, which can be used by extensions to register
  their templates/ folder.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Sometimes Custom fields missing on profile
  ([dev/core#1984](https://lab.civicrm.org/dev/core/-/issues/1984):
  [25321](https://github.com/civicrm/civicrm-core/pull/25321))**

- **Warning: count(): Parameter must be an array or an object that implements
  Countable when saving My Profile or Name and Address
  ([dev/core#2301](https://lab.civicrm.org/dev/core/-/issues/2301):
  [25315](https://github.com/civicrm/civicrm-core/pull/25315))**

- **Cannot get Auth Code in Oauth2 from Microsoft Azure Application
  ([dev/core#2559](https://lab.civicrm.org/dev/core/-/issues/2559):
  [25214](https://github.com/civicrm/civicrm-core/pull/25214))**

- **Extension cannot find its own classes during install when opcache is enabled
  ([dev/core#4055](https://lab.civicrm.org/dev/core/-/issues/4055):
  [25379](https://github.com/civicrm/civicrm-core/pull/25379))**

- **Running a Contact Summary report as a limited access user granted gives DB
  Error: no such field
  ([dev/core#4068](https://lab.civicrm.org/dev/core/-/issues/4068):
  [25525](https://github.com/civicrm/civicrm-core/pull/25525))**

- **system workflow templates do not respect the selected pdf format anymore
  ([dev/core#4080](https://lab.civicrm.org/dev/core/-/issues/4080):
  [25547](https://github.com/civicrm/civicrm-core/pull/25547))**

- **Regression - CiviCRM core unit tests interfere with running non-CiviCRM
  tests ([dev/core#4088](https://lab.civicrm.org/dev/core/-/issues/4088):
  [25415](https://github.com/civicrm/civicrm-core/pull/25415),
  [25378](https://github.com/civicrm/civicrm-core/pull/25378) and
  [25412](https://github.com/civicrm/civicrm-core/pull/25412))**

- **CRM_Utils_Number::formatLocaleNumeric() method throws fatal error with empty
  string parameter.
  ([dev/core#4097](https://lab.civicrm.org/dev/core/-/issues/4097):
  [25448](https://github.com/civicrm/civicrm-core/pull/25448) and
  [25462](https://github.com/civicrm/civicrm-core/pull/25462))**

- **New `address_primary` tokens don't work
  ([dev/core#4109](https://lab.civicrm.org/dev/core/-/issues/4109):
  [25548](https://github.com/civicrm/civicrm-core/pull/25548))**

- **civiimport - PEAR Exception handling - Mitigation of scenario where an
  import table has been deleted and the metadata is out of date
  ([25633](https://github.com/civicrm/civicrm-core/pull/25633))**

- **Status Check - Tweak severity of timezone warning
  ([25583](https://github.com/civicrm/civicrm-core/pull/25583))**

- **Fix slow queries in snapshot process
  ([25420](https://github.com/civicrm/civicrm-core/pull/25420))**

- **Increase timeout on imap
  ([25418](https://github.com/civicrm/civicrm-core/pull/25418))**

- **Ensure useful exception thrown for all Smarty errors from user strings
  ([25334](https://github.com/civicrm/civicrm-core/pull/25334))**

- **Queues - Ensure that queue timings work, even with bad tzdata
  ([25363](https://github.com/civicrm/civicrm-core/pull/25363))**

- **CustomField - Fix smarty notices on field create/edit form
  ([25397](https://github.com/civicrm/civicrm-core/pull/25397))**

- **Fix custom field bug on UFMatch sync
  ([25549](https://github.com/civicrm/civicrm-core/pull/25549))**

- **CustomFields - Drop unused column 'mask'
  ([25396](https://github.com/civicrm/civicrm-core/pull/25396))**

- **Pass metadata values rather than convoluted array to `processCustomFields`
  ([25318](https://github.com/civicrm/civicrm-core/pull/25318))**

- **Disable extern/soap.php. Remove implementation and tests.
  ([25317](https://github.com/civicrm/civicrm-core/pull/25317))**

  Deprecates soap integration which is no longer being used.

- **Fix Undefined index: name Notice in civicrm_api3_message_template_send
  ([25288](https://github.com/civicrm/civicrm-core/pull/25288))**

- **Standardise Type on `includedGroups` parameter
  ([25330](https://github.com/civicrm/civicrm-core/pull/25330))**

- **Smarty notice fix - check array key exists before querying
  ([25453](https://github.com/civicrm/civicrm-core/pull/25453))**

- **Do not crash the whole SearchKit UI if one entity fails
  ([25433](https://github.com/civicrm/civicrm-core/pull/25433))**

- **Fix typo in upgrade message
  ([25481](https://github.com/civicrm/civicrm-core/pull/25481))**

- **Fix exception type in upgrade snapshot
  ([25480](https://github.com/civicrm/civicrm-core/pull/25480))**

- **Report tpl enotices fix
  ([25452](https://github.com/civicrm/civicrm-core/pull/25452))**

- **Fix some more smarty assignments to assign even when FALSE
  ([25459](https://github.com/civicrm/civicrm-core/pull/25459))**

- **Do not attempt to format custom value of empty string
  ([25451](https://github.com/civicrm/civicrm-core/pull/25451))**

### CiviCase

- **Undefined array keys on case activity view
  ([25381](https://github.com/civicrm/civicrm-core/pull/25381))**

- **Undefined `accessKey` on case activity view
  ([25382](https://github.com/civicrm/civicrm-core/pull/25382))**

- **Fix display of custom data in cases
  ([25440](https://github.com/civicrm/civicrm-core/pull/25440))**

### CiviContribute

- **Dummy payment processor should be flagged as such on LIVE page
  ([dev/core#3844](https://lab.civicrm.org/dev/core/-/issues/3844):
  [25282](https://github.com/civicrm/civicrm-core/pull/25282))**

- **Fix failure when changing processor type on add Payment Processor screen
  ([25340](https://github.com/civicrm/civicrm-core/pull/25340))**

- **avoid empty error message when submitting PCP page.
  ([25277](https://github.com/civicrm/civicrm-core/pull/25277))**

- **Searchkit not loading pledge ID's
  ([dev/core#4131](https://lab.civicrm.org/dev/core/-/issues/4131):
  [25598](https://github.com/civicrm/civicrm-core/pull/25598))**

- **Paypal cancel/notify/return URLs
  ([25376](https://github.com/civicrm/civicrm-core/pull/25376))**

  Fixes Paypal standard on Drupal9 Webform and any other offsite payment
  processor that uses the standard methods.

### CiviEvent

- **"Please enter a Title for the registration Confirmation Page" when saving
  event with no confirmation page
  ([dev/core#4119](https://lab.civicrm.org/dev/core/-/issues/4119):
  [25578](https://github.com/civicrm/civicrm-core/pull/25578))**

- **Assign participant_status_id in both edit/create modes
  ([dev/core#4084](https://lab.civicrm.org/dev/core/-/issues/4084):
  [25366](https://github.com/civicrm/civicrm-core/pull/25366))**

  Previously only assigned in edit mode.

- **API v.3 Event.create used for update will change Event Template to ordinary
  Event ([dev/core#4081](https://lab.civicrm.org/dev/core/-/issues/4081):
  [25356](https://github.com/civicrm/civicrm-core/pull/25356))**

- **Original value is displayed after setting custom event field blank
  ([dev/core#2985](https://lab.civicrm.org/dev/core/-/issues/2985):
  [25229](https://github.com/civicrm/civicrm-core/pull/25229))**

- **Manage Events - Configure options have class disabled if no settings
  entered - causes Bootstrap issues
  ([dev/core#2542](https://lab.civicrm.org/dev/core/-/issues/2542):
  [24665](https://github.com/civicrm/civicrm-core/pull/24665))**

- **Unconditionally assign `registerClosed` on event info page
  ([25251](https://github.com/civicrm/civicrm-core/pull/25251))**

### Backdrop Integration

- **Bug: when adding CMS user with a profile, get a fatal error when passwords
  get verified for strength
  ([dev/backdrop#77](https://lab.civicrm.org/dev/backdrop/-/issues/77):
  [25371](https://github.com/civicrm/civicrm-core/pull/25371))**

### Drupal Integration

- **Drupal 8 profile validation not finding the right profile when validating
  submission on CMS user tabs
  ([dev/drupal#153](https://lab.civicrm.org/dev/drupal/-/issues/153):
  [77](https://github.com/civicrm/civicrm-drupal-8/pull/77) and
  [25336](https://github.com/civicrm/civicrm-core/pull/25336))**

### Joomla Integration

- **[Joomla 4.0] Cannot access/set user permissions
  ([dev/joomla#35](https://lab.civicrm.org/dev/joomla/-/issues/35):
  [67](https://github.com/civicrm/civicrm-joomla/pull/67))**

- **Use correct var for joomla synchronizeUFMatch
  ([25658](https://github.com/civicrm/civicrm-core/pull/25658))**

### WordPress Integration

- **Prevent PHP warnings when no WordPress user is found
  ([25477](https://github.com/civicrm/civicrm-core/pull/25477))**

## <a name="misc"></a>Miscellany

- **Update class_image.php for PHP8
  ([358](https://github.com/civicrm/civicrm-packages/pull/358))**

- **Update polyfill packages
  ([25417](https://github.com/civicrm/civicrm-core/pull/25417))**

- **simplify calculation of lifetime memberships in CRM_Price_BAO_PriceSet
  ([25456](https://github.com/civicrm/civicrm-core/pull/25456))**

- **Make otherwise unused form function private
  ([25389](https://github.com/civicrm/civicrm-core/pull/25389))**

- **Bump dompdf/dompdf from 2.0.2 to 2.0.3
  ([25523](https://github.com/civicrm/civicrm-core/pull/25523))**

- **Deprecate meaningless parameter
  ([25259](https://github.com/civicrm/civicrm-core/pull/25259))**

- **Greenwich - Run `civix upgrade`
  ([25249](https://github.com/civicrm/civicrm-core/pull/25249))**

- **Flexmailer - Re-run civix upgrade
  ([25357](https://github.com/civicrm/civicrm-core/pull/25357))**

- **Run civix upgrade on oauth
  ([25358](https://github.com/civicrm/civicrm-core/pull/25358))**

- **Civix upgrade on event cart
  ([25361](https://github.com/civicrm/civicrm-core/pull/25361))**

- **Civix upgrade message_admin
  ([25359](https://github.com/civicrm/civicrm-core/pull/25359))**

- **Run Civix upgrade on afform/core with template patch applied
  ([25250](https://github.com/civicrm/civicrm-core/pull/25250))**

- **Remove code for legacy php versions - `assign_by_ref` with an object
  ([25247](https://github.com/civicrm/civicrm-core/pull/25247))**

- **Remove a couple of legacy uses of `contributeMode`
  ([25239](https://github.com/civicrm/civicrm-core/pull/25239))**

- **Remove code deprecated in 2019
  ([25262](https://github.com/civicrm/civicrm-core/pull/25262))**

- **Remove unused method in CRM_Contact_Form_Task_PDFLetterCommon
  ([25326](https://github.com/civicrm/civicrm-core/pull/25326))**

- **added myself to contributor-key.yml
  ([25314](https://github.com/civicrm/civicrm-core/pull/25314))**

- **Add dontub to contributor-key.yml
  ([25475](https://github.com/civicrm/civicrm-core/pull/25475))**

- **Remove error suppression operator from test
  ([25344](https://github.com/civicrm/civicrm-core/pull/25344))**

- **typo: dlass --> class
  ([25308](https://github.com/civicrm/civicrm-core/pull/25308))**

- **PHP 8.1 compatibility when enabling logging
  ([25339](https://github.com/civicrm/civicrm-core/pull/25339))**

- **Php 8.2 fix undefined property, move test to appropriate extension
  ([25313](https://github.com/civicrm/civicrm-core/pull/25313))**

- **php8 - don't pass null to htmlspecialchars on profile admin page
  ([25463](https://github.com/civicrm/civicrm-core/pull/25463))**

- **Php8.2 Contact import Map Field screen - remove undefined property usage
  (mutliple) ([25298](https://github.com/civicrm/civicrm-core/pull/25298))**

- **Php 8.2 - undefined property fix in test class
  ([25332](https://github.com/civicrm/civicrm-core/pull/25332))**

- **php8.2 - Fix undefined property, general test cleanup
  ([25312](https://github.com/civicrm/civicrm-core/pull/25312))**

- **[REF][PHP8.2] Avoid dynamic property in ReportTest
  ([25399](https://github.com/civicrm/civicrm-core/pull/25399))**

- **[REF][PHP8.2] Fix Eway Single Payment Processor extension for dynamic
  properties ([25354](https://github.com/civicrm/civicrm-core/pull/25354))**

- **[REF][PHP8.2] Use const instead of dynamic property:
  CRM_Contribute_BAO_ContributionPageTest
  ([25372](https://github.com/civicrm/civicrm-core/pull/25372))**

- **[REF][PHP8.2] Fix Deprecated Dynamic class properties in Legacy custom
  searches extension
  ([25393](https://github.com/civicrm/civicrm-core/pull/25393))**

- **[REF][PHP8.2] Declare processor property in CRM_Case_XMLProcessorTest
  ([25407](https://github.com/civicrm/civicrm-core/pull/25407))**

- **[REF][PHP8.2] Avoid dynamic property in CRM_SMS_ProviderTest
  ([25388](https://github.com/civicrm/civicrm-core/pull/25388))**

- **[REF][PHP8.2] Declare $file property in CRM_Utils_ZipTest
  ([25373](https://github.com/civicrm/civicrm-core/pull/25373))**

- **[REF][PHP8.2] Avoid dynamic properties in api_v3_EventTest
  ([25375](https://github.com/civicrm/civicrm-core/pull/25375))**

- **[REF][PHP8.2] Avoid dynamic properties in module tests
  ([25348](https://github.com/civicrm/civicrm-core/pull/25348))**

- **[REF][PHP8.2] Fix PHP8.2 creation of dynamic properties in the elavon tests
  and Payment Processor class
  ([25353](https://github.com/civicrm/civicrm-core/pull/25353))**

- **[REF][PHP8.2] Avoid dynamic properties in api_v3_GroupOrganizationTest
  ([25352](https://github.com/civicrm/civicrm-core/pull/25352))**

- **[REF][PHP8.2] Avoid dynamic properties in api_v3_ContactTypeTest
  ([25342](https://github.com/civicrm/civicrm-core/pull/25342))**

- **[REF][PHP8.2] Avoid dynamic properties in
  CRM_Contact_BAO_ContactType_RelationshipTest
  ([25347](https://github.com/civicrm/civicrm-core/pull/25347))**

- **[REF][PHP8.2] Move to standard varaibles in
  CRM_Price_BAO_PriceFieldValueTest to avoid dynamic properties
  ([25343](https://github.com/civicrm/civicrm-core/pull/25343))**

- **[REF][PHP8.2] Use const instead of dynamic property api_v3_CaseTypeTest
  ([25345](https://github.com/civicrm/civicrm-core/pull/25345))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Case_XMLProcessor_ProcessTest
  ([25325](https://github.com/civicrm/civicrm-core/pull/25325))**

- **[REF][PHP8.2] Fix creation of dynamic properties in Payflow Pro extension
  ([25355](https://github.com/civicrm/civicrm-core/pull/25355))**

- **[REF][PHP8.2] Tidy up of CRM_Report_Form_Member_DetailTest
  ([25450](https://github.com/civicrm/civicrm-core/pull/25450))**

- **[REF][PHP8.2] Declare missing property on CRM_Utils_HookTest
  ([25447](https://github.com/civicrm/civicrm-core/pull/25447))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Event_BAO_ParticipantTest
  ([25449](https://github.com/civicrm/civicrm-core/pull/25449))**

- **[REF][PHP8.2] Fix Dynamic property payment instrument id on back office
  contribution form
  ([25426](https://github.com/civicrm/civicrm-core/pull/25426))**

- **[REF][PHP8.2] Tidy up CRM_Batch_Form_EntryTest
  ([25455](https://github.com/civicrm/civicrm-core/pull/25455))**

- **[REF][PHP8.2] Tidy, and PHP8.2 compatibility for
  api_v3_CustomValueContactTypeTest
  ([25479](https://github.com/civicrm/civicrm-core/pull/25479))**

- **[REF][PHP8.2] Declare system property in tests
  ([25401](https://github.com/civicrm/civicrm-core/pull/25401))**

- **[REF][PHP8.2] Declare file property in CRM_Extension_InfoTest
  ([25405](https://github.com/civicrm/civicrm-core/pull/25405))**

- **[REF][PHP8.2] Declare properties in CRM_Activity_Page_AJAXTest
  ([25443](https://github.com/civicrm/civicrm-core/pull/25443))**

- **[REF][PHP8.2] Refactor CRM_Case_BAO_CaseTest to use const
  ([25442](https://github.com/civicrm/civicrm-core/pull/25442))**

- **[REF][PHP8.2] Remove dynamic property in
  CRM_Contribute_Form_ContributionPageTranslationTest
  ([25489](https://github.com/civicrm/civicrm-core/pull/25489))**

- **[REF][PHP8.2] Declare properties on CRM_Member_Import_Parser_MembershipTest
  ([25491](https://github.com/civicrm/civicrm-core/pull/25491))**

- **[REF][PHP8.2] Refactor CRM_Contact_BAO_ContactType_ContactSearchTest to not
  use dynamic properties
  ([25406](https://github.com/civicrm/civicrm-core/pull/25406))**

- **[REF][PHP8.2] Declare properties in CRM_Contact_BAO_ContactType_ContactTest
  ([25478](https://github.com/civicrm/civicrm-core/pull/25478))**

- **[REF][PHP8.2] Avoid dynamic properties in queue tests
  ([25299](https://github.com/civicrm/civicrm-core/pull/25299))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Core_I18n_Form
  ([25297](https://github.com/civicrm/civicrm-core/pull/25297))**

- **[REF][PHP8.2] Avoid dynamic properties in api_v3_NoteTest
  ([25310](https://github.com/civicrm/civicrm-core/pull/25310))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Contact_Page_DedupeException
  ([25301](https://github.com/civicrm/civicrm-core/pull/25301))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Case_Form_CaseView
  ([25292](https://github.com/civicrm/civicrm-core/pull/25292))**

- **[REF][PHP8.2] Avoid dynamic properties in CRM_Extension_Container_Static
  ([25311](https://github.com/civicrm/civicrm-core/pull/25311))**

- **[REF] Use civi::statics to get activityinfos in case activity view
  ([25404](https://github.com/civicrm/civicrm-core/pull/25404))**

- **[REF] Regen following #25211
  ([25413](https://github.com/civicrm/civicrm-core/pull/25413))**

- **(REF) Tidy up properties in CRM_Core_ResourcesTest
  ([25349](https://github.com/civicrm/civicrm-core/pull/25349))**

- **(REF) Tidy up of CRM_Extension_ManagerTest
  ([25350](https://github.com/civicrm/civicrm-core/pull/25350))**

- **(REF) Fix field name when doing DAO find in MergerTest
  ([25337](https://github.com/civicrm/civicrm-core/pull/25337))**

- **(REF) Tidy-up unreachable return
  ([25324](https://github.com/civicrm/civicrm-core/pull/25324))**

- **[Ref] MembershipView page - Remove redundant financialacl check
  ([23230](https://github.com/civicrm/civicrm-core/pull/23230))**

- **[REF] Use Civi::statics in CRM_Utils_File instead of php static
  ([25498](https://github.com/civicrm/civicrm-core/pull/25498))**

- **(REF) CRM_Upgrade_Headless - The pre-up and post-up msgs should have same
  formatting ([25488](https://github.com/civicrm/civicrm-core/pull/25488))**

- **[REF] Add in function to retrieve Pre Upgrade messages in headless
  ([25414](https://github.com/civicrm/civicrm-core/pull/25414))**

- **[REF] Disable Soap wp reset options
  ([288](https://github.com/civicrm/civicrm-wordpress/pull/288))**

- **(REF) Remove _prefElement dynamic property
  ([25293](https://github.com/civicrm/civicrm-core/pull/25293))**

- **[REF] Upgrade Smarty to 2.6.32
  ([359](https://github.com/civicrm/civicrm-packages/pull/359))**

- **[REF] [Merge custom fields] Copy complex function into merger class, ready
  to disentangle as little shared code is really used
  ([25219](https://github.com/civicrm/civicrm-core/pull/25219))**

- **CaseActivityTest - Fix quiet regressions
  ([25416](https://github.com/civicrm/civicrm-core/pull/25416))**

- **[NFC/Unit tests] Deprecated theme in unit test base class
  ([76](https://github.com/civicrm/civicrm-drupal-8/pull/76))**

- **NFC - Update tested up to value for WP sites
  ([287](https://github.com/civicrm/civicrm-wordpress/pull/287))**

- **(NFC) Another batch of PHPDoc fixes
  ([25351](https://github.com/civicrm/civicrm-core/pull/25351))**

- **(NFC) Cleanup Gitlab references
  ([25365](https://github.com/civicrm/civicrm-core/pull/25365))**

- **(NFC) Speed up random tests by 55-60%
  ([25439](https://github.com/civicrm/civicrm-core/pull/25439))**

- **[NFC] Incorrect docblock in
  CRM_Contribute_PseudoConstant::contributionPage()
  ([25398](https://github.com/civicrm/civicrm-core/pull/25398))**

- **CiviTestListener - Headless tests should initialize timezone
  ([25534](https://github.com/civicrm/civicrm-core/pull/25534))**

- **(NFC) Mixin Tests - Add more type-hints
  ([25384](https://github.com/civicrm/civicrm-core/pull/25384))**

- **NFC superficial prelminary cleanup in test class
  ([25333](https://github.com/civicrm/civicrm-core/pull/25333))**

- **[NFC] Test classname should match filename
  ([25283](https://github.com/civicrm/civicrm-core/pull/25283))**

- **[NFC] Remove broken test
  ([25279](https://github.com/civicrm/civicrm-core/pull/25279))**

- **(NFC) Reference classes with correct case
  ([25295](https://github.com/civicrm/civicrm-core/pull/25295))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; BrightMinded Ltd - Bradley Taylor;
Christian Wach; Circle Interactive - Pradeep Nayak; CiviCRM - Coleman Watts,
Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy; Dave D;
Freeform Solutions - Herb van den Dool; jmacarthur98; JMA Consulting - Monish
Deb, Seamus Lee; John Kingsnorth; Megaphone Technology Consulting - Jon
Goldberg; Michael-Labriola; MJW Consulting - Matthew Wire; Progressive
Technology Project - Jamie McClelland; redcuillin; Squiffle Consulting - Aidan
Saunders; Stephen Palmstrom; SYSTOPIA - Johannes Franz; Tadpole Collective -
Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton; Wildsight - Lars
Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Australian Greens - Andrew Cormick-Dockery; Betty
Dolfing; CiviCoop - Klaas Eikelboom; JMA Consulting - Joe Murray; Nicol
Wistreich

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
