# CiviCRM 5.57.0

Released January 4, 2023

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |
| **Fix security vulnerabilities?**                               | **yes** |

## <a name="security"></a>Security advisories

* **[CIVI-SA-2023-01](https://civicrm.org/advisory/civi-sa-2023-01-help-subsystem-rce): RCE via Help Subsystem**
* **[CIVI-SA-2023-02](https://civicrm.org/advisory/civi-sa-2023-02-civievent-xss): XSS via CiviEvent**
* **[CIVI-SA-2023-03](https://civicrm.org/advisory/civi-sa-2023-03-asset-builder-xss): XSS via Asset Builder**

## <a name="features"></a>Features

### Core CiviCRM

- **APIv4 Autocomplete - Support searching by ID, customize some entities
  ([24976](https://github.com/civicrm/civicrm-core/pull/24976))**

  Brings the new APIv4 Autocomplete widget up to the level of the v3
  EntityRef, and in several ways surpasses it.

- **Use APIv4-based Autocomplete widget throughout SearchKit, Afform & API
  Explorer ([24974](https://github.com/civicrm/civicrm-core/pull/24974) and
  [25111](https://github.com/civicrm/civicrm-core/pull/25111))**

  Switches APIv4-based UIs to consistently use the new Autocomplete widget
  instead of the old v3-based entityRef.

- **default token filter
  ([25031](https://github.com/civicrm/civicrm-core/pull/25031))**

  Adds a token filter of "default", ex:
  {civicrm_membership.name|default:"Not a member"} will default to "Not a
  Member".

- **Update location tokens for Contact to new apiv4 style
  ([25032](https://github.com/civicrm/civicrm-core/pull/25032))**

  Migrates location tokens for contacts to use the APIv4 style.

- **Bool token formatting
  ([dev/core#3962](https://lab.civicrm.org/dev/core/-/issues/3962):
  [24923](https://github.com/civicrm/civicrm-core/pull/24923))**

  Adds 'boolean' as a filter for tokens ex:
  `{if {contact.current_employer|bool}} ({contact.current_employer}){/if}`.

- **improve social sharing footer
  ([25003](https://github.com/civicrm/civicrm-core/pull/25003))**

  Improves Social Sharing footer text.

- **Use domain id in log file name making it easy to find correct log file
  ([dev/core#3136](https://lab.civicrm.org/dev/core/-/issues/3136):
  [24893](https://github.com/civicrm/civicrm-core/pull/24893))**

  Improves logging by incorporating the domain id.

- **Add entity-types-php mixin
  ([24947](https://github.com/civicrm/civicrm-core/pull/24947))**

  Adds a new mixin to scan for entity types that civix could be adapted to
  take advantage of it.

- **Expose created date column in contact reports
  ([dev/core#3992](https://lab.civicrm.org/dev/core/-/issues/3992):
  [24978](https://github.com/civicrm/civicrm-core/pull/24978))**

  Adds "Created Date" as a column option for contact reports.

- **Add Validate and Import search kit actions to import search displays
  ([24821](https://github.com/civicrm/civicrm-core/pull/24821))**

  Adds validate and import SearchKit actions to import search displays.

- **Make SearchKit Required
  ([24739](https://github.com/civicrm/civicrm-core/pull/24739))**

  Makes it so SearchKit cannot be disabled.

- **SearchKit - Add enable/disable tasks
  ([25084](https://github.com/civicrm/civicrm-core/pull/25084))**

  Adds enable and disable tasks (when relevant) to SearchKit.

- **SearchKit - Include html columns in spreadsheet download
  ([25126](https://github.com/civicrm/civicrm-core/pull/25126))**

  Adds html-type columns to SearchKit spreadsheet downloads, by formatting them as
  plain text.

- **SearchKit displays: be able to add description so end user knows the context
  ([dev/core#3980](https://lab.civicrm.org/dev/core/-/issues/3980):
  [24985](https://github.com/civicrm/civicrm-core/pull/24985) and
  [24942](https://github.com/civicrm/civicrm-core/pull/24942))**

  Exposes SavedSearch descriptions in SearchKit to admins.

- **SearchKit - Add clone button for search displays
  ([24899](https://github.com/civicrm/civicrm-core/pull/24899))**

  Adds a clone button to easily make a copy of a search display.

- **Hide deprecated fields from SearchKit & Afform
  ([25113](https://github.com/civicrm/civicrm-core/pull/25113))**

  Hides any fields marked @deprecated from the SearchKit & Afform UI.

- **Afform - Support ContactType-specific tabs and blocks
  ([25069](https://github.com/civicrm/civicrm-core/pull/25069))**

  Allows one to create Contact Type specific tabs and blocks in Afform.

- **Afform - relationships fill from other entity
  ([dev/core#3453](https://lab.civicrm.org/dev/core/-/issues/3453):
  [25001](https://github.com/civicrm/civicrm-core/pull/25001))**

  Enables contacts to be auto-loaded on Afforms based on their relationships to
  other contacts.

- **Afform - Customizable APIv4-based Autocomplete widget for EntityRef fields
  ([24832](https://github.com/civicrm/civicrm-core/pull/24832))**

  Switches all Afform EntityRef fields to use the new APIv4-based Autocomplete
  widget.

- **Support multiple contact_type in hook_civicrm_tabset
  ([25101](https://github.com/civicrm/civicrm-core/pull/25101))**

  Improves `hook_civicrm_tabset` to support an array of contact types for each
  tab on the contact summary page.

- **Adding better translation for ThankYou page tpl for recurring messaging
  ([25068](https://github.com/civicrm/civicrm-core/pull/25068))**

  Improves translation of the thank you page template.

- **Add FormBuilder forms to Civiimport
  ([25072](https://github.com/civicrm/civicrm-core/pull/25072))**

  Makes Civiimport forms embeddable.

- **Create MVP UI for imports when background queue processing is taking place
  ([25041](https://github.com/civicrm/civicrm-core/pull/25041))**

  Creates a UI for imports when background queue processing is taking place.

- **Use search display to view errors when using Civi-import extension
  ([25038](https://github.com/civicrm/civicrm-core/pull/25038))**

  Replaces the link to download the csv with a link to view the search display
  if civiimport is enabled, allowing re-doing the import within the UI.

- **Add Imports search
  ([25081](https://github.com/civicrm/civicrm-core/pull/25081))**

  Adds a user interface to search imports.

- **Add 'my imports' to Reports navigation (in civimport extension)
  ([25086](https://github.com/civicrm/civicrm-core/pull/25086))**

  Adds a new link to the Navigation bar for sites with the civiimport extension:
  "my imports".

- **Turn 'From' dropdown in 'Send Email' into a searchable select2
  ([24957](https://github.com/civicrm/civicrm-core/pull/24957))**

  Improves the user experience of the "Send Email" form by making the "From"
  dropdown a searchable select2.

### CiviCase

- **Migrate case activity revisions to trigger-based logging
  (Work Towards [dev/core#1532](https://lab.civicrm.org/dev/core/-/issues/1532):
  [25119](https://github.com/civicrm/civicrm-core/pull/25119))**

  Makes Activity revisions unselectable to be filterable in UI and adds an
  upgrade message regarding case activity changes.

### CiviEvent

- **add event entity to formbuilder
  ([24991](https://github.com/civicrm/civicrm-core/pull/24991))**

  Makes the `Event` entity available in Afform.

- **Make it clear that same email for event registrations allows multiple
  registrations per contact
  ([24649](https://github.com/civicrm/civicrm-core/pull/24649))**

  Changes the field label text for the event setting option "Same email
  address?" to "Allow same email and multiple registrations?"

### CiviMail

- **Make flexmailer mandatory
  ([25110](https://github.com/civicrm/civicrm-core/pull/25110))**

  Makes the `flexmailer` extension required by default.

- **Messagetemplate schema changes
  ([24992](https://github.com/civicrm/civicrm-core/pull/24992))**

  Makes the 'MessageTemplate' entity available in APIv4.

- **Adding mailing events (unsub, open, clicks, etc) to API4 (Work Towards
  [dev/core#3965](https://lab.civicrm.org/dev/core/-/issues/3965):
  [25059](https://github.com/civicrm/civicrm-core/pull/25059) and
  [25056](https://github.com/civicrm/civicrm-core/pull/25056))**

  Adds Mailing entities to APIv4 and makes MessageTemplate.master_id fully
  joinable.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **APIv3 - Use the Exception rather than the rule
  ([24977](https://github.com/civicrm/civicrm-core/pull/24977))**

  Converts APIv3 in Smarty and Ajax to use exceptions instead of
  `CRM_Core_TemporaryErrorScope`.

- **OptionValues & search kit - missing metadata?
  (Work Towards [dev/core#3921](https://lab.civicrm.org/dev/core/-/issues/3921):
  [24984](https://github.com/civicrm/civicrm-core/pull/24984),
  [24990](https://github.com/civicrm/civicrm-core/pull/24990),
  [24967](https://github.com/civicrm/civicrm-core/pull/24967),
  [24969](https://github.com/civicrm/civicrm-core/pull/24969),
  [24968](https://github.com/civicrm/civicrm-core/pull/24968) and
  [24970](https://github.com/civicrm/civicrm-core/pull/24970))**

  Adds html definition to schema for is_active and default field.

- **Support ES6 (2015) in civilint: jshint config update
  ([24975](https://github.com/civicrm/civicrm-core/pull/24975))**

  Fixes errors on ES6 code in civilint.

- **Can't search contact with only number
  ([dev/core#3735](https://lab.civicrm.org/dev/core/-/issues/3735):
  [24727](https://github.com/civicrm/civicrm-core/pull/24727))**

  Fixes getlist retrieve with id.

- **Evaluate if any indexed fields are unused
  (Work Towards [dev/core#1634](https://lab.civicrm.org/dev/core/-/issues/1634):
  [25112](https://github.com/civicrm/civicrm-core/pull/25112))**

  Deprecates unused activity columns.

- **Example data leaks from the live database
  ([dev/core#3981](https://lab.civicrm.org/dev/core/-/issues/3981):
  [24945](https://github.com/civicrm/civicrm-core/pull/24945))**

  Fixes examples to use 0 rather than a possibly-real contact_id.

- **Add default label field for RelationshipType entity
  ([25021](https://github.com/civicrm/civicrm-core/pull/25021))**

  Fixes a bug in Afform that prevents relationships from being created.

- **[documentation] fileinfo PHP extension not listed as requirement
  ([dev/core#4014](https://lab.civicrm.org/dev/core/-/issues/4014):
  [25115](https://github.com/civicrm/civicrm-core/pull/25115))**

  Adds ext-fileinto php extension to composer.

- **Symfony 4.3+: CI warnings due to change in EventDispatcherInterface
  ([dev/core#2316](https://lab.civicrm.org/dev/core/-/issues/2316):
  [24132](https://github.com/civicrm/civicrm-core/pull/24132))**

- **Remove unsupported reCAPTCHA options
  ([dev/core#4020](https://lab.civicrm.org/dev/core/-/issues/4020):
  [25098](https://github.com/civicrm/civicrm-core/pull/25098))**

- **SearchKit - Fix crashy-ness when an Afform contains a deleted search
  ([25091](https://github.com/civicrm/civicrm-core/pull/25091))**

- **SearchKit - Fix campaign, event & primary address dropdowns
  ([24963](https://github.com/civicrm/civicrm-core/pull/24963))**

- **SearchKit - Fix Campaign, State, Country selectors (again)
  ([25053](https://github.com/civicrm/civicrm-core/pull/25053))**

- **SearchKit - Fix option loading & rendering for in-place edit
  ([25197](https://github.com/civicrm/civicrm-core/pull/25197))**

- **SearchKit - Fix display count when updating items on the last page
  ([24987](https://github.com/civicrm/civicrm-core/pull/24987))**

- **afform/oauth-client - don't call stat on null
  ([25035](https://github.com/civicrm/civicrm-core/pull/25035))**

- **Afform - Fix multivalue entityRef fields
  ([24966](https://github.com/civicrm/civicrm-core/pull/24966))**

- **Avoid symbol scan errors in oauth-client help text
  ([24998](https://github.com/civicrm/civicrm-core/pull/24998))**

- **Add handling to token processor for double http in url tokens
  ([25078](https://github.com/civicrm/civicrm-core/pull/25078))**

- **FieldSpec - Generate better default field titles for DAOs
  ([25080](https://github.com/civicrm/civicrm-core/pull/25080))**

- **Log API Authorization failed errors
  ([25030](https://github.com/civicrm/civicrm-core/pull/25030))**

- **Apiv4 Explorer DashboardContact doesn't load dashboards
  ([dev/core#4021](https://lab.civicrm.org/dev/core/-/issues/4021):
  [25099](https://github.com/civicrm/civicrm-core/pull/25099))**

- **APIv4 - Always allow anonymous autocomplete action access
  ([24980](https://github.com/civicrm/civicrm-core/pull/24980))**

- **Fix Import summary to differentiate between 'valid' and 'imported'
  ([25040](https://github.com/civicrm/civicrm-core/pull/25040))**

- **add legend to CMS user creation section
  ([25002](https://github.com/civicrm/civicrm-core/pull/25002))**

- **Allow Joinables to be added to tables without specifying a base column
  ([24993](https://github.com/civicrm/civicrm-core/pull/24993))**

- **AdminUI - Always cleanup saved searches during uninstall
  ([24760](https://github.com/civicrm/civicrm-core/pull/24760))**

- **Fix Relationship to permit disabled relationships as duplicates & fix test
  ([25047](https://github.com/civicrm/civicrm-core/pull/25047))**

- **Fix api handling of OptionValue defaults
  ([24938](https://github.com/civicrm/civicrm-core/pull/24938))**

- **fix numfmt error when pager limit is set in Civi settings
  ([25070](https://github.com/civicrm/civicrm-core/pull/25070))**

- **Pass correct variable type to the hook
  ([25046](https://github.com/civicrm/civicrm-core/pull/25046))**

- **Do not `set` cache in cache-bypass mode, since we are bypassing `get`
  ([25073](https://github.com/civicrm/civicrm-core/pull/25073))**

- **Fix CiviCRM Home/Hide/Logout translation
  ([25000](https://github.com/civicrm/civicrm-core/pull/25000))**

- **Fix query to use standard `CRM_Core_DAO::executeQuery`
  ([25075](https://github.com/civicrm/civicrm-core/pull/25075))**

- **Don't allow selection of deleted contacts as email recipients
  ([24898](https://github.com/civicrm/civicrm-core/pull/24898))**

- **FourSeven Upgrade: disable i18nrewrite to avoid multilingual fatal
  ([24960](https://github.com/civicrm/civicrm-core/pull/24960))**

- **always define showCMS
  ([25125](https://github.com/civicrm/civicrm-core/pull/25125))**

- **Use fastArray cache for js_strings
  ([24989](https://github.com/civicrm/civicrm-core/pull/24989))**

- **(alternate) Sentence runs together since period is inside the if block
  ([25005](https://github.com/civicrm/civicrm-core/pull/25005))**

- **Don't crash ContributionView when participant fields are null
  ([24906](https://github.com/civicrm/civicrm-core/pull/24906))**

- **Fix PHP Notice: Undefined offset in _civicrm_member_roles_sync()
  ([661](https://github.com/civicrm/civicrm-drupal/pull/661))**

- **Menubar - Fix buggy, slow loader
  ([25012](https://github.com/civicrm/civicrm-core/pull/25012))**

- **Stop using single hard-coded value array
  (clean up from previous refactors)
  ([25137](https://github.com/civicrm/civicrm-core/pull/25137))**

- **ensure currency is included to avoid translation problems
  ([24798](https://github.com/civicrm/civicrm-core/pull/24798))**

- **Fix enotice on user dash - when user has membership/s & debugging enabled
  ([25140](https://github.com/civicrm/civicrm-core/pull/25140))**

- **Fix 'cannot determine default entity' error on New Batch page
  ([25189](https://github.com/civicrm/civicrm-core/pull/25189))**

- **Nested tags are not showing under some circumstances
  ([dev/core#4049](https://lab.civicrm.org/dev/core/-/issues/4049):
  [25272](https://github.com/civicrm/civicrm-core/pull/25272))**

### CiviCase

- **Only show File Activity on Case success alert for 10 seconds
  ([24905](https://github.com/civicrm/civicrm-core/pull/24905))**

### CiviContribute

- **fixes dash line appended to the contribution amounts if label is empty
  ([25033](https://github.com/civicrm/civicrm-core/pull/25033))**

- **Assigning to accounting batch and closing batch fails with javascript error
  ([dev/core#3960](https://lab.civicrm.org/dev/core/-/issues/3960):
  [25129](https://github.com/civicrm/civicrm-core/pull/25129))**

- **Import contribution fails in update mode even if contribution id is
  provided. ([dev/core#4038](https://lab.civicrm.org/dev/core/-/issues/4038):
  [25204](https://github.com/civicrm/civicrm-core/pull/25204))**

- **Payment processor handling of `billing-country-5` inconsistent
  ([dev/core#3977](https://lab.civicrm.org/dev/core/-/issues/3977):
  [24927](https://github.com/civicrm/civicrm-core/pull/24927))**

- **Crash when viewing contact's contribution tab and a contribution has no line
  items ([dev/core#4027](https://lab.civicrm.org/dev/core/-/issues/4027):
  [25145](https://github.com/civicrm/civicrm-core/pull/25145))**

- **Invoices have started miscalculating on save in version 5.56.0, rounding
  down quantities
  ([dev/core#4039](https://lab.civicrm.org/dev/core/-/issues/4039):
  [25213](https://github.com/civicrm/civicrm-core/pull/25213))**

### CiviMail

- **Flexmailer: Prevent broken urls containing hyphens when click tracking is
  enabled for plain text mailings
  ([25149](https://github.com/civicrm/civicrm-core/pull/25149))**

### Drupal Integration

- **Menubar - fix height of quicksearch (Drupal9)
  ([25010](https://github.com/civicrm/civicrm-core/pull/25010))**

- **Notice: Undefined variable: custom_link in
  civicrm_handler_field_link_contact->render_link() (line 118 of
  civicrm/drupal/modules/views/civicrm/civicrm_handler_field_link_contact.inc).
  ([dev/drupal#168](https://lab.civicrm.org/dev/drupal/-/issues/168#note_85146):
  [660](https://github.com/civicrm/civicrm-drupal/pull/660))**

### WordPress Integration

- **Allow multiple non-invoking Shortcodes to render
  ([281](https://github.com/civicrm/civicrm-wordpress/pull/281))**

## <a name="misc"></a>Miscellany

- **EntityFinancialAccount - A tale of two BAO classes
  ([25036](https://github.com/civicrm/civicrm-core/pull/25036))**

- **Simplify removing file extension when using basename function
  ([24948](https://github.com/civicrm/civicrm-core/pull/24948))**

- **Add new Organization Example contact (The Daily Bugle)
  ([24939](https://github.com/civicrm/civicrm-core/pull/24939))**

- **Raise priority of Base Page `the_content` callback
  ([282](https://github.com/civicrm/civicrm-wordpress/pull/282))**

- **Cast membership object as array before passing to
  getMembershipStatusByDate()
  ([25139](https://github.com/civicrm/civicrm-core/pull/25139))**

- **getSiteStats - Use consistent report format
  ([25158](https://github.com/civicrm/civicrm-core/pull/25158))**

- **Duplicate `Activity::importableFields` to upgrader & increase deprecation
  ([25088](https://github.com/civicrm/civicrm-core/pull/25088))**

- **ajax batchSave() method should be static, php8 compatibility
  ([25029](https://github.com/civicrm/civicrm-core/pull/25029))**

- **SearchKit - Minor wording change
  ([25071](https://github.com/civicrm/civicrm-core/pull/25071))**

- **SearchKit - Fix unit test so sort param actually does something
  ([25133](https://github.com/civicrm/civicrm-core/pull/25133))**

- **Fold `processGreetingTemplate` function only called from one place into
  caller, deprecate
  ([24925](https://github.com/civicrm/civicrm-core/pull/24925))**

- **Core extensions - Upgrade to civix 22.10.0
  ([24944](https://github.com/civicrm/civicrm-core/pull/24944))**

- **[php 8] Update pear/mail to 1.5
  ([25092](https://github.com/civicrm/civicrm-core/pull/25092))**

- **Add noisy deprecation to `getContactTokenReplacement`
  ([25077](https://github.com/civicrm/civicrm-core/pull/25077))**

- **Add noisy deprecation to deprecated contribution token functions
  ([25050](https://github.com/civicrm/civicrm-core/pull/25050))**

- **Deprecate `CRM_Mailing_BAO_MailingAB::del()`
  ([25024](https://github.com/civicrm/civicrm-core/pull/25024))**

- **Deprecate `CRM_Financial_BAO_EntityFinancialAccount::del()`
  ([25026](https://github.com/civicrm/civicrm-core/pull/25026) and
  [25082](https://github.com/civicrm/civicrm-core/pull/25082))**

- **Add noisy deprecation to unused functions `replaceContactTokens`,
  `replaceCaseTokens`
  ([24933](https://github.com/civicrm/civicrm-core/pull/24933))**

- **CRM_Utils_System_WordPress - Drop unused variable
  ([25132](https://github.com/civicrm/civicrm-core/pull/25132))**

- **CiviMail - BAO files were renamed in core
  ([285](https://github.com/civicrm/civicrm-wordpress/pull/285))**

- **Mailing - Rename DAO files for better short names
  ([24982](https://github.com/civicrm/civicrm-core/pull/24982))**

- **added contributor Sebastian Lisken
  ([24914](https://github.com/civicrm/civicrm-core/pull/24914))**

- **Var type fix in comment
  ([25011](https://github.com/civicrm/civicrm-core/pull/25011))**

- **More del() deprecations in favour of standard deleteRecord()
  ([25006](https://github.com/civicrm/civicrm-core/pull/25006))**

- **More BAO `del()` deprecations
  ([25019](https://github.com/civicrm/civicrm-core/pull/25019))**

- **Use IP address helper method consistently
  ([25065](https://github.com/civicrm/civicrm-core/pull/25065))**

- **Regenerate ContactType DAO
  ([25079](https://github.com/civicrm/civicrm-core/pull/25079))**

- **Regenerate Country DAO
  ([24946](https://github.com/civicrm/civicrm-core/pull/24946))**

- **Regen DAO
  ([24979](https://github.com/civicrm/civicrm-core/pull/24979))**

- **DAOs are stale
  ([25043](https://github.com/civicrm/civicrm-core/pull/25043))**

- **Remove unused private function `removeNullContactTokens`
  ([24932](https://github.com/civicrm/civicrm-core/pull/24932))**

- **TabHeader: remove redundant history.replaceState
  ([24931](https://github.com/civicrm/civicrm-core/pull/24931))**

- **Remove noisly deprecated function PDFLetterCommon::postProcess
  ([25108](https://github.com/civicrm/civicrm-core/pull/25108))**

- **Remove always-true ifs
  ([25136](https://github.com/civicrm/civicrm-core/pull/25136))**

- **remove unused template vars from Profile Form
  ([25124](https://github.com/civicrm/civicrm-core/pull/25124))**

- **remove civimail-spooler script
  ([25122](https://github.com/civicrm/civicrm-core/pull/25122))**

- **Remove unused, deprecated class `CRM_Activity_Form_Task_PDFLetterCommon`
  ([25106](https://github.com/civicrm/civicrm-core/pull/25106))**

- **Remove further usage of 'preferred_mail_format'
  ([25109](https://github.com/civicrm/civicrm-core/pull/25109))**

- **Remove handling for legacy `preferred_mail_format`
  ([25076](https://github.com/civicrm/civicrm-core/pull/25076))**

- **Remove deprecated PdfLetterCommon class - membership
  ([25060](https://github.com/civicrm/civicrm-core/pull/25060))**

- **Remove deprecated, probably long-broken function `replaceOrgTokens`
  ([25051](https://github.com/civicrm/civicrm-core/pull/25051))**

- **remove unused code in Profile template
  ([25121](https://github.com/civicrm/civicrm-core/pull/25121))**

- **Remove php8-specific coding pattern
  ([24952](https://github.com/civicrm/civicrm-core/pull/24952))**

- **Remove legacyCreateMultiple function
  ([25048](https://github.com/civicrm/civicrm-core/pull/25048))**

- **Remove another call to deprecated
  `CRM_Contribute_PseudoConstant::contributionStatus`
  ([24590](https://github.com/civicrm/civicrm-core/pull/24590))**

- **Remove deprecated token function
  ([25049](https://github.com/civicrm/civicrm-core/pull/25049))**

- **Remove deprecated token function `replaceComponentTokens`
  ([24934](https://github.com/civicrm/civicrm-core/pull/24934))**

- **Deprecate `CRM_Event_BAO_Event::del()` in favour of `deleteRecord()`
  ([25018](https://github.com/civicrm/civicrm-core/pull/25018))**

- **Deprecate `CRM_Contact_BAO_Relationship::del()` in favour of
  `deleteRecord()`
  ([25017](https://github.com/civicrm/civicrm-core/pull/25017))**

- **php8 - don't pass null as string
  ([25007](https://github.com/civicrm/civicrm-core/pull/25007))**

- **PHP 8.1 ([dev/core#3181](https://lab.civicrm.org/dev/core/-/issues/3181):
  [284](https://github.com/civicrm/civicrm-wordpress/pull/284) and
  [24915](https://github.com/civicrm/civicrm-core/pull/24915))**

- **[REF][PHP8.2] Fix Pager Common and Smarty issue with Dynamic properties in
  php8.2 ([355](https://github.com/civicrm/civicrm-packages/pull/355))**

- **[REF][PHP8.1] Fix a couple of issues where passing in NULL in string
  functions is deprecated in PHP8.1
  ([24911](https://github.com/civicrm/civicrm-core/pull/24911))**

- **REF: Replace CRM_Utils_Array::value in CRM/Event/Form/Registration
  ([25042](https://github.com/civicrm/civicrm-core/pull/25042))**

- **[REF] ContactType BAO - Simplify getAllContactTypes
  ([25064](https://github.com/civicrm/civicrm-core/pull/25064))**

- **REF: Consistent variables names in formRule for CRM/Event/Form/Register
  ([25045](https://github.com/civicrm/civicrm-core/pull/25045))**

- **[REF] Fix E2E_Core_ErrorTest on wordpress-clean builds
  ([24913](https://github.com/civicrm/civicrm-core/pull/24913))**

- **[REF] Unused vars in the State Machine
  ([24901](https://github.com/civicrm/civicrm-core/pull/24901))**

- **[REF] OptionValue - Deprecate del() function in favor of standard
  deleteRecord ([24999](https://github.com/civicrm/civicrm-core/pull/24999))**

- **[REF] DAO - Use class_alias for aliases of renamed classes
  ([24983](https://github.com/civicrm/civicrm-core/pull/24983))**

- **Fix miscoordination between CiviUnitTestCase/CiviEnvBuilder. Fix flaky
  ConformanceTest.
  ([25177](https://github.com/civicrm/civicrm-core/pull/25177))**

- **Fix test class not to use discouraged function
  ([25074](https://github.com/civicrm/civicrm-core/pull/25074))**

- **Test cleanup, remove calls to deprecated financial BAO functions
  ([25085](https://github.com/civicrm/civicrm-core/pull/25085))**

- **PriceSetTest - Fix test-run on case-insensitive filesystem
  ([24892](https://github.com/civicrm/civicrm-core/pull/24892))**

- **Add tests for importing county (includes adding v4 County api)
  ([24919](https://github.com/civicrm/civicrm-core/pull/24919))**

- **SearchKit - Add unit test for multivalued custom fields
  ([24941](https://github.com/civicrm/civicrm-core/pull/24941))**

- **Test fix - setup is incongruent
  ([25037](https://github.com/civicrm/civicrm-core/pull/25037))**

- **Cleanup in test class
  ([25022](https://github.com/civicrm/civicrm-core/pull/25022))**

- **Test cleanup, stop using legacy financial bao methods
  ([25083](https://github.com/civicrm/civicrm-core/pull/25083))**

- **Rename test class to reflect tested class
  ([25107](https://github.com/civicrm/civicrm-core/pull/25107))**

- **Further cleanup on JobTest
  ([24935](https://github.com/civicrm/civicrm-core/pull/24935))**

- **CRM_Utils_FileTest - Fix compatibility with private data folders
  ([25160](https://github.com/civicrm/civicrm-core/pull/25160))**

- **[NFC] Update instructions for running regen online
  ([25138](https://github.com/civicrm/civicrm-core/pull/25138))**

- **[NFC] UtilsTest - convert EventDispatcher to CiviEventDispatcher
  ([25013](https://github.com/civicrm/civicrm-core/pull/25013))**

- **[NFC] Allow running tests/phpunit/CRM/Core/DAOTest.php on mariadb
  ([25008](https://github.com/civicrm/civicrm-core/pull/25008))**

- **[NFC] Regression - lotsa noise on Searchkit screen if Form code editor
  enabled ([dev/core#4008](https://lab.civicrm.org/dev/core/-/issues/4008):
  [25131](https://github.com/civicrm/civicrm-core/pull/25131))**

- **[NFC] Add @since annotation
  ([24958](https://github.com/civicrm/civicrm-core/pull/24958))**

- **[NFC] Clean up in test class
  ([24922](https://github.com/civicrm/civicrm-core/pull/24922))**

- **[NFC] Minor cleanup in test
  ([24921](https://github.com/civicrm/civicrm-core/pull/24921))**

- **[NFC] Test class cleanup (JobTest)
  ([24920](https://github.com/civicrm/civicrm-core/pull/24920))**

- **[NFC] Update testGetSiteStats to match earlier name change
  ([25150](https://github.com/civicrm/civicrm-core/pull/25150))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; BrightMinded Ltd - Bradley Taylor;
Christian Wach; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
civiservice.de - Sebastian Lisken; Coop SymbioTIC - Mathieu Lutfy, Shane Bill;
Dave D; Craft Coders - Sebastian Gellweiler; Humanists UK - Andrew West; JMA
Consulting - Monish Deb, Seamus Lee; John Kingsnorth; Luna Design - Andrew
Wasson; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; Progressive Technology Project - Jamie McClelland; Squiffle
Consulting - Aidan Saunders; Third Sector Design - Kurund Jalmi; Wikimedia
Foundation - Eileen McNaughton; Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Artful Robot - Rich Lott; Australian Greens -
Andrew Cormick-Dockery; Circle Interactive - Dave Jenkins; Freeform Solutions -
Herb van den Dool; Nicol Wistreich; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
