# CiviCRM 4.7.24

Released September 6, 2017

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                     |         |
|:----------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                               |   No    |
| **Change the database schema?**                             | **Yes** |
| **Alter the API?**                                          | **Yes** |
| Require attention to configuration options?                 |   No    |
| Fix problems installing or upgrading to a previous version? |   No    |
| **Introduce features?**                                     | **Yes** |
| **Fix bugs?**                                               | **Yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-20941](https://issues.civicrm.org/jira/browse/CRM-20941) Determine &
  notify date to end support for PHP5.3 and PHP5.4
  ([10948](https://github.com/civicrm/civicrm-core/pull/10948) and
  [10872](https://github.com/civicrm/civicrm-core/pull/10872))**

  Updated upgrade message text regarding support for PHP5.3 and PHP5.4

- **[CRM-20960](https://issues.civicrm.org/jira/browse/CRM-20960) Upgrade Dompdf
  to 0.8 ([10751](https://github.com/civicrm/civicrm-core/pull/10751))**

  Civicrm now uses dompdf to 0.8 which is compatible with PHP 7.1.

- **[CRM-20563](https://issues.civicrm.org/jira/browse/CRM-20563) Improve
  'unable to provide this...' error message
  ([10340](https://github.com/civicrm/civicrm-core/pull/10340))**

  The "Sorry but we are not able to provide this at the moment." error message
  is improved to be more descriptive.  It now says "Sorry, due to an error,
  CiviCRM is unable to fulfill your request at the moment. You may want to
  contact your administrator or service provider with more details about when
  this occurred."

- **[CRM-20929](https://issues.civicrm.org/jira/browse/CRM-20929) Allow styling
  of page title in Angular
  ([10711](https://github.com/civicrm/civicrm-core/pull/10711))**

  This change conveys CSS classes from Angular `crm-page-title` elements to the
  main page title for styling purposes.

- **[CRM-20945](https://issues.civicrm.org/jira/browse/CRM-20945) Differentiate
  using CSS active selected page in AtoZ Pager
  ([10723](https://github.com/civicrm/civicrm-core/pull/10723))**

  Now when using the A to Z pager (searching alphabetically) the active selected
  page is differentiated from the other pages listed.

- **[CRM-20863](https://issues.civicrm.org/jira/browse/CRM-20863) Improve
  ordering of report lists
  ([10653](https://github.com/civicrm/civicrm-core/pull/10653))**

  If reports have the same weight they will now be ordered alphabetically by
  title ascending.

- **[CRM-20994](https://issues.civicrm.org/jira/browse/CRM-20994)
  CurrentEmployer Report contains a hardcoded value for RelationshipType
  ([10795](https://github.com/civicrm/civicrm-core/pull/10795))**

  Changes Current Employer Report to get Employee Relationship type from the API
  instead of a hardcoded value of the ID `4`.

- **[CRM-21012](https://issues.civicrm.org/jira/browse/CRM-21012) Add link to
  release notes in CiviCRM footer
  ([10807](https://github.com/civicrm/civicrm-core/pull/10807))**

  The version number in the footer now links to the release notes for that
  version.

### CiviContribute

- **[CRM-20610](https://issues.civicrm.org/jira/browse/CRM-20610) Replace
  payment details block with editable payment list on 'Edit Contribution' form
  ([10814](https://github.com/civicrm/civicrm-core/pull/10814),
  [10806](https://github.com/civicrm/civicrm-core/pull/10806),
  [10777](https://github.com/civicrm/civicrm-core/pull/10777), and
  [10774](https://github.com/civicrm/civicrm-core/pull/10774)) (Initial Work)**

  Updates the user experience for partial payments for events, memberships and
  contributions on entry, editing and display.

- **[CRM-20890](https://issues.civicrm.org/jira/browse/CRM-20890) Move
  recieve_date between Contribution status and Revenue Recognition date in
  Contribution backoffice form
  ([10682](https://github.com/civicrm/civicrm-core/pull/10682))**

  This change moves the placement of fields on the backend contribution form to
  enhance user experience.

- **[CRM-20984](https://issues.civicrm.org/jira/browse/CRM-20984) Move placement
  of payment processor field on live mode
  ([10787](https://github.com/civicrm/civicrm-core/pull/10787))**

  This change moves the payment processor selection field on the backend credit
  card contribution form.  It is now closer to the billing block.

- **[CRM-20860](https://issues.civicrm.org/jira/browse/CRM-20860) Add in
  password type field availability and apply to payment processor fields
  ([10660](https://github.com/civicrm/civicrm-core/pull/10660))**

  QuickForm now allows for a `password` type field to be added to forms. This
  new field type is also applied to the Payment Processor Password fields for
  security purposes.

- **[CRM-20876](https://issues.civicrm.org/jira/browse/CRM-20876) in honor of
  does not show up on contribution receipt
  ([10668](https://github.com/civicrm/civicrm-core/pull/10668))**

  Now, When making a contribution in honor of someone, the person who is being
  honored shows up on the receipt.

- **[CRM-20931](https://issues.civicrm.org/jira/browse/CRM-20931) Allow contact
  custom fields to be added to Contribution Detail report
  ([10713](https://github.com/civicrm/civicrm-core/pull/10713))**

  Now one can add contact custom fields to the Contribution Detail report.

- **[CRM-20987](https://issues.civicrm.org/jira/browse/CRM-20987) Add
  transaction date field to listings of transactions
  ([10789](https://github.com/civicrm/civicrm-core/pull/10789))**

  On the Financial batch listing page, the "Received" column is now labeled
  "Transaction Date", and a new "Received" column, derived from
  `civicrm_contribution.receive_date`, is displayed.

- **[CRM-20913](https://issues.civicrm.org/jira/browse/CRM-20913) Separate
  pledge statuses from contribution statuses
  ([10811](https://github.com/civicrm/civicrm-core/pull/10811),
  [10803](https://github.com/civicrm/civicrm-core/pull/10803), and
  [10737](https://github.com/civicrm/civicrm-core/pull/10737))**

  Creates a new option group for pledge status for pledges to use.  Previously,
  pledges were using contribution statuses.

### CiviMail

- **[CRM-20521](https://issues.civicrm.org/jira/browse/CRM-20521) Convert list
  of groups and mailings in CiviMail to be loaded dynamically
  ([10303](https://github.com/civicrm/civicrm-core/pull/10303))**

  This change converts list of groups and mailings in CiviMail to be loaded
  dynamically to improve performance.

### CiviMember

- **[CRM-20321](https://issues.civicrm.org/jira/browse/CRM-20321) Changing
  membership type should change related contribution
  ([10699](https://github.com/civicrm/civicrm-core/pull/10699))**

  A new option ties the financial type of a membership payment contribution to the
  membership type of its related membership.  When that membership type gets
  changed and the option is set, the contribution's financial type changes.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-21135](https://issues.civicrm.org/jira/browse/CRM-21135) Activity
  filter preference are not remembered when enabled in display preference
  ([10932](https://github.com/civicrm/civicrm-core/pull/10932))**

- **[CRM-21076](https://issues.civicrm.org/jira/browse/CRM-21076) Fix: Can't
  view/edit ACL Role Assignments
  ([10869](https://github.com/civicrm/civicrm-core/pull/10869))**

- **Suppress error if fakeFile cannot be created.
  ([10677](https://github.com/civicrm/civicrm-core/pull/10677))**

- **[CRM-20947](https://issues.civicrm.org/jira/browse/CRM-20947) Remove
  Deprecation Notice for Option group
  ([10788](https://github.com/civicrm/civicrm-core/pull/10788),
  [10782](https://github.com/civicrm/civicrm-core/pull/10782),
  [10768](https://github.com/civicrm/civicrm-core/pull/10768),
  [10750](https://github.com/civicrm/civicrm-core/pull/10750),
  [10743](https://github.com/civicrm/civicrm-core/pull/10743),
  [10732](https://github.com/civicrm/civicrm-core/pull/10732), and
  [10727](https://github.com/civicrm/civicrm-core/pull/10727))**

- **[CRM-20944](https://issues.civicrm.org/jira/browse/CRM-20944) Remove
  Deprecation Notice caused by ActivityLinks
  ([10722](https://github.com/civicrm/civicrm-core/pull/10722))**

  Removes use of CRM_Core_OptionGroup::getKey function which is deprecated

- **[CRM-20607](https://issues.civicrm.org/jira/browse/CRM-20607) Can't save a
  reserved dedupe rule
  ([10383](https://github.com/civicrm/civicrm-core/pull/10383))**

- **[CRM-20577](https://issues.civicrm.org/jira/browse/CRM-20577) When creating
  an activity per-contact when sending letters, store the version with rendered
  tokens ([10348](https://github.com/civicrm/civicrm-core/pull/10348))**

- **[CRM-20970](https://issues.civicrm.org/jira/browse/CRM-20970) long postal
  code in db prevents searching by zipcode range
  ([10769](https://github.com/civicrm/civicrm-core/pull/10769))**

  Entering a long postal code into the database was preventing searching by
  postal code range on some configurations.

- **[CRM-20973](https://issues.civicrm.org/jira/browse/CRM-20973) Call to
  undefined function Civi\API\civicrm_api3_create_error() in Civi/API/Kernel.php
  on line 413 ([10773](https://github.com/civicrm/civicrm-core/pull/10773))**

- **[CRM-20884](https://issues.civicrm.org/jira/browse/CRM-20884) broken symlink
  in net_smtp packages
  ([10676](https://github.com/civicrm/civicrm-core/pull/10676))**

- **[CRM-20648](https://issues.civicrm.org/jira/browse/CRM-20648) Allow
  registration in event with cancelled registration
  ([10430](https://github.com/civicrm/civicrm-core/pull/10430))**

  If a user has a canceled registration for an event civi now allows them to
  register on the front end for that same event.

- **[CRM-20995](https://issues.civicrm.org/jira/browse/CRM-20995) API -
  Extension get - Ignores parameter full_name as created by API explorer
  ([10796](https://github.com/civicrm/civicrm-core/pull/10796))**

- **[CRM-20939](https://issues.civicrm.org/jira/browse/CRM-20939) $_recent
  variable initialised as a string in CRM_Utils_Recent when should be an array
  ([10721](https://github.com/civicrm/civicrm-core/pull/10721))**

- **[CRM-20923](https://issues.civicrm.org/jira/browse/CRM-20923) Refactor tpl
  for admin mail so it respects metadata
  ([10704](https://github.com/civicrm/civicrm-core/pull/10704))**

- **[CRM-20962](https://issues.civicrm.org/jira/browse/CRM-20962) Issue in
  api_v3_SettingTest where string being used but needs to be array for php7.1
  ([10753](https://github.com/civicrm/civicrm-core/pull/10753))**

  Code Improvement for PHP 7.1 compatibility

- **[CRM-20972](https://issues.civicrm.org/jira/browse/CRM-20972) PHP7.1 New
  Exception generated causing failures in API_v3_SyntaxConformanceTests
  ([10772](https://github.com/civicrm/civicrm-core/pull/10772))**

  Code Improvement for PHP 7.1 compatibility

- **[CRM-19941](https://issues.civicrm.org/jira/browse/CRM-19941) PHP 7.1
  Compatability ([10724](https://github.com/civicrm/civicrm-core/pull/10724))**

- **[CRM-20969](https://issues.civicrm.org/jira/browse/CRM-20969) Fix issue in
  reports where we try and append a new array key to string
  ([10765](https://github.com/civicrm/civicrm-core/pull/10765))**

- **[CRM-21029](https://issues.civicrm.org/jira/browse/CRM-21029) Activity
  report SQL syntax error
  ([10820](https://github.com/civicrm/civicrm-core/pull/10820))**

  Fixes network error thrown on the Scheduled Activities dashlet "Network Error :
  unable to reach the server".

### CiviMail

- **[CRM-21100](https://issues.civicrm.org/jira/browse/CRM-21100) Empty list
  shown in "Send test email to group" dropdown
  ([10895](https://github.com/civicrm/civicrm-core/pull/10895))**

  In the preview section of a mailing, the "Send test email to groups" dropdown
  showed an empty list by default. This list was populated by the current
  list of recipients, if any. It now lists existing groups even though these are
  not chosen as recipients.

- **[CRM-21070](https://issues.civicrm.org/jira/browse/CRM-21070) Intra-rc
  regression:Unable to set Recipients in CiviMail in 4.7.24-rc
  ([10880](https://github.com/civicrm/civicrm-core/pull/10880))**

### CiviContribute

- **[CRM-20954](https://issues.civicrm.org/jira/browse/CRM-20954) Fatal SQL
  error when completing a partially paid contribution in localized installation
  ([10747](https://github.com/civicrm/civicrm-core/pull/10747))**

- **[CRM-20976](https://issues.civicrm.org/jira/browse/CRM-20976) Improve error
  handling when someone tries to make a credit card contribution and no
  processor is configured
  ([10775](https://github.com/civicrm/civicrm-core/pull/10775))**

  An error message is now displayed instead of an endless spinning wheel when
  someone tries to make a credit card contribution on a contribution page with
  no processor configured.

- **[CRM-20946](https://issues.civicrm.org/jira/browse/CRM-20946) Wrong entries
  in financial table when contribution is cancelled
  ([10726](https://github.com/civicrm/civicrm-core/pull/10726))**

  Fixes a bug where the wrong entries were being added to the financial table
  when the contribution was canceled, now uses line total of line item to store
  in financial item table

- **[CRM-21002](https://issues.civicrm.org/jira/browse/CRM-21002) Credit card
  type icons are incorrectly populated on backoffice live mode
  ([10799](https://github.com/civicrm/civicrm-core/pull/10799))**

- **[CRM-21027](https://issues.civicrm.org/jira/browse/CRM-21027) Next recurring
  payment not accurately calculated when effective date passed in
  ([10818](https://github.com/civicrm/civicrm-core/pull/10818))**

  This pull request fixes a bug causing payment processors that rely on CiviCRM
  updating the next_sched_contribution_date for recurring to not get it updated.

- **[CRM-20800](https://issues.civicrm.org/jira/browse/CRM-20800) User Cannot
  Cancel Recurring Payment With Paypal
  ([10833](https://github.com/civicrm/civicrm-core/pull/10833)) (Initial Work)**

- **[CRM-20821](https://issues.civicrm.org/jira/browse/CRM-20821) Saving an
  existing premium product breaks the image URLs
  ([10761](https://github.com/civicrm/civicrm-core/pull/10761),
  ([10762](https://github.com/civicrm/civicrm-core/pull/10762), and
  [10720](https://github.com/civicrm/civicrm-core/pull/10720))**

### CiviMember

- **[CRM-20952](https://issues.civicrm.org/jira/browse/CRM-20952) Refresh
  membership tab on edits to membership payments
  ([10741](https://github.com/civicrm/civicrm-core/pull/10741))**

- **[CRM-20961](https://issues.civicrm.org/jira/browse/CRM-20961) Non numeric
  php 7.1 error when running api_v3_MembershipTest
  ([10752](https://github.com/civicrm/civicrm-core/pull/10752))**

- **[CRM-20875](https://issues.civicrm.org/jira/browse/CRM-20875) Import of
  membership custom data throws notice errors.
  ([10664](https://github.com/civicrm/civicrm-core/pull/10664))**

### CiviSMS

- **[CRM-20989](https://issues.civicrm.org/jira/browse/CRM-20989) SMS Provider
  check in Scheduled Reminders, breaks for multisite
  ([10792](https://github.com/civicrm/civicrm-core/pull/10792))**

### CiviEvent

- **[CRM-20910](https://issues.civicrm.org/jira/browse/CRM-20910) API call to
  Participant.get ignores check_permissons
  ([10698](https://github.com/civicrm/civicrm-core/pull/10698))**

- **[CRM-20967](https://issues.civicrm.org/jira/browse/CRM-20967) Event
  Participants List shows Total paid and balance incorrect
  ([10763](https://github.com/civicrm/civicrm-core/pull/10763))**

  Fixes a bug where the Participants List was showing "Total paid" and "balance"
  incorrect when Deferred revenue was enabled.

- **[CRM-17236](https://issues.civicrm.org/jira/browse/CRM-17236) Custom dates
  fields displayed as (01/01/1970) in Events Confirmation Reciept
  ([10710](https://github.com/civicrm/civicrm-core/pull/10710))**

- **[CRM-20915](https://issues.civicrm.org/jira/browse/CRM-20915) Creating
  credit card registration for event stores payment method as check
  ([10701](https://github.com/civicrm/civicrm-core/pull/10701))**

- **[CRM-20943](https://issues.civicrm.org/jira/browse/CRM-20943) PHP 7.1
  Compatability issue with Manage Events
  ([10748](https://github.com/civicrm/civicrm-core/pull/10748))**

### Joomla Integration

- **[CRM-19575](https://issues.civicrm.org/jira/browse/CRM-19575) Cron jobs on
  Joomla triggers "Use of undefined constant JDEBUG"
  ([10715](https://github.com/civicrm/civicrm-core/pull/10715))**

## <a name="misc"></a>Miscellany

- **[CRM-20965](https://issues.civicrm.org/jira/browse/CRM-20965) Add Pull
  Request Template ([10784](https://github.com/civicrm/civicrm-core/pull/10784)
  and [10758](https://github.com/civicrm/civicrm-core/pull/10758))**

  This change sets up a PR template in github to help contributers standardize
  their pull request documentation.

- **(NFC) Fix permissions on CRM/Contribute/BAO/Contribution.php
  ([10766](https://github.com/civicrm/civicrm-core/pull/10766))**

- **CRM_Utils_SQL_Select - Allow fluent query execution
  ([10686](https://github.com/civicrm/civicrm-core/pull/10686))**

- **(NFC) gitignore - Remove obsolete entries
  ([10714](https://github.com/civicrm/civicrm-core/pull/10714))**

- **regen.sh - Fix stale function call in sql/GenerateData.php
  ([10706](https://github.com/civicrm/civicrm-core/pull/10706))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Australian Greens - Seamus Lee; CiviCRM - Coleman
Watts, Tim Otten; CompuCorp - Michael Devery; Coop SymbioTIC - Samuel Vanhove;
Electronic Frontier Foundation - Mark Burdett; Fuzion - Chris Burgess, Eileen
McNaughton, Jitendra Purohit; JMA Consulting - Edsel Lopez, Monish Deb, Pradeep
Nayak; John Kingsnorth; Korlon - Stuart Gaston; Left Join Labs - Sean Madsen;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
myDropWizard - David Snopek; Oxfam Germany - Thomas Schüttler; Progressive
Technology Project - Jamie McClelland; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Alcohol Justice - Bruce Wolfe; Apple Street Market - Sean Prónay; British
Humanist Association - William Gordon; CiviCoop - Jaap Jansma; CiviDesk -
Nicolas Ganivet; CompuCorp - Guanhuan Chen, Jamie Novick; Coop SymbioTIC -
Mathieu Lutfy, Stéphane Lussier; Dave Greenberg; DevMate - Adam Kwiatkowski;
DreamSpace - Anthony Colombo; Francesc Bassas i Bullich; Fuzion - Peter Davis;
Greenleaf Advancement - Karen Stevenson; JMA Consulting - Joe Murray; Lighthouse
Design and Consulting - Brian Shaughnessy; Lionel Smith-Gordon; Nathan Brettell;
National Democratic Institute - Dean Valentine; Responsive Development
Technologies - Thomas Nilefalk; Semper IT - Karin Gerritsen; SEN Magazine -
Jeremy Nicholls; Skvare - Mark Hanna; Stephen Palmstrom; Tadpole Collective -
Kevin Cristiano; Team Expansion - Greg Harris; Thomas Bacon; Torrance Hodgson

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please login to https://chat.civicrm.org/civicrm
and contact `@agh1`.
