// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Actionable;
use Bin;
use Buildable;
use Button;
use ColorChooser;
use Container;
use Widget;
use ffi;
use gdk;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct ColorButton(Object<ffi::GtkColorButton, ffi::GtkColorButtonClass>): Button, Bin, Container, Widget, Buildable, Actionable, ColorChooser;

    match fn {
        get_type => || ffi::gtk_color_button_get_type(),
    }
}

impl ColorButton {
    pub fn new() -> ColorButton {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_color_button_new()).downcast_unchecked()
        }
    }

    pub fn new_with_rgba(rgba: &gdk::RGBA) -> ColorButton {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_color_button_new_with_rgba(rgba.to_glib_none().0)).downcast_unchecked()
        }
    }
}

impl Default for ColorButton {
    fn default() -> Self {
        Self::new()
    }
}

pub trait ColorButtonExt {
    fn get_title(&self) -> Option<String>;

    //fn set_color(&self, color: /*Ignored*/&gdk::Color);

    fn set_title(&self, title: &str);

    fn get_property_alpha(&self) -> u32;

    fn set_property_alpha(&self, alpha: u32);

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn get_property_show_editor(&self) -> bool;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn set_property_show_editor(&self, show_editor: bool);

    fn connect_color_set<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_alpha_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn connect_property_show_editor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_use_alpha_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<ColorButton> + IsA<glib::object::Object>> ColorButtonExt for O {
    fn get_title(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_color_button_get_title(self.to_glib_none().0))
        }
    }

    //fn set_color(&self, color: /*Ignored*/&gdk::Color) {
    //    unsafe { TODO: call ffi::gtk_color_button_set_color() }
    //}

    fn set_title(&self, title: &str) {
        unsafe {
            ffi::gtk_color_button_set_title(self.to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn get_property_alpha(&self) -> u32 {
        unsafe {
            let mut value = Value::from_type(<u32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "alpha".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn set_property_alpha(&self, alpha: u32) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "alpha".to_glib_none().0, Value::from(&alpha).to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn get_property_show_editor(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "show-editor".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn set_property_show_editor(&self, show_editor: bool) {
        unsafe {
            gobject_ffi::g_object_set_property(self.to_glib_none().0, "show-editor".to_glib_none().0, Value::from(&show_editor).to_glib_none().0);
        }
    }

    fn connect_color_set<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "color-set",
                transmute(color_set_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_alpha_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::alpha",
                transmute(notify_alpha_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::rgba",
                transmute(notify_rgba_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    fn connect_property_show_editor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::show-editor",
                transmute(notify_show_editor_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::title",
                transmute(notify_title_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_use_alpha_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::use-alpha",
                transmute(notify_use_alpha_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn color_set_trampoline<P>(this: *mut ffi::GtkColorButton, f: glib_ffi::gpointer)
where P: IsA<ColorButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ColorButton::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_alpha_trampoline<P>(this: *mut ffi::GtkColorButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ColorButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ColorButton::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_rgba_trampoline<P>(this: *mut ffi::GtkColorButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ColorButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ColorButton::from_glib_borrow(this).downcast_unchecked())
}

#[cfg(any(feature = "v3_20", feature = "dox"))]
unsafe extern "C" fn notify_show_editor_trampoline<P>(this: *mut ffi::GtkColorButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ColorButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ColorButton::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_title_trampoline<P>(this: *mut ffi::GtkColorButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ColorButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ColorButton::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_use_alpha_trampoline<P>(this: *mut ffi::GtkColorButton, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<ColorButton> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&ColorButton::from_glib_borrow(this).downcast_unchecked())
}
