% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_children.R
\name{xml_children}
\alias{xml_children}
\alias{xml_child}
\alias{xml_contents}
\alias{xml_parents}
\alias{xml_siblings}
\alias{xml_parent}
\alias{xml_length}
\alias{xml_root}
\title{Navigate around the family tree.}
\usage{
xml_children(x)

xml_child(x, search = 1, ns = xml_ns(x))

xml_contents(x)

xml_parents(x)

xml_siblings(x)

xml_parent(x)

xml_length(x, only_elements = TRUE)

xml_root(x)
}
\arguments{
\item{x}{A document, node, or node set.}

\item{search}{For \code{xml_child}, either the child number to return (by
position), or the name of the child node to return. If there are multiple
child nodes with the same name, the first will be returned}

\item{ns}{Optionally, a named vector giving prefix-url pairs, as produced
by \code{\link{xml_ns}}. If provided, all names will be explicitly
qualified with the ns prefix, i.e. if the element \code{bar} is defined
in namespace \code{foo}, it will be called \code{foo:bar}. (And
similarly for atttributes). Default namespaces must be given an explicit
name. The ns is ignored when using \code{\link{xml_name<-}} and
\code{\link{xml_set_name}}.}

\item{only_elements}{For \code{xml_length}, should it count all children,
or just children that are elements (the default)?}
}
\value{
A node or nodeset (possibly empty). Results are always de-duplicated.
}
\description{
\code{xml_children} returns only elements, \code{xml_contents} returns
all nodes. \code{xml_length} returns the number of children.
\code{xml_parent} returns the parent node, \code{xml_parents}
returns all parents up to the root. \code{xml_siblings} returns all nodes
at the same level. \code{xml_child} makes it easy to specify a specific
child to return.
}
\examples{
x <- read_xml("<foo> <bar><boo /></bar> <baz/> </foo>")
xml_children(x)
xml_children(xml_children(x))
xml_siblings(xml_children(x)[[1]])

# Note the each unique node only appears once in the output
xml_parent(xml_children(x))

# Mixed content
x <- read_xml("<foo> a <b/> c <d>e</d> f</foo>")
# Childen gets the elements, contents gets all node types
xml_children(x)
xml_contents(x)

xml_length(x)
xml_length(x, only_elements = FALSE)

# xml_child makes it easier to select specific children
xml_child(x)
xml_child(x, 2)
xml_child(x, "baz")
}
