% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_walk.R
\name{random_walk}
\alias{random_walk}
\title{Random walk on a graph}
\usage{
random_walk(graph, start, steps, mode = c("out", "in", "all"),
  stuck = c("return", "error"))
}
\arguments{
\item{graph}{The input graph, might be undirected or directed.}

\item{start}{The start vertex.}

\item{steps}{The number of steps to make.}

\item{mode}{How to follow directed edges. \code{"out"} steps along the
edge direction, \code{"in"} is opposite to that. \code{"all"} ignores
edge directions. This argument is ignored for undirected graphs.}

\item{stuck}{What to do if the random walk gets stuck. \code{"return"}
returns the partial walk, \code{"error"} raises an error.}
}
\value{
A vertex sequence containing the vertices along the walk.
}
\description{
Do a random walk. From the given start vertex, take the given number of
steps, choosing an edge from the actual vertex uniformly randomly. Edge
directions are observed in directed graphs (see the \code{mode} argument
as well). Multiple and loop edges are also observed.
}
\examples{
## Stationary distribution of a Markov chain
g <- make_ring(10, directed = TRUE) \%u\%
  make_star(11, center = 11) + edge(11, 1)

ec <- eigen_centrality(g, directed = TRUE)$vector
pg <- page_rank(g, damping = 0.999)$vector
w <- random_walk(g, start = 1, steps = 10000)

## These are similar, but not exactly the same
cor(table(w), ec)

## But these are (almost) the same
cor(table(w), pg)
}
