% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64.R
\name{base64_urlencode}
\alias{base64_urlencode}
\alias{base64_urldecode}
\title{Encode to base64 or Decode from base64}
\usage{
base64_urlencode(x)

base64_urldecode(x)
}
\arguments{
\item{x}{[\code{character(1)}]\cr
Character vector to encode or decode.}
}
\value{
[\code{character}] of the same length as input \code{x}.
}
\description{
In contrast to RFC3548, the 62nd character (\sQuote{+}) is replaced with \sQuote{-}, the 63rd character (\sQuote{/}) is replaced with \sQuote{_}.
Furthermore, the encoder does not fill the string with trailing \sQuote{=}.
The resulting encoded strings comply to the regular expression pattern \dQuote{[A-Za-z0-9_-]} and thus are safe to use in URLs
or for file names.
}
\examples{
x = "plain text"
encoded = base64_urlencode(x)
decoded = base64_urldecode(encoded)
print(encoded)
print(decoded)
}
\references{
Implementation based on base64 encoder/decoder in the Apache Portable Runtime (APR): \url{https://svn.apache.org/repos/asf/apr/apr/trunk/encoding/apr_base64.c}
}
