/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.env.Environment;
import org.opensearch.ingest.AbstractBatchingProcessor;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.IngestDocumentWrapper;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.TextInferenceRequest;
import org.opensearch.neuralsearch.processor.optimization.InferenceFilter;
import org.opensearch.neuralsearch.util.ProcessorDocumentUtils;
import org.opensearch.neuralsearch.util.TokenWeightUtil;
import org.opensearch.neuralsearch.util.prune.PruneType;
import org.opensearch.neuralsearch.util.prune.PruneUtils;

public abstract class InferenceProcessor
extends AbstractBatchingProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(InferenceProcessor.class);
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String FIELD_MAP_FIELD = "field_map";
    public static final String SKIP_EXISTING = "skip_existing";
    public static final boolean DEFAULT_SKIP_EXISTING = false;
    private static final BiFunction<Object, Object, Object> REMAPPING_FUNCTION = (v1, v2) -> {
        if (v1 instanceof Collection && v2 instanceof Collection) {
            ((Collection)v1).addAll((Collection)v2);
            return v1;
        }
        if (v1 instanceof Map && v2 instanceof Map) {
            ((Map)v1).putAll((Map)v2);
            return v1;
        }
        return v2;
    };
    private final String type;
    protected final String listTypeNestedMapKey;
    protected final String modelId;
    private final Map<String, Object> fieldMap;
    protected final MLCommonsClientAccessor mlCommonsClientAccessor;
    private final Environment environment;
    private final ClusterService clusterService;

    public InferenceProcessor(String tag, String description, int batchSize, String type, String listTypeNestedMapKey, String modelId, Map<String, Object> fieldMap, MLCommonsClientAccessor clientAccessor, Environment environment, ClusterService clusterService) {
        super(tag, description, batchSize);
        this.type = type;
        if (StringUtils.isBlank((CharSequence)modelId)) {
            throw new IllegalArgumentException("model_id is null or empty, cannot process it");
        }
        this.validateEmbeddingConfiguration(fieldMap);
        this.listTypeNestedMapKey = listTypeNestedMapKey;
        this.modelId = modelId;
        this.fieldMap = fieldMap;
        this.mlCommonsClientAccessor = clientAccessor;
        this.environment = environment;
        this.clusterService = clusterService;
    }

    private void validateEmbeddingConfiguration(Map<String, Object> fieldMap) {
        if (fieldMap == null || fieldMap.size() == 0 || fieldMap.entrySet().stream().anyMatch(x -> StringUtils.isBlank((CharSequence)((CharSequence)x.getKey())) || Objects.isNull(x.getValue()) || StringUtils.isBlank((CharSequence)x.getValue().toString()))) {
            throw new IllegalArgumentException("Unable to create the processor as field_map has invalid key or value");
        }
    }

    public abstract void doExecute(IngestDocument var1, Map<String, Object> var2, List<String> var3, BiConsumer<IngestDocument, Exception> var4);

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        return ingestDocument;
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        try {
            this.preprocessIngestDocument(ingestDocument);
            this.validateEmbeddingFieldsValue(ingestDocument);
            Map<String, Object> processMap = this.buildMapWithTargetKeys(ingestDocument);
            List<String> inferenceList = this.createInferenceList(processMap);
            if (inferenceList.size() == 0) {
                handler.accept(ingestDocument, null);
            } else {
                this.doExecute(ingestDocument, processMap, inferenceList, handler);
            }
        }
        catch (Exception e) {
            handler.accept(null, e);
        }
    }

    @VisibleForTesting
    void preprocessIngestDocument(IngestDocument ingestDocument) {
        if (ingestDocument == null || ingestDocument.getSourceAndMetadata() == null) {
            return;
        }
        Map sourceAndMetadataMap = ingestDocument.getSourceAndMetadata();
        Map<String, Object> unflattened = ProcessorDocumentUtils.unflattenJson(sourceAndMetadataMap);
        unflattened.forEach((arg_0, arg_1) -> ((IngestDocument)ingestDocument).setFieldValue(arg_0, arg_1));
        sourceAndMetadataMap.keySet().removeIf(key -> key.contains("."));
    }

    abstract void doBatchExecute(List<String> var1, Consumer<List<?>> var2, Consumer<Exception> var3);

    public void subBatchExecute(List<IngestDocumentWrapper> ingestDocumentWrappers, Consumer<List<IngestDocumentWrapper>> handler) {
        try {
            if (CollectionUtils.isEmpty(ingestDocumentWrappers)) {
                handler.accept(ingestDocumentWrappers);
                return;
            }
            List<DataForInference> dataForInferences = this.getDataForInference(ingestDocumentWrappers);
            List<String> inferenceList = this.constructInferenceTexts(dataForInferences);
            if (inferenceList.isEmpty()) {
                handler.accept(ingestDocumentWrappers);
                return;
            }
            this.doSubBatchExecute(ingestDocumentWrappers, inferenceList, dataForInferences, handler);
        }
        catch (Exception e) {
            this.updateWithExceptions(ingestDocumentWrappers, handler, e);
        }
    }

    protected void doSubBatchExecute(List<IngestDocumentWrapper> ingestDocumentWrappers, List<String> inferenceList, List<DataForInference> dataForInferences, Consumer<List<IngestDocumentWrapper>> handler) {
        Tuple<List<String>, Map<Integer, Integer>> sortedResult = this.sortByLengthAndReturnOriginalOrder(inferenceList);
        inferenceList = (List)sortedResult.v1();
        Map originalOrder = (Map)sortedResult.v2();
        this.doBatchExecute(inferenceList, results -> {
            this.batchExecuteHandler((List<?>)results, dataForInferences, originalOrder);
            handler.accept(ingestDocumentWrappers);
        }, exception -> this.updateWithExceptions(ingestDocumentWrappers, handler, (Exception)exception));
    }

    protected void batchExecuteHandler(List<?> results, List<DataForInference> dataForInferences, Map<Integer, Integer> originalOrder) {
        int startIndex = 0;
        results = this.restoreToOriginalOrder(results, originalOrder);
        for (DataForInference dataForInference : dataForInferences) {
            if (dataForInference.getIngestDocumentWrapper().getException() != null || CollectionUtils.isEmpty(dataForInference.getInferenceList())) continue;
            List<?> inferenceResults = results.subList(startIndex, startIndex + dataForInference.getInferenceList().size());
            startIndex += dataForInference.getInferenceList().size();
            this.setVectorFieldsToDocument(dataForInference.getIngestDocumentWrapper().getIngestDocument(), dataForInference.getProcessMap(), inferenceResults);
        }
    }

    protected Tuple<List<String>, Map<Integer, Integer>> sortByLengthAndReturnOriginalOrder(List<String> inferenceList) {
        ArrayList<Tuple> docsWithIndex = new ArrayList<Tuple>();
        for (int i = 0; i < inferenceList.size(); ++i) {
            docsWithIndex.add(Tuple.tuple((Object)i, (Object)inferenceList.get(i)));
        }
        docsWithIndex.sort(Comparator.comparingInt(t -> ((String)t.v2()).length()));
        List sortedInferenceList = docsWithIndex.stream().map(Tuple::v2).collect(Collectors.toList());
        HashMap<Integer, Integer> originalOrderMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < docsWithIndex.size(); ++i) {
            originalOrderMap.put(i, (Integer)((Tuple)docsWithIndex.get(i)).v1());
        }
        return Tuple.tuple(sortedInferenceList, originalOrderMap);
    }

    private List<?> restoreToOriginalOrder(List<?> results, Map<Integer, Integer> originalOrder) {
        List<Object> sortedResults = Arrays.asList(results.toArray());
        for (int i = 0; i < results.size(); ++i) {
            if (!originalOrder.containsKey(i)) continue;
            int oldIndex = originalOrder.get(i);
            sortedResults.set(oldIndex, results.get(i));
        }
        return sortedResults;
    }

    protected List<String> constructInferenceTexts(List<DataForInference> dataForInferences) {
        ArrayList<String> inferenceTexts = new ArrayList<String>();
        for (DataForInference dataForInference : dataForInferences) {
            if (dataForInference.getIngestDocumentWrapper().getException() != null || CollectionUtils.isEmpty(dataForInference.getInferenceList())) continue;
            inferenceTexts.addAll(dataForInference.getInferenceList());
        }
        return inferenceTexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DataForInference> getDataForInference(List<IngestDocumentWrapper> ingestDocumentWrappers) {
        ArrayList<DataForInference> dataForInferences = new ArrayList<DataForInference>();
        for (IngestDocumentWrapper ingestDocumentWrapper : ingestDocumentWrappers) {
            Map<String, Object> processMap = null;
            List<String> inferenceList = null;
            IngestDocument ingestDocument = ingestDocumentWrapper.getIngestDocument();
            try {
                this.preprocessIngestDocument(ingestDocument);
                this.validateEmbeddingFieldsValue(ingestDocument);
                processMap = this.buildMapWithTargetKeys(ingestDocument);
                inferenceList = this.createInferenceList(processMap);
            }
            catch (Exception e) {
                ingestDocumentWrapper.update(ingestDocument, e);
            }
            finally {
                dataForInferences.add(new DataForInference(ingestDocumentWrapper, processMap, inferenceList));
            }
        }
        return dataForInferences;
    }

    protected List<String> createInferenceList(Map<String, Object> knnKeyMap) {
        ArrayList<String> texts = new ArrayList<String>();
        knnKeyMap.entrySet().stream().filter(knnMapEntry -> knnMapEntry.getValue() != null).forEach(knnMapEntry -> {
            Object sourceValue = knnMapEntry.getValue();
            if (sourceValue instanceof List) {
                texts.addAll((List)sourceValue);
            } else if (sourceValue instanceof Map) {
                this.createInferenceListForMapTypeInput(sourceValue, texts);
            } else {
                texts.add(sourceValue.toString());
            }
        });
        return texts;
    }

    private void createInferenceListForMapTypeInput(Object sourceValue, List<String> texts) {
        if (sourceValue instanceof Map) {
            ((Map)sourceValue).forEach((k, v) -> this.createInferenceListForMapTypeInput(v, texts));
        } else if (sourceValue instanceof List) {
            ((List)sourceValue).stream().filter(Objects::nonNull).forEach(texts::add);
        } else {
            if (sourceValue == null) {
                return;
            }
            texts.add(sourceValue.toString());
        }
    }

    @VisibleForTesting
    Map<String, Object> buildMapWithTargetKeys(IngestDocument ingestDocument) {
        Map sourceAndMetadataMap = ingestDocument.getSourceAndMetadata();
        LinkedHashMap<String, Object> mapWithProcessorKeys = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> fieldMapEntry : this.fieldMap.entrySet()) {
            Pair<String, Object> processedNestedKey = this.processNestedKey(fieldMapEntry);
            String originalKey = (String)processedNestedKey.getKey();
            Object targetKey = processedNestedKey.getValue();
            if (targetKey instanceof Map) {
                LinkedHashMap<String, Object> treeRes = new LinkedHashMap<String, Object>();
                this.buildNestedMap(originalKey, targetKey, sourceAndMetadataMap, treeRes);
                mapWithProcessorKeys.put(originalKey, treeRes.get(originalKey));
                continue;
            }
            mapWithProcessorKeys.put(String.valueOf(targetKey), this.normalizeSourceValue(sourceAndMetadataMap.get(originalKey)));
        }
        return mapWithProcessorKeys;
    }

    @VisibleForTesting
    void buildNestedMap(String parentKey, Object processorKey, Map<String, Object> sourceAndMetadataMap, Map<String, Object> treeRes) {
        if (Objects.isNull(processorKey) || Objects.isNull(sourceAndMetadataMap)) {
            return;
        }
        if (processorKey instanceof Map) {
            LinkedHashMap<String, Object> next = new LinkedHashMap<String, Object>();
            if (sourceAndMetadataMap.get(parentKey) instanceof Map) {
                for (Map.Entry<String, Object> entry : ((Map)processorKey).entrySet()) {
                    Pair<String, Object> processedNestedKey = this.processNestedKey(entry);
                    this.buildNestedMap((String)processedNestedKey.getKey(), processedNestedKey.getValue(), (Map)sourceAndMetadataMap.get(parentKey), next);
                }
            } else if (sourceAndMetadataMap.get(parentKey) instanceof List) {
                for (Map.Entry<String, Object> entry : ((Map)processorKey).entrySet()) {
                    List nestedSourceList = (List)sourceAndMetadataMap.get(parentKey);
                    Pair<String, Object> processedNestedKey = this.processNestedKey(entry);
                    List listOfStrings = nestedSourceList.stream().map(nestedSourceItem -> nestedSourceItem.get(processedNestedKey.getKey())).map(this::normalizeSourceValue).collect(Collectors.toList());
                    LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                    nestedMap.put((String)processedNestedKey.getKey(), listOfStrings);
                    this.buildNestedMap((String)processedNestedKey.getKey(), processedNestedKey.getValue(), nestedMap, next);
                }
            }
            treeRes.merge(parentKey, next, REMAPPING_FUNCTION);
        } else {
            Object parentValue = sourceAndMetadataMap.get(parentKey);
            String key = String.valueOf(processorKey);
            treeRes.put(key, this.normalizeSourceValue(parentValue));
        }
    }

    private boolean isBlankString(Object object) {
        return object instanceof String && StringUtils.isBlank((CharSequence)((String)object));
    }

    private Object normalizeSourceValue(Object value) {
        if (this.isBlankString(value)) {
            return null;
        }
        return value;
    }

    @VisibleForTesting
    protected Pair<String, Object> processNestedKey(Map.Entry<String, Object> nestedFieldMapEntry) {
        String originalKey = nestedFieldMapEntry.getKey();
        LinkedHashMap targetKey = nestedFieldMapEntry.getValue();
        int nestedDotIndex = originalKey.indexOf(46);
        if (nestedDotIndex != -1) {
            LinkedHashMap newTargetKey = new LinkedHashMap();
            newTargetKey.put(originalKey.substring(nestedDotIndex + 1), targetKey);
            targetKey = newTargetKey;
            originalKey = originalKey.substring(0, nestedDotIndex);
        }
        return new ImmutablePair((Object)originalKey, (Object)targetKey);
    }

    private void validateEmbeddingFieldsValue(IngestDocument ingestDocument) {
        Map sourceAndMetadataMap = ingestDocument.getSourceAndMetadata();
        String indexName = sourceAndMetadataMap.get("_index").toString();
        ProcessorDocumentUtils.validateMapTypeValue(FIELD_MAP_FIELD, sourceAndMetadataMap, ProcessorDocumentUtils.unflattenJson(this.fieldMap), indexName, this.clusterService, this.environment, true);
    }

    protected void setVectorFieldsToDocument(IngestDocument ingestDocument, Map<String, Object> processorMap, List<?> results) {
        Objects.requireNonNull(results, "embedding failed, inference returns null result!");
        log.debug("Model inference result fetched, starting build vector output!");
        Map<String, Object> nlpResult = this.buildNLPResult(processorMap, results, ingestDocument.getSourceAndMetadata());
        nlpResult.forEach((arg_0, arg_1) -> ((IngestDocument)ingestDocument).setFieldValue(arg_0, arg_1));
    }

    protected MultiGetRequest buildMultiGetRequest(List<DataForInference> dataForInferences) {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        for (DataForInference dataForInference : dataForInferences) {
            Object index = dataForInference.getIngestDocumentWrapper().getIngestDocument().getSourceAndMetadata().get("_index");
            Object id = dataForInference.getIngestDocumentWrapper().getIngestDocument().getSourceAndMetadata().get("_id");
            if (!Objects.nonNull(index) || !Objects.nonNull(id)) continue;
            multiGetRequest.add(index.toString(), id.toString());
        }
        return multiGetRequest;
    }

    protected Map<String, Map<String, Object>> createDocumentMap(MultiGetItemResponse[] multiGetItemResponses) {
        HashMap<String, Map<String, Object>> existingDocuments = new HashMap<String, Map<String, Object>>();
        for (MultiGetItemResponse item : multiGetItemResponses) {
            String id = item.getId();
            Map existingDocument = item.getResponse().getSourceAsMap();
            existingDocuments.put(id, existingDocument);
        }
        return existingDocuments;
    }

    @VisibleForTesting
    Map<String, Object> buildNLPResult(Map<String, Object> processorMap, List<?> results, Map<String, Object> sourceAndMetadataMap) {
        IndexWrapper indexWrapper = new IndexWrapper(0);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> knnMapEntry : processorMap.entrySet()) {
            Pair<String, Object> processedNestedKey = this.processNestedKey(knnMapEntry);
            String knnKey = (String)processedNestedKey.getKey();
            Object sourceValue = processedNestedKey.getValue();
            if (sourceValue instanceof String) {
                result.put(knnKey, results.get(indexWrapper.index++));
                continue;
            }
            if (sourceValue instanceof List) {
                result.put(knnKey, this.buildNLPResultForListType((List)sourceValue, results, indexWrapper));
                continue;
            }
            if (!(sourceValue instanceof Map)) continue;
            this.putNLPResultToSourceMapForMapType(knnKey, sourceValue, results, indexWrapper, sourceAndMetadataMap);
        }
        return result;
    }

    private void putNLPResultToSourceMapForMapType(String processorKey, Object sourceValue, List<?> results, IndexWrapper indexWrapper, Map<String, Object> sourceAndMetadataMap) {
        if (processorKey == null || sourceAndMetadataMap == null || sourceValue == null) {
            return;
        }
        if (sourceValue instanceof Map) {
            for (Map.Entry<String, Object> entry : ((Map)sourceValue).entrySet()) {
                if (sourceAndMetadataMap.get(processorKey) instanceof List) {
                    if (entry.getValue() instanceof List) {
                        this.processMapEntryValue(results, indexWrapper, (List<Map<String, Object>>)((List)sourceAndMetadataMap.get(processorKey)), entry.getKey(), (List)entry.getValue());
                        continue;
                    }
                    if (!(entry.getValue() instanceof Map)) continue;
                    this.processMapEntryValue(results, indexWrapper, (List<Map<String, Object>>)((List)sourceAndMetadataMap.get(processorKey)), entry.getKey(), entry.getValue());
                    continue;
                }
                Pair<String, Object> processedNestedKey = this.processNestedKey(entry);
                Map<String, Object> sourceMap = this.getSourceMapBySourceAndMetadataMap(processorKey, sourceAndMetadataMap);
                this.putNLPResultToSourceMapForMapType((String)processedNestedKey.getKey(), processedNestedKey.getValue(), results, indexWrapper, sourceMap);
            }
        } else if (sourceValue instanceof String) {
            sourceAndMetadataMap.merge(processorKey, results.get(indexWrapper.index++), REMAPPING_FUNCTION);
        } else if (sourceValue instanceof List) {
            sourceAndMetadataMap.merge(processorKey, this.buildNLPResultForListType((List)sourceValue, results, indexWrapper), REMAPPING_FUNCTION);
        }
    }

    private void processMapEntryValue(List<?> results, IndexWrapper indexWrapper, List<Map<String, Object>> sourceAndMetadataMapValueInList, String inputNestedMapEntryKey, List<Object> inputNestedMapEntryValue) {
        Iterator<Object> inputNestedMapValueIt = inputNestedMapEntryValue.iterator();
        for (Map<String, Object> nestedElement : sourceAndMetadataMapValueInList) {
            if (!inputNestedMapValueIt.hasNext() || inputNestedMapValueIt.next() == null) continue;
            nestedElement.put(inputNestedMapEntryKey, results.get(indexWrapper.index++));
        }
    }

    protected void updateWithExceptions(List<IngestDocumentWrapper> ingestDocumentWrappers, Consumer<List<IngestDocumentWrapper>> handler, Exception e) {
        try {
            for (IngestDocumentWrapper ingestDocumentWrapper : ingestDocumentWrappers) {
                if (ingestDocumentWrapper.getException() != null) continue;
                ingestDocumentWrapper.update(ingestDocumentWrapper.getIngestDocument(), e);
            }
            handler.accept(ingestDocumentWrappers);
        }
        catch (Exception ex) {
            log.error(String.format(Locale.ROOT, "updating ingestDocumentWrappers with exceptions failed with error: [%s]", ex));
            handler.accept(null);
        }
    }

    private void processMapEntryValue(List<?> results, IndexWrapper indexWrapper, List<Map<String, Object>> sourceAndMetadataMapValueInList, String inputNestedMapEntryKey, Object inputNestedMapEntryValue) {
        Iterator<Map<String, Object>> iterator = sourceAndMetadataMapValueInList.iterator();
        IntStream.range(0, sourceAndMetadataMapValueInList.size()).forEach(index -> {
            Map nestedElement = (Map)iterator.next();
            this.putNLPResultToSingleSourceMapInList(inputNestedMapEntryKey, inputNestedMapEntryValue, results, indexWrapper, nestedElement, index);
        });
    }

    private void putNLPResultToSingleSourceMapInList(String processorKey, Object sourceValue, List<?> results, IndexWrapper indexWrapper, Map<String, Object> sourceAndMetadataMap, int nestedElementIndex) {
        if (processorKey == null || sourceAndMetadataMap == null || sourceValue == null) {
            return;
        }
        if (sourceValue instanceof Map) {
            for (Map.Entry<String, Object> entry : ((Map)sourceValue).entrySet()) {
                Pair<String, Object> processedNestedKey = this.processNestedKey(entry);
                Map<String, Object> sourceMap = this.getSourceMapBySourceAndMetadataMap(processorKey, sourceAndMetadataMap);
                this.putNLPResultToSingleSourceMapInList((String)processedNestedKey.getKey(), processedNestedKey.getValue(), results, indexWrapper, sourceMap, nestedElementIndex);
            }
        } else if (sourceValue instanceof List && ((List)sourceValue).get(nestedElementIndex) != null) {
            sourceAndMetadataMap.merge(processorKey, results.get(indexWrapper.index++), REMAPPING_FUNCTION);
        }
    }

    private Map<String, Object> getSourceMapBySourceAndMetadataMap(String processorKey, Map<String, Object> sourceAndMetadataMap) {
        HashMap<String, Object> sourceMap = new HashMap();
        if (sourceAndMetadataMap.get(processorKey) == null) {
            sourceAndMetadataMap.put(processorKey, sourceMap);
        } else {
            sourceMap = (Map)sourceAndMetadataMap.get(processorKey);
        }
        return sourceMap;
    }

    private List<Map<String, Object>> buildNLPResultForListType(List<String> sourceValue, List<?> results, IndexWrapper indexWrapper) {
        ArrayList<Map<String, Object>> keyToResult = new ArrayList<Map<String, Object>>();
        sourceValue.stream().filter(Objects::nonNull).forEachOrdered(x -> keyToResult.add((Map<String, Object>)ImmutableMap.of((Object)this.listTypeNestedMapKey, results.get(indexWrapper.index++))));
        return keyToResult;
    }

    protected void reuseOrGenerateEmbedding(GetResponse response, IngestDocument ingestDocument, Map<String, Object> processMap, List<String> inferenceList, BiConsumer<IngestDocument, Exception> handler, InferenceFilter inferenceFilter) {
        Map existingDocument = response.getSourceAsMap();
        if (existingDocument == null || existingDocument.isEmpty()) {
            this.generateAndSetInference(ingestDocument, processMap, inferenceList, handler);
            return;
        }
        Map<String, Object> filteredProcessMap = inferenceFilter.filterAndCopyExistingEmbeddings(existingDocument, ingestDocument.getSourceAndMetadata(), processMap);
        List<String> filteredInferenceList = this.createInferenceList(filteredProcessMap).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (filteredInferenceList.isEmpty()) {
            handler.accept(ingestDocument, null);
        } else {
            this.generateAndSetInference(ingestDocument, filteredProcessMap, filteredInferenceList, handler);
        }
    }

    protected void reuseOrGenerateEmbedding(MultiGetResponse response, List<IngestDocumentWrapper> ingestDocumentWrappers, List<String> inferenceList, List<DataForInference> dataForInferences, Consumer<List<IngestDocumentWrapper>> handler, InferenceFilter inferenceFilter) {
        MultiGetItemResponse[] multiGetItemResponses = response.getResponses();
        if (multiGetItemResponses == null || multiGetItemResponses.length == 0) {
            this.doSubBatchExecute(ingestDocumentWrappers, inferenceList, dataForInferences, handler);
            return;
        }
        Map<String, Map<String, Object>> existingDocuments = this.createDocumentMap(multiGetItemResponses);
        List<DataForInference> filteredDataForInference = this.filterDataForInference(inferenceFilter, dataForInferences, existingDocuments);
        List<String> filteredInferenceList = this.constructInferenceTexts(filteredDataForInference);
        if (filteredInferenceList.isEmpty()) {
            handler.accept(ingestDocumentWrappers);
            return;
        }
        this.doSubBatchExecute(ingestDocumentWrappers, filteredInferenceList, filteredDataForInference, handler);
    }

    protected List<DataForInference> filterDataForInference(InferenceFilter inferenceFilter, List<DataForInference> dataForInferences, Map<String, Map<String, Object>> existingDocuments) {
        ArrayList<DataForInference> filteredDataForInference = new ArrayList<DataForInference>();
        for (DataForInference dataForInference : dataForInferences) {
            IngestDocumentWrapper ingestDocumentWrapper = dataForInference.getIngestDocumentWrapper();
            Map<String, Object> processMap = dataForInference.getProcessMap();
            Map document = ingestDocumentWrapper.getIngestDocument().getSourceAndMetadata();
            Object id = document.get("_id");
            if (Objects.isNull(id) || !existingDocuments.containsKey(id.toString())) {
                filteredDataForInference.add(dataForInference);
                continue;
            }
            String docId = id.toString();
            Map<String, Object> existingDocument = existingDocuments.get(docId);
            Map<String, Object> filteredProcessMap = inferenceFilter.filterAndCopyExistingEmbeddings(existingDocument, document, processMap);
            List<String> filteredInferenceList = this.createInferenceList(filteredProcessMap);
            filteredDataForInference.add(new DataForInference(ingestDocumentWrapper, filteredProcessMap, filteredInferenceList));
        }
        return filteredDataForInference;
    }

    protected List<IngestDocumentWrapper> getIngestDocumentWrappers(List<DataForInference> dataForInferences) {
        return dataForInferences.stream().map(DataForInference::getIngestDocumentWrapper).toList();
    }

    protected void generateAndSetInference(IngestDocument ingestDocument, Map<String, Object> processMap, List<String> inferenceList, BiConsumer<IngestDocument, Exception> handler) {
        this.mlCommonsClientAccessor.inferenceSentences((TextInferenceRequest)((TextInferenceRequest.TextInferenceRequestBuilder)((TextInferenceRequest.TextInferenceRequestBuilder)TextInferenceRequest.builder().modelId(this.modelId)).inputTexts(inferenceList)).build(), (ActionListener<List<List<Number>>>)ActionListener.wrap(vectors -> {
            this.setVectorFieldsToDocument(ingestDocument, processMap, (List<?>)vectors);
            handler.accept(ingestDocument, null);
        }, e -> handler.accept((IngestDocument)null, (Exception)e)));
    }

    protected void generateAndSetMapInference(IngestDocument ingestDocument, Map<String, Object> processMap, List<String> inferenceList, PruneType pruneType, float pruneRatio, MLAlgoParams mlAlgoParams, BiConsumer<IngestDocument, Exception> handler) {
        this.mlCommonsClientAccessor.inferenceSentencesWithMapResult((TextInferenceRequest)((TextInferenceRequest.TextInferenceRequestBuilder)((TextInferenceRequest.TextInferenceRequestBuilder)TextInferenceRequest.builder().modelId(this.modelId)).inputTexts(inferenceList)).build(), mlAlgoParams, ActionListener.wrap(resultMaps -> {
            List<Map> sparseVectors = TokenWeightUtil.fetchListOfTokenWeightMap(resultMaps).stream().map(vector -> PruneUtils.pruneSparseVector(pruneType, pruneRatio, vector)).toList();
            this.setVectorFieldsToDocument(ingestDocument, processMap, sparseVectors);
            handler.accept(ingestDocument, null);
        }, e -> handler.accept((IngestDocument)null, (Exception)e)));
    }

    public String getType() {
        return this.type;
    }

    protected static class DataForInference {
        private final IngestDocumentWrapper ingestDocumentWrapper;
        private final Map<String, Object> processMap;
        private final List<String> inferenceList;

        @Generated
        public IngestDocumentWrapper getIngestDocumentWrapper() {
            return this.ingestDocumentWrapper;
        }

        @Generated
        public Map<String, Object> getProcessMap() {
            return this.processMap;
        }

        @Generated
        public List<String> getInferenceList() {
            return this.inferenceList;
        }

        @Generated
        public DataForInference(IngestDocumentWrapper ingestDocumentWrapper, Map<String, Object> processMap, List<String> inferenceList) {
            this.ingestDocumentWrapper = ingestDocumentWrapper;
            this.processMap = processMap;
            this.inferenceList = inferenceList;
        }
    }

    static class IndexWrapper {
        private int index;

        protected IndexWrapper(int index) {
            this.index = index;
        }
    }
}

