/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.BindResp;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.Outbind;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.QueueMaxException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSession;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.BindCommandTask;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.OutbindRequest;
import org.jsmpp.session.OutbindRequestReceiver;
import org.jsmpp.session.OutboundSMPPServerSessionContext;
import org.jsmpp.session.OutboundServerMessageReceiverListener;
import org.jsmpp.session.OutboundServerResponseHandler;
import org.jsmpp.session.OutboundServerSession;
import org.jsmpp.session.PDUProcessOutboundServerTask;
import org.jsmpp.session.PDUProcessServerTask;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPOutboundServerSession
extends AbstractSession
implements OutboundServerSession {
    private static final Logger logger = LoggerFactory.getLogger(SMPPOutboundServerSession.class);
    private final Connection conn;
    private final DataInputStream in;
    private final OutputStream out;
    private final PDUReader pduReader;
    private final OutboundServerResponseHandler responseHandler = new OutboundServerResponseHandlerImpl();
    private BoundSessionStateListener sessionStateListener = new BoundSessionStateListener();
    private OutboundSMPPServerSessionContext sessionContext = new OutboundSMPPServerSessionContext(this, this.sessionStateListener);
    private PDUReaderWorker pduReaderWorker;
    private GenericMessageReceiverListener messageReceiverListener;
    private OutboundServerMessageReceiverListener outboundServerMessageReceiverListener;
    private OutbindRequestReceiver outbindRequestReceiver = new OutbindRequestReceiver();

    public SMPPOutboundServerSession(Connection conn, SessionStateListener sessionStateListener, GenericMessageReceiverListener messageReceiverListener, OutboundServerMessageReceiverListener outboundServerMessageReceiverListener, int pduProcessorDegree) {
        this(conn, sessionStateListener, messageReceiverListener, outboundServerMessageReceiverListener, pduProcessorDegree, new SynchronizedPDUSender(new DefaultPDUSender()), new DefaultPDUReader());
    }

    public SMPPOutboundServerSession(Connection conn, SessionStateListener sessionStateListener, GenericMessageReceiverListener messageReceiverListener, OutboundServerMessageReceiverListener outboundServerMessageReceiverListener, int pduProcessorDegree, PDUSender pduSender, PDUReader pduReader) {
        super(pduSender);
        this.conn = conn;
        this.messageReceiverListener = messageReceiverListener;
        this.outboundServerMessageReceiverListener = outboundServerMessageReceiverListener;
        this.pduReader = pduReader;
        this.in = new DataInputStream(conn.getInputStream());
        this.out = conn.getOutputStream();
        this.enquireLinkSender = new AbstractSession.EnquireLinkSender();
        this.addSessionStateListener(sessionStateListener);
        this.setPduProcessorDegree(pduProcessorDegree);
        this.sessionContext.open();
    }

    public InetAddress getInetAddress() {
        return this.connection().getInetAddress();
    }

    public int getPort() {
        return this.connection().getPort();
    }

    private String sendBind(BindType bindType, String systemId, String password, String systemType, InterfaceVersion interfaceVersion, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange, long timeout) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        BindCommandTask task = new BindCommandTask(this.pduSender(), bindType, systemId, password, systemType, interfaceVersion, addrTon, addrNpi, addressRange);
        BindResp resp = (BindResp)this.executeSendCommand(task, timeout);
        OptionalParameter.Sc_interface_version scVersion = resp.getOptionalParameter(OptionalParameter.Sc_interface_version.class);
        if (scVersion != null) {
            logger.debug("Other side reports SMPP interface version {}", (Object)scVersion);
        }
        logger.info("Bind response systemId '{}'", (Object)resp.getSystemId());
        return resp.getSystemId();
    }

    public OutbindRequest waitForOutbind(long timeout) throws IllegalStateException, TimeoutException {
        SessionState currentSessionState = this.getSessionState();
        if (currentSessionState.equals((Object)SessionState.OPEN)) {
            this.pduReaderWorker = new PDUReaderWorker(this.getQueueCapacity());
            this.pduReaderWorker.start();
            try {
                return this.outbindRequestReceiver.waitForRequest(timeout);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Invocation of waitForOutbind() has been made", e);
            }
            catch (TimeoutException e) {
                this.close();
                throw e;
            }
        }
        throw new IllegalStateException("waitForOutbind() should be invoked on OPEN state, actual state is " + (Object)((Object)currentSessionState));
    }

    @Override
    protected Connection connection() {
        return this.conn;
    }

    @Override
    protected AbstractSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    protected GenericMessageReceiverListener messageReceiverListener() {
        return this.messageReceiverListener;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public OutboundServerMessageReceiverListener getOutboundServerMessageReceiverListener() {
        return this.outboundServerMessageReceiverListener;
    }

    @Override
    public void setOutboundServerMessageReceiverListener(OutboundServerMessageReceiverListener outboundServerMessageReceiverListener) {
        this.outboundServerMessageReceiverListener = outboundServerMessageReceiverListener;
    }

    private void fireAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
        if (this.outboundServerMessageReceiverListener == null) {
            logger.warn("Receive deliver_sm but OutboundServerMessageReceiverListener is null. Short message = {}", (Object)new String(deliverSm.getShortMessage()));
            throw new ProcessRequestException("No message receiver listener registered", 100);
        }
        this.outboundServerMessageReceiverListener.onAcceptDeliverSm(deliverSm, this);
    }

    public String bind(BindParameter bindParam, long timeout) throws IOException {
        try {
            String smscSystemId = this.sendBind(bindParam.getBindType(), bindParam.getSystemId(), bindParam.getPassword(), bindParam.getSystemType(), bindParam.getInterfaceVersion(), bindParam.getAddrTon(), bindParam.getAddrNpi(), bindParam.getAddressRange(), timeout);
            this.sessionContext.bound(bindParam.getBindType());
            this.enquireLinkSender = new AbstractSession.EnquireLinkSender();
            this.enquireLinkSender.start();
            return smscSystemId;
        }
        catch (PDUException e) {
            logger.error("Failed sending bind command", (Throwable)e);
            throw new IOException("Failed sending bind since some string parameter area invalid: " + e.getMessage(), e);
        }
        catch (NegativeResponseException e) {
            String message = "Receive negative bind response";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage(), e);
        }
        catch (InvalidResponseException e) {
            String message = "Receive invalid response of bind";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage(), e);
        }
        catch (ResponseTimeoutException e) {
            String message = "Wait for bind response timed out";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            logger.error("IO error occurred", (Throwable)e);
            this.close();
            throw e;
        }
    }

    private class BoundSessionStateListener
    implements SessionStateListener {
        private BoundSessionStateListener() {
        }

        @Override
        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            if (newState.isBound()) {
                try {
                    SMPPOutboundServerSession.this.conn.setSoTimeout(SMPPOutboundServerSession.this.getEnquireLinkTimer());
                }
                catch (IOException e) {
                    logger.error("Failed setting so_timeout for session timer", (Throwable)e);
                }
                logger.info("Changing processor degree to {}", (Object)SMPPOutboundServerSession.this.getPduProcessorDegree());
                SMPPOutboundServerSession.this.pduReaderWorker.pduExecutor.setMaximumPoolSize(SMPPOutboundServerSession.this.getPduProcessorDegree());
                SMPPOutboundServerSession.this.pduReaderWorker.pduExecutor.setCorePoolSize(SMPPOutboundServerSession.this.getPduProcessorDegree());
            }
        }
    }

    private class PDUReaderWorker
    extends Thread {
        private ThreadPoolExecutor pduExecutor;
        private Runnable onIOExceptionTask;

        PDUReaderWorker(final int queueCapacity) {
            super("PDUReaderWorker-" + SMPPOutboundServerSession.this.getSessionId());
            this.onIOExceptionTask = new Runnable(){

                @Override
                public void run() {
                    SMPPOutboundServerSession.this.close();
                }
            };
            this.pduExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
                    logger.info("Receiving queue is full, please increasing queue capacity, and/or let other side obey the window size");
                    Command pduHeader = ((PDUProcessServerTask)runnable).getPduHeader();
                    if ((pduHeader.getCommandId() & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                        try {
                            boolean success = executor.getQueue().offer(runnable, 60000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                logger.warn("Offer to queue failed for {}", (Object)pduHeader);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        throw new QueueMaxException("Queue capacity " + queueCapacity + " exceeded");
                    }
                }
            });
        }

        @Override
        public void run() {
            logger.info("Starting PDUReaderWorker");
            while (SMPPOutboundServerSession.this.isReadPdu()) {
                this.readPDU();
            }
            logger.info("Close PDUReaderWorker");
            SMPPOutboundServerSession.this.close();
            this.pduExecutor.shutdown();
            try {
                this.pduExecutor.awaitTermination(SMPPOutboundServerSession.this.getTransactionTimer(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for PDU executor pool to finish");
                Thread.currentThread().interrupt();
            }
            logger.debug("{} stopped", (Object)this.getName());
        }

        private void readPDU() {
            Command pduHeader = null;
            try {
                pduHeader = SMPPOutboundServerSession.this.pduReader.readPDUHeader(SMPPOutboundServerSession.this.in);
                byte[] pdu = SMPPOutboundServerSession.this.pduReader.readPDU(SMPPOutboundServerSession.this.in, pduHeader);
                PDUProcessOutboundServerTask task = new PDUProcessOutboundServerTask(pduHeader, pdu, SMPPOutboundServerSession.this.sessionContext, SMPPOutboundServerSession.this.responseHandler, SMPPOutboundServerSession.this.sessionContext, this.onIOExceptionTask);
                this.pduExecutor.execute(task);
            }
            catch (QueueMaxException e) {
                logger.info("Notify other side to throttle: {} ({} threads active)", (Object)e.getMessage(), (Object)this.pduExecutor.getActiveCount());
                try {
                    SMPPOutboundServerSession.this.responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 88, pduHeader.getSequenceNumber());
                }
                catch (IOException ioe) {
                    logger.warn("Failed sending negative response: {}", (Object)ioe.getMessage());
                    SMPPOutboundServerSession.this.close();
                }
            }
            catch (InvalidCommandLengthException e) {
                logger.warn("Received invalid command length: {}", (Object)e.getMessage());
                try {
                    SMPPOutboundServerSession.this.pduSender().sendGenericNack(SMPPOutboundServerSession.this.out, 2, 0);
                }
                catch (IOException ee) {
                    logger.warn("Failed sending generic nack", (Throwable)ee);
                }
                SMPPOutboundServerSession.this.unbindAndClose();
            }
            catch (SocketTimeoutException e) {
                this.notifyNoActivity();
            }
            catch (EOFException e) {
                if (SMPPOutboundServerSession.this.sessionContext.getSessionState() == SessionState.UNBOUND) {
                    logger.debug("Unbound session {} socket closed", (Object)SMPPOutboundServerSession.this.getSessionId());
                } else {
                    logger.warn("Session {} socket closed unexpected", (Object)SMPPOutboundServerSession.this.getSessionId());
                }
                SMPPOutboundServerSession.this.close();
            }
            catch (IOException e) {
                logger.info("Reading PDU session {} in state {}: {}", new Object[]{SMPPOutboundServerSession.this.getSessionId(), SMPPOutboundServerSession.this.getSessionState(), e.getMessage()});
                SMPPOutboundServerSession.this.close();
            }
            catch (RuntimeException e) {
                logger.warn("Runtime error while reading", (Throwable)e);
                SMPPOutboundServerSession.this.close();
            }
        }

        private void notifyNoActivity() {
            logger.debug("No activity notified, sending enquireLink");
            if (SMPPOutboundServerSession.this.sessionContext().getSessionState().isBound()) {
                SMPPOutboundServerSession.this.enquireLinkSender.enquireLink();
            }
        }
    }

    private class OutboundServerResponseHandlerImpl
    implements OutboundServerResponseHandler {
        private OutboundServerResponseHandlerImpl() {
        }

        @Override
        public void processOutbind(Outbind outbind) throws ProcessRequestException {
            SMPPOutboundServerSession.this.outbindRequestReceiver.notifyAcceptOutbind(outbind);
            SMPPOutboundServerSession.this.sessionContext.outbind();
        }

        @Override
        public void processDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
            try {
                SMPPOutboundServerSession.this.fireAcceptDeliverSm(deliverSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing deliver_sm";
                logger.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 100);
            }
        }

        @Override
        public DataSmResult processDataSm(DataSm dataSm) throws ProcessRequestException {
            try {
                return SMPPOutboundServerSession.this.fireAcceptDataSm(dataSm);
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing DataSm";
                logger.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendDataSmResp(DataSmResult dataSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPOutboundServerSession.this.pduSender().sendDataSmResp(SMPPOutboundServerSession.this.out, sequenceNumber, dataSmResult.getMessageId(), dataSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                logger.error("Failed sending data_sm_resp", (Throwable)e);
            }
        }

        @Override
        public PendingResponse<Command> removeSentItem(int sequenceNumber) {
            return SMPPOutboundServerSession.this.removePendingResponse(sequenceNumber);
        }

        @Override
        public void notifyUnbonded() {
            SMPPOutboundServerSession.this.sessionContext.unbound();
        }

        @Override
        public void sendDeliverSmResp(int commandStatus, int sequenceNumber, String messageId) throws IOException {
            SMPPOutboundServerSession.this.pduSender().sendDeliverSmResp(SMPPOutboundServerSession.this.out, commandStatus, sequenceNumber, messageId);
            logger.debug("deliver_sm_resp with sequence_number {} has been sent", (Object)sequenceNumber);
        }

        @Override
        public void sendEnquireLinkResp(int sequenceNumber) throws IOException {
            logger.debug("Sending enquire_link_resp");
            SMPPOutboundServerSession.this.pduSender().sendEnquireLinkResp(SMPPOutboundServerSession.this.out, sequenceNumber);
        }

        @Override
        public void sendGenerickNack(int commandStatus, int sequenceNumber) throws IOException {
            SMPPOutboundServerSession.this.pduSender().sendGenericNack(SMPPOutboundServerSession.this.out, commandStatus, sequenceNumber);
        }

        @Override
        public void sendNegativeResponse(int originalCommandId, int commandStatus, int sequenceNumber) throws IOException {
            SMPPOutboundServerSession.this.pduSender().sendHeader(SMPPOutboundServerSession.this.out, originalCommandId | Integer.MIN_VALUE, commandStatus, sequenceNumber);
        }

        @Override
        public void sendUnbindResp(int sequenceNumber) throws IOException {
            SMPPOutboundServerSession.this.pduSender().sendUnbindResp(SMPPOutboundServerSession.this.out, 0, sequenceNumber);
        }
    }
}

