/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ClusterEndpoints
extends ExplicitlySetBmcModel {
    @JsonProperty(value="kubernetes")
    private final String kubernetes;
    @JsonProperty(value="publicEndpoint")
    private final String publicEndpoint;
    @JsonProperty(value="privateEndpoint")
    private final String privateEndpoint;
    @JsonProperty(value="vcnHostnameEndpoint")
    private final String vcnHostnameEndpoint;

    @Deprecated
    @ConstructorProperties(value={"kubernetes", "publicEndpoint", "privateEndpoint", "vcnHostnameEndpoint"})
    public ClusterEndpoints(String kubernetes, String publicEndpoint, String privateEndpoint, String vcnHostnameEndpoint) {
        this.kubernetes = kubernetes;
        this.publicEndpoint = publicEndpoint;
        this.privateEndpoint = privateEndpoint;
        this.vcnHostnameEndpoint = vcnHostnameEndpoint;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKubernetes() {
        return this.kubernetes;
    }

    public String getPublicEndpoint() {
        return this.publicEndpoint;
    }

    public String getPrivateEndpoint() {
        return this.privateEndpoint;
    }

    public String getVcnHostnameEndpoint() {
        return this.vcnHostnameEndpoint;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterEndpoints(");
        sb.append("super=").append(super.toString());
        sb.append("kubernetes=").append(String.valueOf(this.kubernetes));
        sb.append(", publicEndpoint=").append(String.valueOf(this.publicEndpoint));
        sb.append(", privateEndpoint=").append(String.valueOf(this.privateEndpoint));
        sb.append(", vcnHostnameEndpoint=").append(String.valueOf(this.vcnHostnameEndpoint));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterEndpoints)) {
            return false;
        }
        ClusterEndpoints other = (ClusterEndpoints)((Object)o);
        return Objects.equals(this.kubernetes, other.kubernetes) && Objects.equals(this.publicEndpoint, other.publicEndpoint) && Objects.equals(this.privateEndpoint, other.privateEndpoint) && Objects.equals(this.vcnHostnameEndpoint, other.vcnHostnameEndpoint) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.kubernetes == null ? 43 : this.kubernetes.hashCode());
        result = result * 59 + (this.publicEndpoint == null ? 43 : this.publicEndpoint.hashCode());
        result = result * 59 + (this.privateEndpoint == null ? 43 : this.privateEndpoint.hashCode());
        result = result * 59 + (this.vcnHostnameEndpoint == null ? 43 : this.vcnHostnameEndpoint.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kubernetes")
        private String kubernetes;
        @JsonProperty(value="publicEndpoint")
        private String publicEndpoint;
        @JsonProperty(value="privateEndpoint")
        private String privateEndpoint;
        @JsonProperty(value="vcnHostnameEndpoint")
        private String vcnHostnameEndpoint;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kubernetes(String kubernetes) {
            this.kubernetes = kubernetes;
            this.__explicitlySet__.add("kubernetes");
            return this;
        }

        public Builder publicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
            this.__explicitlySet__.add("publicEndpoint");
            return this;
        }

        public Builder privateEndpoint(String privateEndpoint) {
            this.privateEndpoint = privateEndpoint;
            this.__explicitlySet__.add("privateEndpoint");
            return this;
        }

        public Builder vcnHostnameEndpoint(String vcnHostnameEndpoint) {
            this.vcnHostnameEndpoint = vcnHostnameEndpoint;
            this.__explicitlySet__.add("vcnHostnameEndpoint");
            return this;
        }

        public ClusterEndpoints build() {
            ClusterEndpoints model = new ClusterEndpoints(this.kubernetes, this.publicEndpoint, this.privateEndpoint, this.vcnHostnameEndpoint);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ClusterEndpoints model) {
            if (model.wasPropertyExplicitlySet("kubernetes")) {
                this.kubernetes(model.getKubernetes());
            }
            if (model.wasPropertyExplicitlySet("publicEndpoint")) {
                this.publicEndpoint(model.getPublicEndpoint());
            }
            if (model.wasPropertyExplicitlySet("privateEndpoint")) {
                this.privateEndpoint(model.getPrivateEndpoint());
            }
            if (model.wasPropertyExplicitlySet("vcnHostnameEndpoint")) {
                this.vcnHostnameEndpoint(model.getVcnHostnameEndpoint());
            }
            return this;
        }
    }
}

